//
//  PPiCloudOperation.h
//  
//
//  Created by Mike on 13/4/17.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "NSError+Custom.h"
#import "PPCloudOperation.h"
#import "PPCloudMetadata.h"
#import "PPCloud_iCloud.h"
#import "PPCloud.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloudMetadata (iCloud)
- (id)initWithiCloudURL:(NSURL *)iCloudURL path:(NSString *)path error:(NSError **)error;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPiCloudOperation : PPCloudOperation
{
@protected
    NSString    *ubiquityContainerIdentifier_;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property(nonatomic,retain) NSString    *ubiquityContainerIdentifier;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance methods

- (NSString *)documentPath;
- (NSURL *)URLForUbiquityContainerIdnetifier;
- (NSURL *)URLForCloudPath:(NSString *)cloudPath;
- (NSError *)convertErrorFromSystemError:(NSError *)systemError;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class methods

+ (NSURL *)URLForUbiquityContainerIdnetifier:(NSString *)ubiquityContainerIdentifier;

@end
