//
//  PPCloud_OneDrive.m
//  
//
//  Created by Mike on 13-3-11.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloud_OneDrive.h"
#import "PPCloud+Private.h"
#import "PPOneDriveOperation_Copy.h"
#import "PPOneDriveOperation_CreateFolder.h"
#import "PPOneDriveOperation_Delete.h"
#import "PPOneDriveOperation_Link.h"
#import "PPOneDriveOperation_LoadAccountInfo.h"
#import "PPOneDriveOperation_LoadFile.h"
#import "PPOneDriveOperation_LoadMetadata.h"
#import "PPOneDriveOperation_LoadThumbnail.h"
#import "PPOneDriveOperation_Move.h"
#import "PPOneDriveOperation_Unlink.h"
#import "PPOneDriveOperation_UploadFile.h"
#import "PPOneDriveOperation_Sharedlink.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPCloud_ParameterKey_OneDriveAppKey       = @"PPCloud_ParameterKey_OneDriveAppKey";
NSString *PPCloud_ParameterKey_OneDriveAppSecret    = @"PPCloud_ParameterKey_OneDriveAppSecret";

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloud_OneDrive()

@interface PPCloud_OneDrive()    <
                                PPOneDriveOperationDelegate_Copy,
                                PPOneDriveOperationDelegate_CreateFolder,
                                PPOneDriveOperationDelegate_Delete,
                                PPOneDriveOperationDelegate_Link,
                                PPOneDriveOperationDelegate_LoadAccountInfo,
                                PPOneDriveOperationDelegate_LoadFile,
                                PPOneDriveOperationDelegate_LoadMetadata,
                                PPOneDriveOperationDelegate_LoadThumbnail,
                                PPOneDriveOperationDelegate_Move,
                                PPOneDriveOperationDelegate_Unlink,
                                PPOneDriveOperationDelegate_UploadFile,
                                PPOneDriveOperationDelegate_Sharedlink
                                >
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloudAccountInfo (OneDrive)
- (id)initWithODClient:(ODClient *)odClient odDrive:(ODDrive *)odDrive;
@end

@implementation PPCloudAccountInfo (Dropbox)
- (id)initWithODClient:(ODClient *)odClient odDrive:(ODDrive *)odDrive
{
    if((self=[super init]))
    {
        cloudClassName_ = [NSStringFromClass([PPCloud_OneDrive class]) retain];
        userID_         = [[odClient.authProvider accountSession].serviceInfo.userEmail retain];
        displayName_    = [odDrive.owner.user.displayName retain];
        
        totalBytes_     = [[NSNumber numberWithLongLong:odDrive.quota.total] retain];
        usedBytes_      = [[NSNumber numberWithLongLong:odDrive.quota.used] retain];
        rawData_        = [odClient retain];
    }
    
    return self;
}
@end

@interface PPCloudMetadata (OneDrive)

- (id)initWithOneDriveItem:(ODItem *)odItem subPathes:(NSArray *)subPathes;

@end

@implementation PPCloudMetadata (OneDrive)

- (id)initWithOneDriveItem:(ODItem *)odItem subPathes:(NSArray *)subPathes
{
    if((self=[super init]))
    {
        cloudClassName_     = [NSStringFromClass([PPCloud_OneDrive class]) retain];
        path_               = [odItem.parentReference.path retain];
        lastModifiedDate_   = [odItem.lastModifiedDateTime retain];
        uniqueID_           = [odItem.id retain];
        fileHash_           = [odItem.file.hashes.crc32Hash retain];
        fileSize_           = [@(odItem.size) retain];
        fileName_           = [odItem.name retain];
        isDirectory_        = (odItem.folder == nil) ? NO : YES ;
        thumbnailExists_    = (odItem.thumbnails == nil) ? NO : YES ;
        
        //////////////////////////////////////////////////
        contents_ = [subPathes copy] ;
    }
    
    return self;
}

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloud_OneDrive





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)initWithOperationQueue:(NSOperationQueue *)operationQueue
{
    do
    {
        NSString *appKey = [PPCloud parameterForKey:PPCloud_ParameterKey_OneDriveAppKey];
        if(appKey==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
//        NSString *appSecret = [PPCloud parameterForKey:PPCloud_ParameterKey_OneDriveAppSecret];
//        if(appSecret==nil)
//        {
//            break;
//        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if((self=[super initWithOperationQueue:operationQueue]))
        {
            [ODClient setMicrosoftAccountAppId:appKey scopes:@[@"onedrive.readwrite",@"onedrive.appfolder", @"offline_access"]];
        }
        
    }while(0);
    
    return self;
}

//================================================================================
//
//================================================================================
- (void)dealloc
{
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

//================================================================================
//
//================================================================================
- (BOOL)isLinked
{
    ODClient *currentClient = [ODClient loadCurrentClient];

    if (currentClient == nil)
    {
        return NO;
    }
    else
    {
        return YES;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (BOOL)handleOpenURL:(NSURL *)url
{
    // OneDriveSDK不會從open url回來，所以直接回傳NO，表示不處理
    return NO;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Copy

//================================================================================
//
//================================================================================
- (BOOL)copyFrom:(NSString*)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_Copy *operation = [[PPOneDriveOperation_Copy alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.fromPath  = fromPath;
            operation.toPath    = toPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_Copy

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Copy *)operation copyPathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:copyPathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  copyPathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Copy *)operation copiedPath:(NSString *)path to:(ODItem *)to
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:copiedPath:to:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithOneDriveItem:to subPathes:nil];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                   copiedPath:path
                           to:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_CreateFolder

//================================================================================
//
//================================================================================
- (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_CreateFolder *operation = [[PPOneDriveOperation_CreateFolder alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.createFolder = createFolder;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_CreateFolder

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_CreateFolder *)operation createFolderFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createFolderFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self createFolderFailedWithError:error userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_CreateFolder *)operation createdFolder:(ODItem *)folder
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createdFolder:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithOneDriveItem:folder subPathes:nil];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                createdFolder:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Delete

//================================================================================
//
//================================================================================
- (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_Delete *operation = [[PPOneDriveOperation_Delete alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.deletePath = deletePath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_Delete

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Delete *)operation deletePathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
deletePathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Delete *)operation deletedPath:(NSString *)path
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePath:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               deletePath:path
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Link

//================================================================================
//
//================================================================================
- (BOOL)linkFromController:(UIViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    PPOneDriveOperation_Link *operation = [[PPOneDriveOperation_Link alloc] init];
    
    if(operation!=nil)
    {
        operation.delegate  = self;
        operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        operation.viewcontroller = viewcontroller;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSArray *operations = self.operationQueue.operations;
        
        for(NSOperation *OneDriveOperation in operations)
        {
            if([OneDriveOperation isKindOfClass:[PPOneDriveOperation_Link class]]==YES)
            {
                [OneDriveOperation cancel];
            }
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [self addOperation:operation];
        
        [operation release];
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_Link

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Link *)operation linkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:linkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self linkFailedWithError:error userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperationLinkSuccess:(PPOneDriveOperation_Link *)operation
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:linkSuccessWithUserInfo:)]==YES)
    {
        [delegate ppCloud:self linkSuccessWithUserInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadAccountInfo

//================================================================================
//
//================================================================================
- (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_LoadAccountInfo *operation = [[PPOneDriveOperation_LoadAccountInfo alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_LoadAccountInfo

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadAccountInfo *)operation loadAccountInfoFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadAccountInfoFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self loadAccountInfoFailedWithError:error userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadAccountInfo *)operation loadedAccountInfo:(ODClient *)info driveInfo:(ODDrive *)drive
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedAccountInfo:userInfo:)]==YES)
    {
        PPCloudAccountInfo *ppCloudAccountInfo = [[PPCloudAccountInfo alloc] initWithODClient:info odDrive:drive];
        if(ppCloudAccountInfo!=nil)
        {
            [delegate ppCloud:self loadedAccountInfo:ppCloudAccountInfo userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudAccountInfo release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadFile

//================================================================================
//
//================================================================================
- (BOOL)loadFileFromPath:(NSString *)filePath orFileID:(NSString *)fileID intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadFile>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_LoadFile *operation = [[PPOneDriveOperation_LoadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadFile = filePath;
            operation.intoPath = intoPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_LoadFile

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadFile *)operation loadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  loadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadFile *)operation loadedFile:(NSString *)destPath contentType:(NSString *)contentType
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               loadedFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadFile *)operation loadProgress:(CGFloat)progress forFile:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadProgress:forFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
             loadProgress:progress
                  forFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadMetadata

//================================================================================
//
//================================================================================
- (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_LoadMetadata *operation = [[PPOneDriveOperation_LoadMetadata alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadMetadata = loadMetadata;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveLoadMetadataOperationDelegate

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadMetadata *)operation loadMetadataFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadMetadataFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadMetadataFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadMetadata *)operation loadedMetadata:(ODItem *)metadata subPathes:(NSArray *)subPathes
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedMetadata:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithOneDriveItem:metadata subPathes:subPathes];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
               loadedMetadata:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadMetadata *)operation metadataUnchangedAtPath:(NSString *)path
{
    //mike目前沒辦法處理
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadThumbnail

//================================================================================
//
//================================================================================
- (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSString *ofSize = nil;
        
        if([size isEqualToString:PPCloud_ThumbnailSize_Maximum]==YES || [size isEqualToString:PPCloud_ThumbnailSize_Large]==YES)
        {
            ofSize = PPOneDriveThumbnailSize_Large;
        }
        else if([size isEqualToString:PPCloud_ThumbnailSize_Medium]==YES)
        {
            ofSize = PPOneDriveThumbnailSize_Medium;
        }
        else if([size isEqualToString:PPCloud_ThumbnailSize_Minimum]==YES || [size isEqualToString:PPCloud_ThumbnailSize_Small]==YES)
        {
            ofSize = PPOneDriveThumbnailSize_Small;
        }
        else
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_LoadThumbnail *operation = [[PPOneDriveOperation_LoadThumbnail alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadThumbnail = loadThumbnail;
            operation.ofSize        = ofSize;
            operation.intoPath      = intoPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_LoadThumbnail

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadThumbnail *)operation loadThumbnailFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadThumbnailFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self loadThumbnailFailedWithError:error userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_LoadThumbnail *)operation loadedThumbnail:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedThumbnail:userInfo:)]==YES)
    {
        [delegate ppCloud:self
          loadedThumbnail:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Move

//================================================================================
//
//================================================================================
- (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_Move *operation = [[PPOneDriveOperation_Move alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.moveFrom  = moveFrom;
            operation.toPath    = toPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_Move

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Move *)operation movePathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:movePathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self movePathFailedWithError:error userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Move *)operation movedPath:(NSString *)path to:(ODItem *)to
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:movedPath:to:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithOneDriveItem:to subPathes:nil];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                    movedPath:path
                           to:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Unlink

//================================================================================
//
//================================================================================
- (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_Unlink *operation = [[PPOneDriveOperation_Unlink alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_Unlink


//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Unlink *)operation unlinkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:unlinkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self  unlinkFailedWithError:error userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppOneDriveOperationUnlinkSuccess:(PPOneDriveOperation_Unlink *)operation
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:unlinkSuccessWithUserInfo:)]==YES)
    {
        [delegate ppCloud:self unlinkSuccessWithUserInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_UploadFile

//================================================================================
//
//================================================================================
- (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_UploadFile *operation = [[PPOneDriveOperation_UploadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.uploadFile    = filename;
            operation.toPath        = toPath;
            operation.fromPath      = fromPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_UploadFile

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_UploadFile *)operation uploadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
uploadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_UploadFile *)operation uploadedFile:(NSString *)destPath from:(NSString *)srcPath metadata:(ODItem *)metadata
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadedFile:from:metadata:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithOneDriveItem:metadata  subPathes:nil];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                 uploadedFile:destPath
                         from:srcPath
                     metadata:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_UploadFile *)operation uploadProgress:(CGFloat)progress forFile:(NSString *)destPath from:(NSString *)srcPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadProgress:forFile:from:userInfo:)]==YES)
    {
        [delegate ppCloud:self
           uploadProgress:progress
                  forFile:destPath
                     from:srcPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Sharedlink

//================================================================================
//
//================================================================================
- (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPOneDriveOperation_Sharedlink *operation = [[PPOneDriveOperation_Sharedlink alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.sharedlinkFile = sharedlinkFile;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperationDelegate_Sharedlink

//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Sharedlink *)operation sharedlinkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if (delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:sharedlinkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self sharedlinkFailedWithError:error userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppOneDriveOperation:(PPOneDriveOperation_Sharedlink *)operation sharedlinkString:(NSString *)sharedlink
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if (delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:sharedlinkString:userInfo:)]==YES)
    {
        [delegate ppCloud:self sharedlinkString:sharedlink userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

@end
