//
//  PPOneDriveOperation_UploadFile.m
//  
//
//  Created by Mike on 13/3/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_UploadFile.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPOneDriveOperation_UploadFileChunkThreshold (100*1024*1024)

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPOneDriveOperation_UploadFile ()
@property (nonatomic, assign) unsigned long long totalSize;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPOneDriveOperation_UploadFile

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize uploadFile  = uploadFile_;
@synthesize toPath      = toPath_;
@synthesize fromPath    = fromPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [uploadFile_ release];
    [toPath_ release];
    [fromPath_ release];
	
    self.uploadTask = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.uploadFile==nil || self.toPath==nil || self.fromPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSDictionary *fileAttributes = [[NSFileManager defaultManager] attributesOfItemAtPath:self.fromPath error:&error];
            if(error!=nil)
            {
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSNumber *fileSizeNumber = [fileAttributes objectForKey:NSFileSize];;
            if(fileSizeNumber==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            self.totalSize = [fileSizeNumber unsignedLongLongValue];
            
            //////////////////////////////////////////////////
            
            // 去除路徑開頭的'/'和檔案名稱，只留下Path
            // !! chunk upload的方式可參考 https://github.com/OneDrive/onedrive-sdk-ios/issues/52，需要再survey
            self.toPath = [[self.toPath substringFromIndex:1] stringByAppendingPathComponent:self.uploadFile];
            
            ODItemContentRequest *request = [[[self.odClient root] itemByPath:self.toPath] contentRequest];
            
            __block typeof(self) blockSelf = self;
            
            self.uploadTask = [request uploadFromFile:[NSURL fileURLWithPath:self.fromPath] completion:^(ODItem *response, NSError *error){
                
                if(error!=nil)
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:uploadFileFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf uploadFileFailedWithError:error];
                    }
                    
                }
                else
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:uploadedFile:from:metadata:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf uploadedFile:response.parentReference.path from:blockSelf.fromPath metadata:response];
                    }
                }
                
                [blockSelf completion];
                
            }];
            
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Canceling Operations

- (void)cancel
{
    [super cancel];
    
    //////////////////////////////////////////////////
    
    if(self.finished==NO)
    {
        if(self.executing==YES)
        {
            [self.uploadTask cancel];
            
            [self setExecuting:NO];
        }
        
        [self setFinished:YES];
    }
}


@end
