//
//  PPOneDriveOperation_Move.m
//  
//
//  Created by Mike on 13/3/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_Move.h"

@implementation PPOneDriveOperation_Move

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize moveFrom    = moveFrom_;
@synthesize toPath      = toPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [moveFrom_ release];
    [toPath_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.moveFrom==nil || self.toPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                if([self.delegate respondsToSelector:@selector(ppOneDriveOperation:movePathFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self movePathFailedWithError:error];
                }
                
                [self completion];
                break;
            }
            
            //////////////////////////////////////////////////
            // 產生Move目標的ParentRef
            
            ODItemReference *parentRef = [[ODItemReference alloc] init];
            parentRef.path = [NSString stringWithFormat:@"/drive/root:%@", [self.toPath stringByDeletingLastPathComponent]];
            
            ODItem *updatedItem = [[ODItem alloc] init];
            updatedItem.parentReference = parentRef;
            updatedItem.name = [self.toPath lastPathComponent];
            
            //////////////////////////////////////////////////
            // 去除路徑開頭的'/'
            self.moveFrom = [self.moveFrom substringFromIndex:1];
            
            __block typeof(self) blockSelf = self;
            
            ODItemRequest *moveRequest = [[[self.odClient root] itemByPath:self.moveFrom] request];
            
            [moveRequest update:updatedItem withCompletion:^(ODItem *newItem, NSError *error){
                
                if(error!=nil)
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:movePathFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf movePathFailedWithError:error];
                    }
                }
                else
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:movedPath:to:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf movedPath:blockSelf.moveFrom to:newItem];
                    }
                }
                
                [blockSelf completion];
                
            }];
            
            [updatedItem release];
            [parentRef release];
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        
    }
}


@end
