//
//  PPOneDriveOperation_LoadMetadata.m
//  
//
//  Created by Mike on 13-3-13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_LoadMetadata.h"

@implementation PPOneDriveOperation_LoadMetadata

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadMetadata    = loadMetadata_;
@synthesize hash            = hash_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects
    

//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [loadMetadata_ release];
    [hash_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
	
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation
    
    
//==============================================================================
//
//==============================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.loadMetadata==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                if([self.delegate respondsToSelector:@selector(ppOneDriveOperation:loadMetadataFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self loadMetadataFailedWithError:error];
                }
                [self completion];
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            // 去除路徑開頭的'/'
            self.loadMetadata = [self.loadMetadata substringFromIndex:1];
            
            __block typeof(self) blockSelf = self;
            
            [self getSubPathesFromPath:self.loadMetadata completion:^(ODItem *response, NSError *error, NSArray *subpaths) {
                
                if(error!=nil)
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadMetadataFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf loadMetadataFailedWithError:error];
                    }
                }
                else
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadedMetadata:subPathes:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf loadedMetadata:response subPathes:subpaths];
                    }
                }
                
                [blockSelf completion];
            }];
        
        }while(0);
    }
}

    
//==============================================================================
//
//==============================================================================
- (NSArray *)subPathesWithItemID:(NSString *)itemID parentPath:(NSString *)parentPath
{
    __block NSError *returnError = nil;
    __block BOOL executing = YES;

    NSMutableArray *subpaths = [NSMutableArray array];

    [[[[[self.odClient drive] items:itemID] children] request] getWithCompletion:^(ODCollection *children, ODChildrenCollectionRequest *nextRequest, NSError *error){
        
        if (error)
        {
            returnError = [error retain];
        }
        else
        {
            for (ODItem *item in children.value)
            {
                if(item.folder==nil)
                {
                    [subpaths addObject:[NSString stringWithFormat:@"/%@/%@", parentPath, item.name]];
                }
            }
        }
        executing = NO;
    }];
    
    while (executing)
    {
        [NSThread sleepForTimeInterval:0.01];
    }
    
    return subpaths;
}
    
    
//==============================================================================
//
//==============================================================================
- (void)getSubPathesFromPath:(NSString *)path completion:(void(^)(ODItem *response, NSError *error, NSArray *subpaths))completion
{
    __block typeof(self) blockSelf = self;
    __block NSError *returnError = nil;
    __block ODItem *returnResponse = nil;
    __block BOOL executing = YES;
    NSArray *subPathes = nil;

    //////////////////////////////////////////////////
    // get current path item
    [[[[self.odClient root] itemByPath:path] request] getWithCompletion:^(ODItem *response, NSError *error){
         returnError = [error retain];
         returnResponse = [response retain];
         executing = NO;
     }];
    
    while (executing)
    {
        [NSThread sleepForTimeInterval:0.01];
    }
    
    //////////////////////////////////////////////////
    // get sub path
    
    if (returnResponse.folder)
    {
        subPathes = [blockSelf subPathesWithItemID:returnResponse.id parentPath:path];
    }
    
    //////////////////////////////////////////////////
    if (completion)
    {
        completion(returnResponse, returnError, subPathes);
        [returnError release];
        [returnResponse release];
    }
}


@end
