//
//  PPOneDriveOperation_LoadFile.m
//  
//
//  Created by Mike on 13-3-14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_LoadFile.h"

@implementation PPOneDriveOperation_LoadFile

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadFile    = loadFile_;
@synthesize intoPath    = intoPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [loadFile_ release];
    [intoPath_ release];
	
    self.downloadTask = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.loadFile==nil || self.intoPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                if([self.delegate respondsToSelector:@selector(ppOneDriveOperation:loadFileFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self loadFileFailedWithError:error];
                }
                
                [self completion];

                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            __block typeof(self) blockSelf = self;
            
            // 去除路徑開頭的'/'
            self.loadFile = [self.loadFile substringFromIndex:1];
            
            self.downloadTask =
            
            [[[[self.odClient root] itemByPath:self.loadFile] contentRequest] downloadWithCompletion:^(NSURL *location, NSURLResponse *response, NSError *error) {
                
                if(error!=nil)
                {
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadFileFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf loadFileFailedWithError:error];
                    }
                    
                }
                else
                {
                    [[NSFileManager defaultManager] moveItemAtURL:location toURL:[NSURL fileURLWithPath:blockSelf.intoPath] error:nil];
                    
                    if([blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:loadedFile:contentType:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf loadedFile:blockSelf.intoPath contentType:nil];
                    }
                }
                
                [blockSelf completion];
            }];
            
            
        }while(0);
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Canceling Operations

- (void)cancel
{
    [super cancel];
    
    //////////////////////////////////////////////////
    
    if(self.finished==NO)
    {
        if(self.executing==YES)
        {
            [self.downloadTask cancel];
            
            [self setExecuting:NO];
        }
        
        [self setFinished:YES];
    }
}


@end
