//
//  PPOneDriveOperation_Delete.m
//  
//
//  Created by Mike on 13-3-14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_Delete.h"

@implementation PPOneDriveOperation_Delete

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize deletePath = deletePath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [deletePath_ release];
	
	////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.deletePath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppOneDriveOperation:deletePathFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self deletePathFailedWithError:error];
                }
                [self completion];
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            __block typeof(self) blockSelf = self;
            
            self.deletePath = [self.deletePath substringFromIndex:1];
            
            [[[[self.odClient root] itemByPath:self.deletePath] request] deleteWithCompletion:^(NSError *error){
                
                if(error!=nil)
                {
                    if(blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:deletePathFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf deletePathFailedWithError:error];
                    }
                }
                else
                {
                    if(blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:deletedPath:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf deletedPath:blockSelf.deletePath];
                    }
                }
                
                [blockSelf completion];
            }];
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        
    }
}


@end
