//
//  PPOneDriveOperation_CreateFolder.m
//  
//
//  Created by Mike on 13-3-13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation_CreateFolder.h"

@implementation PPOneDriveOperation_CreateFolder

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize createFolder = createFolder_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [createFolder_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
	
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.createFolder==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppOneDriveOperation:createFolderFailedWithError:)]==YES)
                {
                    [self.delegate ppOneDriveOperation:self createFolderFailedWithError:error];
                }
                [self completion];
                break;
            }
            
            //////////////////////////////////////////////////
            
            // 取得所欲創建的資料夾名稱
            NSString *folderName = [self.createFolder lastPathComponent];
            
            // 拿掉Path開頭的'/'
            NSString *parentPath = [[self.createFolder stringByDeletingLastPathComponent] substringFromIndex:1];
            
            // Generate NewFolder ODItem
            ODItem *newFolder = [[[ODItem alloc] initWithDictionary:@{[ODNameConflict fail].key : [ODNameConflict fail].value}] autorelease];
            newFolder.name = folderName;
            newFolder.folder = [[[ODFolder alloc] init] autorelease];
        
            __block typeof(self) blockSelf = self;
            
            [[[[[blockSelf.odClient root] itemByPath:parentPath] children] request] addItem:newFolder withCompletion:^(ODItem *response, NSError *error)
            {
                if(error!=nil)
                {
                    if(blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:createFolderFailedWithError:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf createFolderFailedWithError:error];
                    }
                }
                else
                {
                    if(blockSelf.delegate!=nil && [blockSelf.delegate respondsToSelector:@selector(ppOneDriveOperation:createdFolder:)]==YES)
                    {
                        [blockSelf.delegate ppOneDriveOperation:blockSelf createdFolder:response];
                    }
                }
                
                [blockSelf completion];
            }];
            
        }while(0);
        
        //////////////////////////////////////////////////

        
        
    }
}


@end
