//
//  PPOneDriveOperation.m
//  
//
//  Created by Mike on 13-3-12.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPOneDriveOperation.h"






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPOneDriveOperation()

@interface PPOneDriveOperation()

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPOneDriveOperation

@implementation PPOneDriveOperation





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if((self=[super init]))
    {
        // 載入目前的ODClient，以進行所有雲端操作
        // (沒有Login的話，CurrentClient就會是nil)
        self.odClient = [ODClient loadCurrentClient];
    }
    
    //////////////////////////////////////////////////
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.odClient = nil;
   
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)start
{
    if([self isCancelled]==YES)
    {
        [self setFinished:YES];
    }
    else
    {
        [self setExecuting:YES];
        
        // OneDrive要在mainthread做
        [self performSelectorOnMainThread:@selector(main)
                               withObject:nil
                            waitUntilDone:NO];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Instance methods

//================================================================================
//
//================================================================================
- (NSError *)convertErrorFromSystemError:(NSError *)systemError
{
    NSError *convertError = systemError;
    NSString *errorMsg = [systemError.userInfo objectForKey:@"error"];
    
    if([errorMsg length] > 0)
    {
        convertError = PPErrorMake(systemError.code,
                                   errorMsg,
                                   systemError.userInfo);
    }
    
    return convertError;
}


@end
