//
//  PPCloud_GoogleDrive.m
//  
//
//  Created by Mike on 13/4/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloud_GoogleDrive.h"

// Define
#import "PPCloud+ParameterDefine.h"
#import "PPCloud+Private.h"
#import "PPGoogleDriveOperation_Copy.h"
#import "PPGoogleDriveOperation_CreateFolder.h"
#import "PPGoogleDriveOperation_Delete.h"
#import "PPGoogleDriveOperation_Link.h"
#import "PPGoogleDriveOperation_LoadAccountInfo.h"
#import "PPGoogleDriveOperation_LoadFile.h"
#import "PPGoogleDriveOperation_LoadMetadata.h"
#import "PPGoogleDriveOperation_LoadThumbnail.h"
#import "PPGoogleDriveOperation_Move.h"
#import "PPGoogleDriveOperation_Unlink.h"
#import "PPGoogleDriveOperation_UploadFile.h"
#import "PPGoogleDriveOperation_Sharedlink.h"

// Category
#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPCloud_ParameterKey_GoogleDriveClientID          = @"PPCloud_ParameterKey_GoogleDriveClientID";
NSString *PPCloud_ParameterKey_GoogleDriveClientSecret      = @"PPCloud_ParameterKey_GoogleDriveClientSecret";
NSString *PPCloud_ParameterKey_GoogleDriveKeychainItemName  = @"PPCloud_ParameterKey_GoogleDriveKeychainItemName";

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloudAccountInfo (GoogleDrive)
- (id)initWithGoogleDriveAccountInfo:(GTLRDrive_About *)googleDriveAccountInfo;
@end

@implementation PPCloudAccountInfo (GoogleDrive)
- (id)initWithGoogleDriveAccountInfo:(GTLRDrive_About *)googleDriveAccountInfo
{
    if((self=[super init]))
    {
        cloudClassName_ = [NSStringFromClass([PPCloud_GoogleDrive class]) retain];
        displayName_    = [googleDriveAccountInfo.user.displayName retain];
        userID_         = [[GTLRDriveService sharedServiceDrive].authorizer.userEmail retain];
        totalBytes_     = [googleDriveAccountInfo.storageQuota.limit retain];
        usedBytes_      = [googleDriveAccountInfo.storageQuota.usage retain];
        rawData_        = [googleDriveAccountInfo retain];
    }
    
    return self;
}
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloudMetadata (GoogleDrive)
- (id)initWithGoogleDriveMetadata:(NSDictionary *)googleDriveMetadata path:(NSString *)path;
@end

@implementation PPCloudMetadata (GoogleDrive)


//================================================================================
//
//================================================================================
- (id)initWithGoogleDriveMetadata:(NSDictionary *)googleDriveMetadata path:(NSString *)path
{
    if((self=[super init]))
    {
        cloudClassName_     = [NSStringFromClass([PPCloud_GoogleDrive class]) retain];
        path_               = [path retain];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        GTLRDrive_File *file = [googleDriveMetadata objectForKey:NSStringFromClass([GTLRDrive_File class])];
        if(file!=nil)
        {
            lastModifiedDate_   = [file.modifiedTime.date retain];
            uniqueID_           = [file.identifier retain];
            thumbnailExists_    = (file.thumbnailLink!=nil);
            isDirectory_        = [file.mimeType isEqualToString:GTLDriveFile_MimeType_Folder];
            
            if(self.isDirectory==NO)
            {
                fileHash_   = [file.md5Checksum retain];
                fileName_   = [file.name retain];
                fileSize_   = [file.quotaBytesUsed retain];
            }
            else
            {
                NSMutableArray *contents = [[NSMutableArray alloc] init];
               
                if(contents!=nil)
                {
                    GTLRDrive_FileList *fileList = [googleDriveMetadata objectForKey:NSStringFromClass([GTLRDrive_FileList class])];

                    
                    NSMutableArray <GTLRDrive_File *> *entries = [NSMutableArray arrayWithArray:fileList.files];
                    
                    [entries sortUsingComparator:^NSComparisonResult( GTLRDrive_File *obj1, GTLRDrive_File *obj2) {
                        return [obj1.name unicodeCompare:obj2.name];
                    }];

                    //////////////////////////////////////////////////

                    // FileList files 順序要與排序過一致
                    fileList.files = entries;
                    
                    //////////////////////////////////////////////////

                    for(GTLRDrive_File *subFile in entries)
                    {
                        [contents addObject:[path stringByAppendingPathComponent:subFile.name]];
                    }
                    
                    contents_ = [[NSArray alloc] initWithArray:contents];
                    
                    [contents release];
                }
            }
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        rawData_    = [googleDriveMetadata retain];
    }
    
    return self;
}
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloud_GoogleDrive()

@interface PPCloud_GoogleDrive()    <
                                    PPGoogleDriveOperationDelegate_Copy,
                                    PPGoogleDriveOperationDelegate_CreateFolder,
                                    PPGoogleDriveOperationDelegate_Delete,
                                    PPGoogleDriveOperationDelegate_Link,
                                    PPGoogleDriveOperationDelegate_LoadAccountInfo,
                                    PPGoogleDriveOperationDelegate_LoadFile,
                                    PPGoogleDriveOperationDelegate_LoadMetadata,
                                    PPGoogleDriveOperationDelegate_LoadThumbnail,
                                    PPGoogleDriveOperationDelegate_Move,
                                    PPGoogleDriveOperationDelegate_Unlink,
                                    PPGoogleDriveOperationDelegate_UploadFile,
                                    PPGoogleDriveOperationDelegate_Sharedlink
                                    >

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloud_GoogleDrive






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects


//================================================================================
//
//================================================================================
- (id)initWithOperationQueue:(NSOperationQueue *)operationQueue
{
    id object = nil;
    
    do
    {
        NSString *clientID = [PPCloud parameterForKey:PPCloud_ParameterKey_GoogleDriveClientID];
        if(clientID==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        // !! ios的clientSecrect可能是空的
        NSString *clientSecret = [PPCloud parameterForKey:PPCloud_ParameterKey_GoogleDriveClientSecret];
//        if(clientSecret==nil)
//        {
//            break;
//        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSString *keychainItemName = [PPCloud parameterForKey:PPCloud_ParameterKey_GoogleDriveKeychainItemName];
        if(keychainItemName==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if((self=[super initWithOperationQueue:operationQueue]))
        {
            GTLRDriveService *serviceDrive = [[GTLRDriveService alloc] init];
            if(serviceDrive!=nil)
            {
                serviceDrive.identifierForFolderDictionary = [[[NSMutableDictionary alloc] init] autorelease];
                
                //////////////////////////////////////////////////

                // !! 如果有舊的先轉成新的存起來
                GTMAppAuthFetcherAuthorization *oldAuthentication = [GTMOAuth2KeychainCompatibility authForGoogleFromKeychainForName:keychainItemName
                                                                                                                            clientID:clientID
                                                                                                                        clientSecret:clientSecret];
                if(oldAuthentication!=nil)
                {
                    [GTMAppAuthFetcherAuthorization saveAuthorization:oldAuthentication
                                                    toKeychainForName:keychainItemName];
                }

                //////////////////////////////////////////////////
                GTMAppAuthFetcherAuthorization *currentAuthentication = [GTMAppAuthFetcherAuthorization authorizationFromKeychainForName:keychainItemName];
                serviceDrive.authorizer = currentAuthentication;

                object = self;

                [GTLRDriveService setSharedServiceDrive:serviceDrive];

                [serviceDrive release];
            }


//            GTLServiceDrive *serviceDrive = [[GTLRDriveService alloc] init];
//            if(serviceDrive!=nil)
//            {
//                serviceDrive.shouldFetchNextPages   = YES;
//
//                // !! 如果有舊的先轉成新的存起來
//                GTMAppAuthFetcherAuthorization *oldAuthentication = [GTMOAuth2KeychainCompatibility authForGoogleFromKeychainForName:keychainItemName
//                                                                                                                            clientID:clientID
//                                                                                                                        clientSecret:clientSecret];
//                if(oldAuthentication!=nil)
//                {
//                    [GTMAppAuthFetcherAuthorization saveAuthorization:oldAuthentication
//                                                    toKeychainForName:keychainItemName];
//                }
//
//                //////////////////////////////////////////////////
//                GTMAppAuthFetcherAuthorization *currentAuthentication = [GTMAppAuthFetcherAuthorization authorizationFromKeychainForName:keychainItemName];
//                serviceDrive.authorizer = currentAuthentication;
//
//                object = self;
//
//                [GTLRDriveService setSharedServiceDrive:serviceDrive];
//
//                [serviceDrive release];
//            }
        }
        
    }while(0);
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [GTLRDriveService setSharedServiceDrive:nil];
    [GTLRDriveService setSharedServiceDrive:nil];

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods


//================================================================================
//
//================================================================================
- (BOOL)isLinked
{
//    return ([GTLRDriveService sharedServiceDrive].authorizer.userEmail!=nil);
    return ([GTLRDriveService sharedServiceDrive].authorizer.userEmail!=nil);
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods


//================================================================================
//
//================================================================================
- (BOOL)handleOpenURL:(NSURL *)url
{
    BOOL result = NO;
    
    NSArray *operations = self.operationQueue.operations;
    
    for(NSOperation *operation in operations)
    {
        if([operation isKindOfClass:[PPGoogleDriveOperation_Link class]]==YES)
        {
            result = [(PPGoogleDriveOperation_Link *)operation handleOpenURL:url];
            
            break;
        }
    }
    
    return result;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Copy


//================================================================================
//
//================================================================================
- (BOOL)copyFrom:(NSString*)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_Copy *operation = [[PPGoogleDriveOperation_Copy alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.fromPath  = fromPath;
            operation.toPath    = toPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_Copy


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Copy *)operation copyPathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:copyPathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  copyPathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Copy *)operation copiedPath:(NSString *)path to:(NSDictionary *)to
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:copiedPath:to:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithGoogleDriveMetadata:to path:operation.toPath];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                   copiedPath:path
                           to:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_CreateFolder


//================================================================================
//
//================================================================================
- (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_CreateFolder *operation = [[PPGoogleDriveOperation_CreateFolder alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.createFolder = createFolder;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_CreateFolder


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_CreateFolder *)operation createFolderFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createFolderFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
createFolderFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_CreateFolder *)operation createdFolder:(NSDictionary *)folder
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createdFolder:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithGoogleDriveMetadata:folder path:operation.createFolder];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                createdFolder:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Delete


//================================================================================
//
//================================================================================
- (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_Delete *operation = [[PPGoogleDriveOperation_Delete alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.deletePath = deletePath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_Delete


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Delete *)operation deletePathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
deletePathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Delete *)operation deletedPath:(NSString *)path
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePath:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               deletePath:path
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Link


//================================================================================
//
//================================================================================
- (BOOL)linkFromController:(CPCLViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    PPGoogleDriveOperation_Link *operation = [[PPGoogleDriveOperation_Link alloc] init];
    
    if(operation!=nil)
    {
        operation.delegate  = self;
        operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        operation.viewController = viewcontroller;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSArray *operations = self.operationQueue.operations;
        
        for(NSOperation *dropboxOperation in operations)
        {
            if([dropboxOperation isKindOfClass:[PPGoogleDriveOperation_Link class]]==YES)
            {
                [dropboxOperation cancel];
            }
        }

        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [self addOperation:operation];
        
        [operation release];
    }
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_Link


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Link *)operation linkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:linkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
      linkFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperationLinkSuccess:(PPGoogleDriveOperation_Link *)operation
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:linkSuccessWithUserInfo:)]==YES)
    {
        [delegate ppCloud:self
  linkSuccessWithUserInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadAccountInfo


//================================================================================
//
//================================================================================
- (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_LoadAccountInfo *operation = [[PPGoogleDriveOperation_LoadAccountInfo alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_LoadAccountInfo


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadAccountInfo *)operation loadAccountInfoFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadAccountInfoFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadAccountInfoFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadAccountInfo *)operation loadedAccountInfo:(GTLRDrive_About *)info
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedAccountInfo:userInfo:)]==YES)
    {
        PPCloudAccountInfo *ppCloudAccountInfo = [[PPCloudAccountInfo alloc] initWithGoogleDriveAccountInfo:info];
        if(ppCloudAccountInfo!=nil)
        {
            [delegate ppCloud:self
            loadedAccountInfo:ppCloudAccountInfo
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudAccountInfo release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadFile


//================================================================================
//
//================================================================================
- (BOOL)loadFileFromPath:(NSString *)filePath
                orFileID:(NSString *)fileID
                intoPath:(NSString *)intoPath
                delegate:(id<PPCloudDelegate_LoadFile>)delegate
                userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_LoadFile *operation = [[PPGoogleDriveOperation_LoadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadFile = filePath;
            operation.intoPath = intoPath;
            operation.fileID = fileID;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_LoadFile


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadFile *)operation loadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  loadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadFile *)operation loadedFile:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               loadedFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadFile *)operation loadProgress:(CGFloat)progress forFile:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadProgress:forFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
             loadProgress:progress
                  forFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadMetadata


//================================================================================
//
//================================================================================
- (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_LoadMetadata *operation = [[PPGoogleDriveOperation_LoadMetadata alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadMetadata = loadMetadata;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveLoadMetadataOperationDelegate


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadMetadata *)operation loadMetadataFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadMetadataFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadMetadataFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadMetadata *)operation loadedMetadata:(NSDictionary *)metadata
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedMetadata:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithGoogleDriveMetadata:metadata path:operation.loadMetadata];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
               loadedMetadata:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadThumbnail


//================================================================================
//
//================================================================================
- (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_LoadThumbnail *operation = [[PPGoogleDriveOperation_LoadThumbnail alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadThumbnail = loadThumbnail;
            operation.intoPath      = intoPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_LoadThumbnail


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadThumbnail *)operation loadThumbnailFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadThumbnailFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadThumbnailFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_LoadThumbnail *)operation loadedThumbnail:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedThumbnail:userInfo:)]==YES)
    {
        [delegate ppCloud:self
          loadedThumbnail:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Move


//================================================================================
//
//================================================================================
- (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_Move *operation = [[PPGoogleDriveOperation_Move alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.moveFrom  = moveFrom;
            operation.toPath    = toPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_Move


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Move *)operation movePathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:movePathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  movePathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Move *)operation movedPath:(NSString *)path to:(NSDictionary *)to
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:movedPath:to:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithGoogleDriveMetadata:to path:operation.toPath];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                    movedPath:path
                           to:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Unlink


//================================================================================
//
//================================================================================
- (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_Unlink *operation = [[PPGoogleDriveOperation_Unlink alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_Unlink


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Unlink *)operation unlinkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:unlinkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
    unlinkFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperationUnlinkSuccess:(PPGoogleDriveOperation_Unlink *)operation
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:unlinkSuccessWithUserInfo:)]==YES)
    {
        [delegate ppCloud:self
unlinkSuccessWithUserInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_UploadFile


//================================================================================
//
//================================================================================
- (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_UploadFile *operation = [[PPGoogleDriveOperation_UploadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.uploadFile    = filename;
            operation.toPath        = toPath;
            operation.fromPath      = fromPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_UploadFile


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_UploadFile *)operation uploadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
uploadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_UploadFile *)operation uploadedFile:(NSString *)destPath from:(NSString *)srcPath metadata:(NSDictionary *)metadata
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadedFile:from:metadata:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithGoogleDriveMetadata:metadata path:destPath];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                 uploadedFile:destPath
                         from:srcPath
                     metadata:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_UploadFile *)operation uploadProgress:(CGFloat)progress forFile:(NSString *)destPath from:(NSString *)srcPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadProgress:forFile:from:userInfo:)]==YES)
    {
        [delegate ppCloud:self
           uploadProgress:progress
                  forFile:destPath
                     from:srcPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Sharedlink

//================================================================================
//
//================================================================================
- (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPGoogleDriveOperation_Sharedlink *operation = [[PPGoogleDriveOperation_Sharedlink alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.sharedlinkFile = sharedlinkFile;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperationDelegate_Sharedlink

//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Sharedlink *)operation sharedlinkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if (delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:sharedlinkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
sharedlinkFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppGoogleDriveOperation:(PPGoogleDriveOperation_Sharedlink *)operation sharedlinkString:(NSString *)sharedlink
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if (delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:sharedlinkString:userInfo:)]==YES)
    {
        [delegate ppCloud:self
         sharedlinkString:sharedlink
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

@end
