//
//  PPGoogleDriveOperation_Unlink.m
//  
//
//  Created by Mike on 13/4/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_Unlink.h"
#import "PPCloud_GoogleDrive.h"

@implementation PPGoogleDriveOperation_Unlink

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            NSString *keychainItemName = [PPCloud parameterForKey:PPCloud_ParameterKey_GoogleDriveKeychainItemName];
            if(keychainItemName==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            [GTMAppAuthFetcherAuthorization removeAuthorizationFromKeychainForName:keychainItemName];
            [GTLRDriveService sharedServiceDrive].authorizer = nil;
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:unlinkFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self unlinkFailedWithError:error];
            }
        }
        else
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperationUnlinkSuccess:)]==YES)
            {
                [self.delegate ppGoogleDriveOperationUnlinkSuccess:self];
            }
        }
    
        [self completion];
    }
}

@end
