//
//  PPGoogleDriveOperation_Sharedlink.m
//  HandWrite
//
//  Created by Andrew on 2015/1/13.
//  Copyright (c) 2015年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_Sharedlink.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_Sharedlink Extension

@interface PPGoogleDriveOperation_Sharedlink ()
@property (nonatomic, retain) GTLRDrive_File *serviceFile;
-(void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithPermission:(GTLRDrive_Permission *)filePermission error:(NSError *)error;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_Sharedlink Implementation

@implementation PPGoogleDriveOperation_Sharedlink





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.sharedlinkFile = nil;
    self.serviceFile    = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if (self.sharedlinkFile==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            
            NSDictionary *identifierForFolderDictionary = [GTLRDriveService sharedServiceDrive].identifierForFolderDictionary;
            
            NSString *fileID = [identifierForFolderDictionary objectForKey:[self.sharedlinkFile stringByDeletingLastPathComponent]];
            
            GTLRDrive_File *rootFile = [[GTLRDriveService sharedServiceDrive] fileForIdentifier:fileID error:nil];
            
            NSArray *pathComponents = [self.sharedlinkFile pathComponents];
            NSString *pathComponentID = nil;
            
            // 找到 root檔案，直接找 file
            if(rootFile!=nil)
            {
                pathComponentID = rootFile.identifier;
                pathComponents = @[PPCloud_RootPath, self.sharedlinkFile.lastPathComponent];
            }

            //////////////////////////////////////////////////

            // 尋找網空上所對應的files
            
            NSArray *serviceFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:pathComponents
                                                                          currentPathComponentID:pathComponentID
                                                                                           error:&error];
            if (error!=nil)
            {
                break;
            }
            
            if ([serviceFiles count]<1)
            {
                error = PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", nil);
                break;
            }
            
            if([serviceFiles count]>1)
            {
                error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"More than one file", nil);
                break;
            }
            
            //////////////////////////////////////////////////
            // 取得file
            
            self.serviceFile = [serviceFiles objectAtIndex:0];
            
            //!! 不可為目錄
            if([self.serviceFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==YES)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            // 修改權限，使file可以任意人分享與下載
            
            GTLRDrive_Permission *newPermission = [GTLRDrive_Permission object];
            if (newPermission==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            newPermission.type = @"anyone";
            newPermission.role = @"writer";
            
            //!! 修改file的使用權限
            GTLRDriveQuery_PermissionsCreate *changePermissionQuery = [GTLRDriveQuery_PermissionsCreate queryWithObject:newPermission fileId:self.serviceFile.identifier];
            
            if (changePermissionQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            //!! 更新service上file的使用權限
            GTLRServiceTicket *ticket = [[GTLRDriveService sharedServiceDrive]  executeQuery:changePermissionQuery
                                                                                  delegate:self
                                                                         didFinishSelector:@selector(serviceTicket:finishedWithPermission:error:)];
            if (ticket==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
        }while (0);
        
        //////////////////////////////////////////////////
        // 產生shared link中途失敗
        
        if (error!=nil)
        {
            if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:sharedlinkFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self sharedlinkFailedWithError:error];
            }
            
            [self completion];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

//================================================================================
//
//================================================================================
-(void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithPermission:(GTLRDrive_Permission *)filePermission error:(NSError *)error
{
    if (error!=nil)
    {
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:sharedlinkFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self sharedlinkFailedWithError:error];
        }
    }
    else
    {
        if (self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:sharedlinkString:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self sharedlinkString:self.serviceFile.webContentLink];
        }
    }
    
    [self completion];
}

@end
