//
//  PPGoogleDriveOperation_Move.m
//  
//
//  Created by Mike on 13/4/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_Move.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPGoogleDriveOperation_Move()

@interface PPGoogleDriveOperation_Move()
@property(nonatomic,retain) GTLRDrive_File *moveFile;
- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithFile:(GTLRDrive_File *)file error:(NSError *)error;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGoogleDriveOperation_Move

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize moveFrom    = moveFrom_;
@synthesize toPath      = toPath_;
@synthesize moveFile    = moveFile_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [moveFrom_ release];
    [toPath_ release];
    [moveFile_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.moveFrom==nil || self.toPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSDictionary *identifierForFolderDictionary = [GTLRDriveService sharedServiceDrive].identifierForFolderDictionary;
            
            NSString *fileID = [identifierForFolderDictionary objectForKey:[self.moveFrom stringByDeletingLastPathComponent]];
            
            GTLRDrive_File *rootFile = [[GTLRDriveService sharedServiceDrive] fileForIdentifier:fileID error:nil];
            
            NSArray *pathComponents = [self.moveFrom pathComponents];
            NSString *pathComponentID = nil;
            
            // 找到 root檔案，直接找 file
            if(rootFile!=nil)
            {
                pathComponentID = rootFile.identifier;
                pathComponents = @[PPCloud_RootPath, self.moveFrom.lastPathComponent];
            }
            
            //////////////////////////////////////////////////

            NSArray *moveFromFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:[self.moveFrom pathComponents]
                                                                           currentPathComponentID:nil
                                                                                            error:&error];
            if(error!=nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([moveFromFiles count]<1)
            {
                error = PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([moveFromFiles count]>1)
            {
                error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"More than one files", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *moveFromFile = [moveFromFiles objectAtIndex:0];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSArray *toPathParentFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:[[self.toPath stringByDeletingLastPathComponent] pathComponents]
                                                                               currentPathComponentID:nil
                                                                                                error:&error];
            if(error!=nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([toPathParentFiles count]<1)
            {
                error = PPErrorMake(PPCloudCommonError_PathNotExist, @"Path Not Exist", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([toPathParentFiles count]>1)
            {
                error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"Path already exist", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *toPathParentFile = [toPathParentFiles objectAtIndex:0];
            
            //Parent一定要是目錄
            if([toPathParentFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==NO)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
//            GTLDriveParentReference *parentReference = [GTLDriveParentReference object];
//            if(parentReference==nil)
//            {
//                error = PPErrorOperationFailed(nil);
//                break;
//            }
//            
//            parentReference.identifier = toPathParentFile.identifier;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *moveFile = [GTLRDrive_File object];
            if(moveFile==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            moveFile.name      = [self.toPath lastPathComponent];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDriveQuery_FilesUpdate *moveQuery = [GTLRDriveQuery_FilesUpdate queryWithObject:moveFile fileId:moveFromFile.identifier uploadParameters:nil];
            
            if(moveQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            moveQuery.addParents = toPathParentFile.identifier;
            moveQuery.removeParents = [[moveFromFile parents]  componentsJoinedByString:@" "];
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRServiceTicket *ticket = [[GTLRDriveService sharedServiceDrive] executeQuery:moveQuery
                                                                                 delegate:self
                                                                        didFinishSelector:@selector(serviceTicket:finishedWithFile:error:)];
            if(ticket==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:movePathFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self movePathFailedWithError:error];
            }
            
            [self completion];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithFile:(GTLRDrive_File *)file error:(NSError *)error
{
    do
    {
        if(error!=nil)
        {
            break;
        }
     
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        self.moveFile = file;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if([self.moveFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==YES)
        {
            GTLRDriveQuery_FilesList *fileListQuery = [GTLRDriveQuery_FilesList query];
            
            if(fileListQuery==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            fileListQuery.q =  [NSString stringWithFormat:@"trashed=false and '%@' in parents", self.moveFile.identifier];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRServiceTicket *ticket = [[GTLRDriveService sharedServiceDrive] executeQuery:fileListQuery
                                                                                 delegate:self
                                                                        didFinishSelector:@selector(serviceTicket:finishedWithFileList:error:)];
            if(ticket==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
        }
        else
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:movedPath:to:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self movedPath:self.moveFrom to:[NSDictionary dictionaryWithObjectsAndKeys:self.moveFile, NSStringFromClass([self.moveFile class]), nil]];
            }
        }
        
    }while(0);
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(error!=nil)
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:movePathFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self movePathFailedWithError:error];
        }
    }
    
    [self completion];
}

- (void)serviceTicket:(GTLRServiceTicket *)ticket finishedWithFileList:(GTLRDrive_FileList *)fileList error:(NSError *)error
{
    if(error!=nil)
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:movePathFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self movePathFailedWithError:error];
        }
    }
    else
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:movedPath:to:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self movedPath:self.moveFrom to:[NSDictionary dictionaryWithObjectsAndKeys:self.moveFile, NSStringFromClass([self.moveFile class]), fileList, NSStringFromClass([fileList class]), nil]];
        }
    }
    
    [self completion];
}

@end
