//
//  PPGoogleDriveOperation_LoadThumbnail.m
//  
//
//  Created by Mike on 13/4/16.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_LoadThumbnail.h"

#import "GTMSessionFetcher.h"

@implementation PPGoogleDriveOperation_LoadThumbnail

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize loadThumbnail   = loadThumbnail_;
@synthesize intoPath        = intoPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark -
#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [loadThumbnail_ release];
	[intoPath_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.loadThumbnail==nil || self.intoPath==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            NSDictionary *identifierForFolderDictionary = [GTLRDriveService sharedServiceDrive].identifierForFolderDictionary;
            
            NSString *fileID = [identifierForFolderDictionary objectForKey:[self.loadThumbnail stringByDeletingLastPathComponent]];
            
            GTLRDrive_File *rootFile = [[GTLRDriveService sharedServiceDrive] fileForIdentifier:fileID error:nil];
            
            NSArray *pathComponents = [self.loadThumbnail pathComponents];
            NSString *pathComponentID = nil;
            
            // 找到 root檔案，直接找 file
            if(rootFile!=nil)
            {
                pathComponentID = rootFile.identifier;
                pathComponents = @[PPCloud_RootPath, self.loadThumbnail.lastPathComponent];
            }
            
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSArray *loadThumbnailFiles = [[GTLRDriveService sharedServiceDrive] filesForPathComponents:pathComponents
                                                                                currentPathComponentID:pathComponentID
                                                                                                 error:&error];
            if(error!=nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([loadThumbnailFiles count]<1)
            {
                error = PPErrorMake(PPCloudCommonError_PathNotExist, @"File not found", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if([loadThumbnailFiles count]>1)
            {
                error = PPErrorMake(PPCloudCommonError_MultipleItemsWithSamePath, @"More than one files", nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTLRDrive_File *loadThumbnailFile = [loadThumbnailFiles objectAtIndex:0];
            
            //目錄無法下載
            if([loadThumbnailFile.mimeType isEqualToString:GTLDriveFile_MimeType_Folder]==YES)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }
            
            if(loadThumbnailFile.thumbnailLink==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            GTMSessionFetcher *fetcher = [GTMSessionFetcher fetcherWithURLString:loadThumbnailFile.thumbnailLink];
            if(fetcher==nil)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            fetcher.authorizer      = [GTLRDriveService sharedServiceDrive].authorizer;
            if([self.intoPath length]==0)
            {
                error = PPErrorOperationFailed(nil);
                break;
            }
            
            fetcher.destinationFileURL = [NSURL URLWithString:self.intoPath];
        
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            [fetcher beginFetchWithDelegate:self didFinishSelector:@selector(fetcher:finishedWithData:error:)];
//            if([fetcher beginFetchWithDelegate:self didFinishSelector:@selector(fetcher:finishedWithData:error:)]==NO)
//            {
//                error = PPErrorOperationFailed(nil);
//                break;
//            }
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadThumbnailFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self loadThumbnailFailedWithError:error];
            }
            
            [self completion];
        }
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private

- (void)fetcher:(GTMSessionFetcher *)fetcher finishedWithData:(NSData *)retrievedData error:(NSError *)error
{
    if(error!=nil)
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadThumbnailFailedWithError:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self loadThumbnailFailedWithError:error];
        }
    }
    else
    {
        if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:loadedThumbnail:)]==YES)
        {
            [self.delegate ppGoogleDriveOperation:self loadedThumbnail:self.intoPath];
        }
    }
    
    [self completion];
}

@end
