//
//  PPGoogleDriveOperation_Link.m
//  
//
//  Created by Mike on 13/4/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation_Link.h"
#import "PPCloud_GoogleDrive.h"
#import <AppAuth/AppAuthCore.h>

#if TARGET_OS_IPHONE
#import "OIDAuthState+IOS.h"
#elif TARGET_OS_MAC
#import "OIDExternalUserAgentMac.h"
#endif

static NSString *PPGoogleDriveOperation_Link_RedirectURIPosfix = @":/oauthredirect";

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPGoogleDriveOperation_Link()

@interface PPGoogleDriveOperation_Link()
@property (nonatomic, retain) id<OIDExternalUserAgentSession> currentAuthorizationFlow;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPGoogleDriveOperation_Link

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
#if TARGET_OS_IPHONE
#elif TARGET_OS_MAC
        [[NSAppleEventManager sharedAppleEventManager] setEventHandler:self
                                                           andSelector:@selector(handleGetURLEvent:withReplyEvent:)
                                                         forEventClass:kInternetEventClass
                                                            andEventID:kAEGetURL];
#endif
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_viewController release];
    _viewController = nil;
    
    [_currentAuthorizationFlow release];
    _currentAuthorizationFlow = nil;
    
    //////////////////////////////////////////////////

#if TARGET_OS_IPHONE
#elif TARGET_OS_MAC
    [[NSAppleEventManager sharedAppleEventManager] removeEventHandlerForEventClass:kInternetEventClass andEventID:kAEGetURL];
#endif
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Recieve Notificaiton Method

#if TARGET_OS_IPHONE
#elif TARGET_OS_MAC

//================================================================================
//
//================================================================================
- (void)handleGetURLEvent:(NSAppleEventDescriptor *)event
           withReplyEvent:(NSAppleEventDescriptor *)replyEvent
{
    NSString *URLString = [[event paramDescriptorForKeyword:keyDirectObject] stringValue];
    NSURL *URL = [NSURL URLWithString:URLString];
    [self.currentAuthorizationFlow resumeExternalUserAgentFlowWithURL:URL];
}
#endif


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

//================================================================================
//
//================================================================================
- (void)cancel
{
    [super cancel];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [self completion];
}




////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Executing the Operation


//================================================================================
//
//================================================================================
+ (NSString *)reverseClientID:(NSString*)clientID
{
    if ([clientID length]==0)
    {
        return nil;
    }
    
    NSArray *clientIDComponents = [clientID componentsSeparatedByString:@"."];
    NSEnumerator *enumerator = [clientIDComponents reverseObjectEnumerator];
    
    return [[enumerator allObjects] componentsJoinedByString:@"."];
}


//==============================================================================
//
//==============================================================================
- (OIDAuthorizationRequest *)authorizationRequestWithScopes:(NSArray *)scopes
{
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    NSString *clientID = [PPCloud parameterForKey:PPCloud_ParameterKey_GoogleDriveClientID];
    NSString *clientSecret = [PPCloud parameterForKey:PPCloud_ParameterKey_GoogleDriveClientSecret];

    //////////////////////////////////////////////////
    // assert check
    NSAssert(!([clientID length]==0),
             @"Initialize with your own client ID first. "
             "Instructions: https://github.com/openid/AppAuth-iOS/blob/master/Example/README.md");
    
    NSString *reversedClientID = [PPGoogleDriveOperation_Link reverseClientID:clientID];
    NSString *redirectURIString = [reversedClientID stringByAppendingString:PPGoogleDriveOperation_Link_RedirectURIPosfix];
    
    // verifies that the custom URI scheme has been updated in the Info.plist
    NSArray *urlTypes = [[NSBundle mainBundle] objectForInfoDictionaryKey:@"CFBundleURLTypes"];
    NSAssert(urlTypes.count > 0, @"No custom URI scheme has been configured for the project.");
    
    BOOL isURLSchemeSettingCorrect = NO;
    for (NSDictionary *urlSchemes in urlTypes)
    {
        for (NSString *urlScheme in urlSchemes[@"CFBundleURLSchemes"])
        {
            if([urlScheme isEqualToString:reversedClientID])
            {
                isURLSchemeSettingCorrect = YES;
            }
        }
    }
    
    
    NSAssert((isURLSchemeSettingCorrect==YES),@"URL Scheme: %@ is not one of the url scheme in info.plist. "
             "Full instructions:  https://github.com/openid/AppAuth-iOS/blob/master/Example/README.md", reversedClientID);
    
    //////////////////////////////////////////////////
    OIDAuthorizationRequest *request = nil;
    NSURL *redirectURI = [NSURL URLWithString:redirectURIString];
    
    OIDServiceConfiguration *configuration =
    [GTMAppAuthFetcherAuthorization configurationForGoogle];
    
    if (!configuration) {
        return request;
    }
        
    NSMutableArray *adjustScopes = [NSMutableArray arrayWithArray:scopes];
    [adjustScopes addObject:OIDScopeOpenID];
    [adjustScopes addObject:OIDScopeProfile];
    [adjustScopes addObject:OIDScopeEmail];
    
    // builds authentication request
    request =
    [[[OIDAuthorizationRequest alloc] initWithConfiguration:configuration
                                                   clientId:clientID
                                               clientSecret:clientSecret
                                                     scopes:adjustScopes
                                                redirectURL:redirectURI
                                               responseType:OIDResponseTypeCode
                                       additionalParameters:nil] autorelease];
    
    return request;
}


//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *error = nil;
        
        do
        {
            if(self.viewController==nil)
            {
                error = PPErrorParameterInvalidity(nil);
                break;
            }

            void (^AuthStateAuthorizationCallback)(OIDAuthState *_Nullable authState,
                                                      NSError *_Nullable error) =
            ^(OIDAuthState *_Nullable authState,
              NSError *_Nullable error)
            {
                if (authState) {
                    GTMAppAuthFetcherAuthorization *authorization =
                    [[GTMAppAuthFetcherAuthorization alloc] initWithAuthState:authState];
                    
                    [GTLRDriveService sharedServiceDrive].authorizer = authorization;
                    //////////////////////////////////////////////////
                    // 存到key chain
                    NSString *keychainItemName = [PPCloud parameterForKey:PPCloud_ParameterKey_GoogleDriveKeychainItemName];

                    [GTMAppAuthFetcherAuthorization saveAuthorization:authorization
                                                    toKeychainForName:keychainItemName];
                    
                    //////////////////////////////////////////////////

                    [authorization release];
                    if([self.delegate respondsToSelector:@selector(ppGoogleDriveOperationLinkSuccess:)]==YES)
                    {
                        [self.delegate ppGoogleDriveOperationLinkSuccess:self];
                    }
                }
                else
                {
                    if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:linkFailedWithError:)]==YES)
                    {
                        NSError *linkFailedError = nil;
                        if(([error.domain isEqualToString:OIDOAuthAuthorizationErrorDomain] ||
                            [error.domain isEqualToString:OIDGeneralErrorDomain])&&
                           (error.code==OIDErrorCodeUserCanceledAuthorizationFlow||
                            error.code==OIDErrorCodeProgramCanceledAuthorizationFlow))
                        {
                            linkFailedError = PPErrorMake(PPCloudCommonError_CancelLogin, @"取消登入", error);
                        }
                        else
                        {
                            linkFailedError = error;
                        }
                        
                        [self.delegate ppGoogleDriveOperation:self linkFailedWithError:linkFailedError];
                    }
                }
                [self completion];
            };
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            // builds authentication request
            OIDAuthorizationRequest *request = [self authorizationRequestWithScopes:@[kGTLRAuthScopeDrive]];
            
            // performs authentication request
 #if TARGET_OS_IPHONE

            self.currentAuthorizationFlow =
            [OIDAuthState authStateByPresentingAuthorizationRequest:request
                                           presentingViewController:self.viewController
                                                           callback:AuthStateAuthorizationCallback];
			
#elif TARGET_OS_MAC
			
			OIDExternalUserAgentMac *externalUserAgent = [[[OIDExternalUserAgentMac alloc] init] autorelease];
			
            self.currentAuthorizationFlow =
			[OIDAuthState authStateByPresentingAuthorizationRequest:request externalUserAgent:externalUserAgent callback:AuthStateAuthorizationCallback];

#endif
            
            
        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(error!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppGoogleDriveOperation:linkFailedWithError:)]==YES)
            {
                [self.delegate ppGoogleDriveOperation:self linkFailedWithError:error];
            }
            
            [self completion];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Public


//==============================================================================
//
//==============================================================================
- (BOOL)handleOpenURL:(NSURL *)url
{
    return [[self currentAuthorizationFlow] resumeExternalUserAgentFlowWithURL:url];
}

@end
