//
//  PPGoogleDriveOperation.m
//  
//
//  Created by Mike on 13/4/8.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPGoogleDriveOperation.h"

@implementation PPGoogleDriveOperation

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    id object = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if((self=[super init]))
    {
        self.privateConcurrent = YES;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        object = self;
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)start
{
	if([self isCancelled]==YES)
	{
		[self setFinished:YES];
	}
	else
	{
        [self setExecuting:YES];
        
        // GTLServiceDrive的delegate一定要在mainThread才收的到？
//        [self performSelector:@selector(main) withObject:nil];
        
        [self performSelectorOnMainThread:@selector(main)
                               withObject:nil
                            waitUntilDone:NO];

	}
}

@end
