//
//  PPCloud_Dropbox.m
//  
//
//  Created by Mike on 13-3-11.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloud_Dropbox.h"
#import "PPCloud+Private.h"
#import "PPDropboxOperation_Copy.h"
#import "PPDropboxOperation_CreateFolder.h"
#import "PPDropboxOperation_Delete.h"
#import "PPDropboxOperation_Link.h"
#import "PPDropboxOperation_LoadAccountInfo.h"
#import "PPDropboxOperation_LoadFile.h"
#import "PPDropboxOperation_LoadMetadata.h"
#import "PPDropboxOperation_LoadThumbnail.h"
#import "PPDropboxOperation_Move.h"
#import "PPDropboxOperation_Unlink.h"
#import "PPDropboxOperation_UploadFile.h"
#import "PPDropboxOperation_Sharedlink.h"
#import "DBClientsManager+Protected.h"

#import "NSString+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPCloud_ParameterKey_DropboxAppKey       = @"PPCloud_ParameterKey_DropboxAppKey";
NSString *PPCloud_ParameterKey_DropboxAppSecret    = @"PPCloud_ParameterKey_DropboxAppSecret";

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloudAccountInfo (Dropbox)

- (id)initWithDropboxAccountInfo:(DBUSERSFullAccount *)dropboxAccountInfo userSpaceUsage:(DBUSERSSpaceUsage *)userSpaceUsage;
@end

@implementation PPCloudAccountInfo (Dropbox)

//================================================================================
//
//================================================================================
- (id)initWithDropboxAccountInfo:(DBUSERSFullAccount *)dropboxAccountInfo userSpaceUsage:(DBUSERSSpaceUsage *)userSpaceUsage
{
    if((self=[super init]))
    {
        cloudClassName_ = [NSStringFromClass([PPCloud_Dropbox class]) retain];
        displayName_    = [dropboxAccountInfo.name.displayName retain];
        userID_         = [dropboxAccountInfo.accountId retain];
        
        usedBytes_      = [userSpaceUsage.used retain];
        if([userSpaceUsage.allocation isTeam])
        {
            totalBytes_     = [userSpaceUsage.allocation.team.allocated retain];
        }
        else
        {
            totalBytes_     = [userSpaceUsage.allocation.individual.allocated retain];
        }
        rawData_        = [dropboxAccountInfo retain];
    }
    
    return self;
}
@end





////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPCloudMetadata (Dropbox)
- (id)initWithDropboxFolderMetadata:(DBFILESFolderMetadata *)dropboxMetadata;
- (id)initWithDropboxFILESFileMetadata:(DBFILESFileMetadata *)dropboxMetadata;
- (id)initWithDropboxFileMetadata:(DBFILESMetadata *)dropboxMetadata;
- (id)initWithDropboxFileListMetadata:(DBFILESListFolderResult *)dropboxFileListMetadata;
@end

@implementation PPCloudMetadata (Dropbox)

//================================================================================
//
//================================================================================
- (id)initWithDropboxFolderMetadata:(DBFILESFolderMetadata *)dropboxMetadata
{
    if((self=[super init]))
    {
        cloudClassName_     = [NSStringFromClass([PPCloud_Dropbox class]) retain];
        path_               = [dropboxMetadata.pathDisplay retain];
//        lastModifiedDate_   = [dropboxMetadata.lastModifiedDate retain];
        uniqueID_           = [dropboxMetadata.id_ retain];
//        thumbnailExists_    = dropboxMetadata.thumbnailExists;
        isDirectory_        = YES;
        
        //////////////////////////////////////////////////
        
        NSMutableArray *contents = [[NSMutableArray alloc] init];
      
        if(contents!=nil)
        {
            //                for(DBMetadata *content in dropboxMetadata.contents)
            //                {
            //                    [contents addObject:content.path];
            //                }
            
            contents_ = [[NSArray alloc] initWithArray:contents];
            
            [contents release];
        }
        
        rawData_    = [dropboxMetadata retain];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (id)initWithDropboxFILESFileMetadata:(DBFILESFileMetadata *)dropboxMetadata
{
    if((self=[super init]))
    {
        cloudClassName_     = [NSStringFromClass([PPCloud_Dropbox class]) retain];
        path_               = [dropboxMetadata.pathDisplay retain];
        lastModifiedDate_   = [dropboxMetadata.serverModified retain];
        uniqueID_           = [dropboxMetadata.id_ retain];
        
        //                thumbnailExists_    = dropboxMetadata.thumbnailExists;
        
        isDirectory_        = NO;
        
        fileHash_   = [dropboxMetadata.rev retain];
        fileName_   = [dropboxMetadata.name retain];
        fileSize_   = [dropboxMetadata.size retain];
        
        rawData_    = [dropboxMetadata retain];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (id)initWithDropboxFileMetadata:(DBFILESMetadata *)dropboxMetadata
{
    if((self=[super init]))
    {
        cloudClassName_     = [NSStringFromClass([PPCloud_Dropbox class]) retain];
        path_               = [dropboxMetadata.pathDisplay retain];
    
        isDirectory_        = NO;
        
        fileName_   = [dropboxMetadata.name retain];

        rawData_    = [dropboxMetadata retain];
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (id)initWithDropboxFileListMetadata:(DBFILESListFolderResult *)dropboxFileListMetadata
{
    if(self=[super init])
    {
        cloudClassName_     = [NSStringFromClass([PPCloud_Dropbox class]) retain];

        isDirectory_        = YES;
        
        //////////////////////////////////////////////////
    
        NSMutableArray <DBFILESMetadata *> *entries = [NSMutableArray arrayWithArray:dropboxFileListMetadata.entries];
        
        [entries sortUsingComparator:^NSComparisonResult(DBFILESMetadata *obj1, DBFILESMetadata *obj2) {
            return [obj1.name unicodeCompare:obj2.name];
        }];
        
        //////////////////////////////////////////////////

        NSMutableArray *contents = [NSMutableArray array];
        
        if(contents!=nil)
        {
            for(DBFILESMetadata *content in entries)
            {
                [contents addObject:content.pathDisplay];
            }
            
            //////////////////////////////////////////////////
            
            contents_ = [[NSArray alloc] initWithArray:contents];
        }

        rawData_   = [[DBFILESListFolderResult alloc] initWithEntries:entries
                                                               cursor:dropboxFileListMetadata.cursor
                                                              hasMore:dropboxFileListMetadata.hasMore];
    }
    
    return self;
}

@end






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloud_Dropbox()

@interface PPCloud_Dropbox()    <
                                PPDropboxOperationDelegate_Copy,
                                PPDropboxOperationDelegate_CreateFolder,
                                PPDropboxOperationDelegate_Delete,
                                PPDropboxOperationDelegate_Link,
                                PPDropboxOperationDelegate_LoadAccountInfo,
                                PPDropboxOperationDelegate_LoadFile,
                                PPDropboxOperationDelegate_LoadMetadata,
                                PPDropboxOperationDelegate_LoadThumbnail,
                                PPDropboxOperationDelegate_Move,
                                PPDropboxOperationDelegate_Unlink,
                                PPDropboxOperationDelegate_UploadFile,
                                PPDropboxOperationDelegate_Sharedlink
                                >

@property (nonatomic,retain) DBTransportDefaultConfig *config;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloud_Dropbox

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithOperationQueue:(NSOperationQueue *)operationQueue
{
    id object = nil;
    
    do
    {
        NSString *appKey = [PPCloud parameterForKey:PPCloud_ParameterKey_DropboxAppKey];
        if(appKey==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSString *appSecret = [PPCloud parameterForKey:PPCloud_ParameterKey_DropboxAppSecret];
        if(appSecret==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if((self=[super initWithOperationQueue:operationQueue]))
        {
            // 配合framework， setupWithAppKeyDesktop 只能當 singleton 沒產生時，才設定
            if([DBOAuthManager sharedOAuthManager]==nil)
            {
#if TARGET_OS_IPHONE
                [DBClientsManager setupWithAppKey:appKey];
#elif TARGET_OS_OSX

                DBTransportDefaultConfig *config = [[DBTransportDefaultConfig alloc] initWithAppKey:appKey forceForegroundSession:YES];
            
                //////////////////////////////////////////////////

                [DBClientsManager setupWithTransportConfigDesktop:config];
            
                self.config = config;
                
                [config release];
#endif
            }
         
            object = self;
        }
        
    }while(0);
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    if(object!=self)
    {
        [self release];
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    return object;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.config = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

//================================================================================
//
//================================================================================
- (BOOL)isLinked
{
    BOOL isLinked = NO;
    
    if ([DBClientsManager authorizedClient]!=nil ||
        [DBClientsManager authorizedTeamClient]!=nil)
    {
        isLinked = YES;
    }
    
    return isLinked;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (BOOL)handleOpenURL:(NSURL *)url
{
    BOOL result = NO;
    
    NSArray *operations = self.operationQueue.operations;
    
    for(NSOperation *operation in operations)
    {
        if([operation isKindOfClass:[PPDropboxOperation_Link class]]==YES)
        {
            result = [(PPDropboxOperation_Link *)operation handleOpenURL:url];
            
            break;
        }
    }
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Copy

- (BOOL)copyFrom:(NSString*)fromPath toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Copy>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_Copy *operation = [[PPDropboxOperation_Copy alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.fromPath  = fromPath;
            operation.toPath    = toPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_Copy

//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_Copy *)operation copyPathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:copyPathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  copyPathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_Copy *)operation copiedPath:(NSString *)path to:(DBFILESMetadata *)to
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:copiedPath:to:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithDropboxFileMetadata:to];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                   copiedPath:path
                           to:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_CreateFolder

- (BOOL)createFolder:(NSString *)createFolder delegate:(id<PPCloudDelegate_CreateFolder>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_CreateFolder *operation = [[PPDropboxOperation_CreateFolder alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.createFolder = createFolder;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_CreateFolder

//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_CreateFolder *)operation createFolderFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createFolderFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
createFolderFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_CreateFolder *)operation createdFolder:(DBFILESFolderMetadata *)folder
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:createdFolder:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithDropboxFolderMetadata:folder];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                createdFolder:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Delete

- (BOOL)deletePath:(NSString *)deletePath delegate:(id<PPCloudDelegate_Delete>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_Delete *operation = [[PPDropboxOperation_Delete alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.deletePath = deletePath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_Delete

//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_Delete *)operation deletePathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
deletePathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_Delete *)operation deletedPath:(NSString *)path
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:deletePath:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               deletePath:path
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Link

- (BOOL)linkFromController:(CPCLViewController *)viewcontroller delegate:(id<PPCloudDelegate_Link>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    PPDropboxOperation_Link *operation = [[PPDropboxOperation_Link alloc] init];
    
    if(operation!=nil)
    {
        operation.delegate  = self;
        operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        operation.viewcontroller = viewcontroller;
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSArray *operations = self.operationQueue.operations;
        
        for(NSOperation *dropboxOperation in operations)
        {
            if([dropboxOperation isKindOfClass:[PPDropboxOperation_Link class]]==YES)
            {
                [dropboxOperation cancel];
            }
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [self addOperation:operation];
        
        [operation release];
    }
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_Link

- (void)ppDropboxOperation:(PPDropboxOperation_Link *)operation linkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:linkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
      linkFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppDropboxOperationLinkSuccess:(PPDropboxOperation_Link *)operation
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:linkSuccessWithUserInfo:)]==YES)
    {
        [delegate ppCloud:self
  linkSuccessWithUserInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadAccountInfo

- (BOOL)loadAccountInfoWithDelegate:(id<PPCloudDelegate_LoadAccountInfo>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_LoadAccountInfo *operation = [[PPDropboxOperation_LoadAccountInfo alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_LoadAccountInfo

- (void)ppDropboxOperation:(PPDropboxOperation_LoadAccountInfo *)operation loadAccountInfoFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadAccountInfoFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadAccountInfoFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_LoadAccountInfo *)operation loadedAccountInfo:(DBUSERSFullAccount *)info useSpaceUsage:(DBUSERSSpaceUsage *)useSpaceUsage
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedAccountInfo:userInfo:)]==YES)
    {
        PPCloudAccountInfo *ppCloudAccountInfo = [[PPCloudAccountInfo alloc] initWithDropboxAccountInfo:info userSpaceUsage:useSpaceUsage];
        if(ppCloudAccountInfo!=nil)
        {
            [delegate ppCloud:self
            loadedAccountInfo:ppCloudAccountInfo
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudAccountInfo release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadFile

- (BOOL)loadFileFromPath:(NSString *)filePath
                orFileID:(NSString *)fileID
                intoPath:(NSString *)intoPath
                delegate:(id<PPCloudDelegate_LoadFile>)delegate
                userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_LoadFile *operation = [[PPDropboxOperation_LoadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadFile = filePath;
            operation.intoPath = intoPath;

            if([userInfo isKindOfClass:[DBFILESFileMetadata class]]==YES)
            {
                DBFILESFileMetadata *fileMetadata = userInfo;
                operation.fileByteSize = [fileMetadata.size integerValue];
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_LoadFile

- (void)ppDropboxOperation:(PPDropboxOperation_LoadFile *)operation loadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  loadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppDropboxOperation:(PPDropboxOperation_LoadFile *)operation loadedFile:(NSString *)destPath contentType:(NSString *)contentType
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
               loadedFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppDropboxOperation:(PPDropboxOperation_LoadFile *)operation loadProgress:(CGFloat)progress forFile:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadProgress:forFile:userInfo:)]==YES)
    {
        [delegate ppCloud:self
             loadProgress:progress
                  forFile:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadMetadata

- (BOOL)loadMetadata:(NSString *)loadMetadata delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_LoadMetadata *operation = [[PPDropboxOperation_LoadMetadata alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadMetadata = loadMetadata;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxLoadMetadataOperationDelegate

//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_LoadMetadata *)operation loadMetadataFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadMetadataFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadMetadataFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_LoadMetadata *)operation loadedMetadata:(DBFILESListFolderResult *)metadata
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedMetadata:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithDropboxFileListMetadata:metadata];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
               loadedMetadata:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_LoadMetadata *)operation metadataUnchangedAtPath:(NSString *)path
{
    //mike目前沒辦法處理
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_LoadThumbnail

- (BOOL)loadThumbnail:(NSString *)loadThumbnail ofSize:(NSString *)size intoPath:(NSString *)intoPath delegate:(id<PPCloudDelegate_LoadMetadata>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        NSString *ofSize = nil;
        
        if([size isEqualToString:PPCloud_ThumbnailSize_Maximum]==YES || [size isEqualToString:PPCloud_ThumbnailSize_Large]==YES)
        {
            ofSize = PPDropboxThumbnailSize_Large;
        }
        else if([size isEqualToString:PPCloud_ThumbnailSize_Medium]==YES)
        {
            ofSize = PPDropboxThumbnailSize_Medium;
        }
        else if([size isEqualToString:PPCloud_ThumbnailSize_Minimum]==YES || [size isEqualToString:PPCloud_ThumbnailSize_Small]==YES)
        {
            ofSize = PPDropboxThumbnailSize_Small;
        }
        else
        {
            break;
        }
            
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_LoadThumbnail *operation = [[PPDropboxOperation_LoadThumbnail alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.loadThumbnail = loadThumbnail;
            operation.ofSize        = ofSize;
            operation.intoPath      = intoPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_LoadThumbnail

- (void)ppDropboxOperation:(PPDropboxOperation_LoadThumbnail *)operation loadThumbnailFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadThumbnailFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
loadThumbnailFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppDropboxOperation:(PPDropboxOperation_LoadThumbnail *)operation loadedThumbnail:(NSString *)destPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:loadedThumbnail:userInfo:)]==YES)
    {
        [delegate ppCloud:self
          loadedThumbnail:destPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Move

- (BOOL)moveFrom:(NSString *)moveFrom toPath:(NSString *)toPath delegate:(id<PPCloudDelegate_Move>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_Move *operation = [[PPDropboxOperation_Move alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.moveFrom  = moveFrom;
            operation.toPath    = toPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_Move

- (void)ppDropboxOperation:(PPDropboxOperation_Move *)operation movePathFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:movePathFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
  movePathFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_Move *)operation movedPath:(NSString *)path to:(DBFILESMetadata *)to
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:movedPath:to:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithDropboxFileMetadata:to];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                    movedPath:path
                           to:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Unlink

- (BOOL)unlinkWithDelegate:(id<PPCloudDelegate_Unlink>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_Unlink *operation = [[PPDropboxOperation_Unlink alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_Unlink

- (void)ppDropboxOperation:(PPDropboxOperation_Unlink *)operation unlinkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:unlinkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
    unlinkFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

- (void)ppDropboxOperationUnlinkSuccess:(PPDropboxOperation_Unlink *)operation
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:unlinkSuccessWithUserInfo:)]==YES)
    {
        [delegate ppCloud:self
unlinkSuccessWithUserInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_UploadFile

- (BOOL)uploadFile:(NSString *)filename toPath:(NSString *)toPath fromPath:(NSString *)fromPath delegate:(id<PPCloudDelegate_UploadFile>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_UploadFile *operation = [[PPDropboxOperation_UploadFile alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.uploadFile    = filename;
            operation.toPath        = toPath;
            operation.fromPath      = fromPath;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_UploadFile


- (void)ppDropboxOperation:(PPDropboxOperation_UploadFile *)operation uploadFileFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadFileFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
uploadFileFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_UploadFile *)operation uploadedFile:(NSString *)destPath from:(NSString *)srcPath metadata:(DBFILESFileMetadata *)metadata
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadedFile:from:metadata:userInfo:)]==YES)
    {
        PPCloudMetadata *ppCloudMetadata = [[PPCloudMetadata alloc] initWithDropboxFILESFileMetadata:metadata];
        if(ppCloudMetadata!=nil)
        {
            [delegate ppCloud:self
                 uploadedFile:destPath
                         from:srcPath
                     metadata:ppCloudMetadata
                     userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
            
            [ppCloudMetadata release];
        }
    }
}





- (void)ppDropboxOperation:(PPDropboxOperation_UploadFile *)operation uploadProgress:(CGFloat)progress forFile:(NSString *)destPath from:(NSString *)srcPath
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if(delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:uploadProgress:forFile:from:userInfo:)]==YES)
    {
        [delegate ppCloud:self
           uploadProgress:progress
                  forFile:destPath
                     from:srcPath
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCloudProtocol_Sharedlink

//================================================================================
//
//================================================================================
- (BOOL)sharedlinkFile:(NSString *)sharedlinkFile delegate:(id<PPCloudDelegate_Sharedlink>)delegate userInfo:(id)userInfo
{
    BOOL result = NO;
    
    do
    {
        if([self isLinked]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPDropboxOperation_Sharedlink *operation = [[PPDropboxOperation_Sharedlink alloc] init];
        
        if(operation!=nil)
        {
            operation.delegate  = self;
            operation.userInfo  = [self userInfoDictionaryWithDelegate:delegate userInfo:userInfo];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            operation.sharedlinkFile = sharedlinkFile;
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            result = [self addOperation:operation];
            
            [operation release];
        }
        
    }while(0);
    
    return result;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperationDelegate_Sharedlink

//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_Sharedlink *)operation sharedlinkFailedWithError:(NSError *)error
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if (delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:sharedlinkFailedWithError:userInfo:)]==YES)
    {
        [delegate ppCloud:self
sharedlinkFailedWithError:error
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}


//================================================================================
//
//================================================================================
- (void)ppDropboxOperation:(PPDropboxOperation_Sharedlink *)operation sharedlinkString:(NSString *)sharedlink
{
    id delegate = [self delegateFromUserInfoDictionary:operation.userInfo];
    
    if (delegate!=nil && [delegate respondsToSelector:@selector(ppCloud:sharedlinkString:userInfo:)]==YES)
    {
        [delegate ppCloud:self
         sharedlinkString:sharedlink
                 userInfo:[self userInfoFromUserInfoDictionary:operation.userInfo]];
    }
}

@end
