//
//  PPDropboxOperation_UploadFile.m
//  
//
//  Created by Mike on 13/3/15.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_UploadFile.h"

#import "DBTransportBaseClient+Internal.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPDropboxOperation_UploadFileChunkThreshold (150*1024*1024)

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPDropboxOperation_UploadFile ()
@property (nonatomic, retain) DBUploadTask *uploadTask;
@property (nonatomic, assign) unsigned long long totalSize;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPDropboxOperation_UploadFile

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize uploadFile  = uploadFile_;
@synthesize toPath      = toPath_;
@synthesize fromPath    = fromPath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_uploadTask cancel];
    [_uploadTask release];
    _uploadTask = nil;
    
    //////////////////////////////////////////////////

    [uploadFile_ release];
    [toPath_ release];
    [fromPath_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//================================================================================
- (void)cancel
{
    [self.uploadTask cancel];
    
    //////////////////////////////////////////////////
    
    [super cancel];
    
    //////////////////////////////////////////////////
    
    if(self.finished==NO)
    {
        if(self.executing==YES)
        {
            [self setExecuting:NO];
        }
        
        [self setFinished:YES];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private methods

//================================================================================
//
//================================================================================
- (void)handleProgress:(CGFloat)progress
{
	if([self.delegate respondsToSelector:@selector(ppDropboxOperation:uploadProgress:forFile:from:)]==YES)
	{
		[self.delegate ppDropboxOperation:self uploadProgress:progress forFile:self.toPath from:self.fromPath];
	}
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
		__block dispatch_semaphore_t semaphore = dispatch_semaphore_create(0);
		__block DBFILESUploadSessionCursor *cursor = nil;
		__block NSString *sessionID = nil;
		
        __block NSError *returnError = nil;
		__block DBFILESFileMetadata *metadata = nil;

		__block typeof(self) blockself = self;
		NSString *destPath = nil;
		
        do
        {
            if(self.uploadFile==nil || self.toPath==nil || self.fromPath==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
			
			destPath = [self.toPath stringByAppendingPathComponent:self.uploadFile];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSDictionary *fileAttributes = [[NSFileManager defaultManager] attributesOfItemAtPath:self.fromPath error:&returnError];
            if(returnError!=nil)
            {
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            NSNumber *fileSizeNumber = [fileAttributes objectForKey:NSFileSize];;
            if(fileSizeNumber==nil)
            {
                returnError = PPErrorOperationFailed(nil);
                break;
            }
            
            self.totalSize = [fileSizeNumber unsignedLongLongValue];
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            __block DBFILESUserAuthRoutes *fileRoutes = [DBClientsManager authorizedClient].filesRoutes;
            
            if(fileRoutes==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }
			
			//////////////////////////////////////////////////
			
			if(self.totalSize <= PPDropboxOperation_UploadFileChunkThreshold)
			{
				NSData *fileData = [NSData dataWithContentsOfFile:self.fromPath];
				
				if(fileData==nil)
				{
					returnError = PPErrorParameterInvalidity(nil);
					break;
				}

				//////////////////////////////////////////////////
				// MARK:小檔使用uploadData上傳

				self.uploadTask = [[[fileRoutes uploadData:destPath inputData:fileData] setResponseBlock:^(DBFILESFileMetadata * _Nullable result, DBFILESUploadError * _Nullable routeError, DBRequestError * _Nullable networkError) {

					if(result != nil)
					{
						// success
						metadata = [result retain];
					}
					else
					{
						// failure
						if(routeError.path.reason.tag==DBFILESWriteErrorConflict)
						{
							returnError = PPErrorMake(PPCloudCommonError_PathAlreadyExist, @"PathAlreadyExist", nil);
						}
						else if(routeError.path.reason.tag==DBFILESWriteErrorInsufficientSpace)
						{
							returnError = PPErrorMake(PPCloudCommonError_SpaceNotEnough, @"SpaceNotEnough", nil);
						}
						else
						{
							returnError = [blockself convertErrorFromSystemError:networkError];
						}
						
						[returnError retain];
					}
					
					dispatch_semaphore_signal(semaphore);
					
				}] setProgressBlock:^(int64_t bytesWritten, int64_t totalBytesWritten, int64_t totalBytesExpectedToWrite) {
					[blockself handleProgress:(CGFloat)totalBytesWritten/blockself.totalSize];
				}];
				
				dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
				[returnError autorelease];
				[metadata autorelease];
			}
			else
			{
				// MARK:大檔用session上傳，參考uploadDataSession
				// https://github.com/dropbox/dropbox-sdk-obj-c/blob/master/TestObjectiveDropbox/IntegrationTests/TestClasses.m
				
				
				//////////////////////////////////////////////////
				// 開頭
				
				__block NSUInteger uploadedLength = 0;
				__block NSFileHandle *fileHandle = [NSFileHandle fileHandleForReadingAtPath:self.fromPath];
				
				NSData *fileData = [fileHandle readDataOfLength:PPDropboxOperation_UploadFileChunkThreshold];
				
				self.uploadTask = [fileRoutes uploadSessionStartData:fileData];
				self.uploadTask = [[self.uploadTask setResponseBlock:^(DBFILESUploadSessionStartResult *result, DBNilObject *routeError, DBRequestError *error) {
					
					if (result != nil)
					{
						// success
						sessionID = [result.sessionId copy];
						uploadedLength += PPDropboxOperation_UploadFileChunkThreshold;
						cursor = [[DBFILESUploadSessionCursor alloc] initWithSessionId:sessionID offset:@(uploadedLength)];
					}
					else
					{
						returnError = [blockself convertErrorFromSystemError:error];
						[returnError retain];
					}
					
					dispatch_semaphore_signal(semaphore);

				} queue:[NSOperationQueue new]] setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend) {
					[blockself handleProgress:(CGFloat)(uploadedLength+totalBytesSent)/blockself.totalSize];
				}];
				
				dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
				
				if(returnError != nil)
				{
					[returnError autorelease];
					break;
				}
				
				
				//////////////////////////////////////////////////
				// 中段
				
				while(self.totalSize-uploadedLength > PPDropboxOperation_UploadFileChunkThreshold)
				{
					fileData = [fileHandle readDataOfLength:PPDropboxOperation_UploadFileChunkThreshold];
					
					self.uploadTask = [fileRoutes uploadSessionAppendV2Data:cursor inputData:fileData];
					self.uploadTask = [[self.uploadTask setResponseBlock:^(DBNilObject *result, DBFILESUploadSessionLookupError *routeError, DBRequestError *error) {
						
						if (error == nil)
						{
							// success
							uploadedLength += PPDropboxOperation_UploadFileChunkThreshold;
							[cursor release];
							cursor = [[DBFILESUploadSessionCursor alloc] initWithSessionId:sessionID offset:@(uploadedLength)];
						}
						else
						{
							// failure
							returnError = [blockself convertErrorFromSystemError:error];
							[returnError retain];
						}
						
						dispatch_semaphore_signal(semaphore);
						
					} queue:[NSOperationQueue new]] setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend) {
						[blockself handleProgress:(CGFloat)(uploadedLength+totalBytesSent)/blockself.totalSize];
					}];
					
					dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
					
					if(returnError != nil)
					{
						[returnError autorelease];
						break;
					}
				}
				
				
				//////////////////////////////////////////////////
				// 結尾
				
				DBFILESCommitInfo *commitInfo = [[[DBFILESCommitInfo alloc] initWithPath:destPath] autorelease];
				
				fileData = [fileHandle readDataToEndOfFile];
				
				self.uploadTask = [fileRoutes uploadSessionFinishData:cursor commit:commitInfo inputData:fileData];
				self.uploadTask = [[self.uploadTask setResponseBlock:^(DBFILESFileMetadata *result, DBFILESUploadSessionFinishError *routeError, DBRequestError *error) {
					
					if (result != nil)
					{
						// success
						metadata = [result retain];
					}
					else
					{
						// failure
						returnError = [blockself convertErrorFromSystemError:error];
						[returnError retain];
					}
					
					dispatch_semaphore_signal(semaphore);
					
				} queue:[NSOperationQueue new]] setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend) {
					[blockself handleProgress:(CGFloat)(uploadedLength+totalBytesSent)/blockself.totalSize];
				}];

				dispatch_semaphore_wait(semaphore, DISPATCH_TIME_FOREVER);
				[metadata autorelease];
				[returnError autorelease];
			}
        }
		while(0);

		dispatch_release(semaphore);
		[cursor release];
		[sessionID release];
		
        //////////////////////////////////////////////////

		if(returnError == nil)
		{
			if([self.delegate respondsToSelector:@selector(ppDropboxOperation:uploadedFile:from:metadata:)]==YES)
			{
				[self.delegate ppDropboxOperation:self
									 uploadedFile:destPath
											 from:self.fromPath
										 metadata:metadata];
			}
		}
		else
		{
			if([self.delegate respondsToSelector:@selector(ppDropboxOperation:uploadFileFailedWithError:)]==YES)
			{
				[self.delegate ppDropboxOperation:self uploadFileFailedWithError:returnError];
			}
		}
		
		[self completion];
    }
}


//================================================================================
// MARK: 批次上傳(目前進度顯示回傳有問題)
//================================================================================
//- (void)batchUpload
//{
//    @autoreleasepool
//    {
//        NSError *returnError = nil;
//        
//        do
//        {
//            if(self.uploadFile==nil || self.toPath==nil || self.fromPath==nil)
//            {
//                returnError = PPErrorParameterInvalidity(nil);
//                break;
//            }
//            
//            ////////////////////////////////////////////////////////////////////////////////////////////////////
//            
//            NSDictionary *fileAttributes = [[NSFileManager defaultManager] attributesOfItemAtPath:self.fromPath error:&returnError];
//            if(returnError!=nil)
//            {
//                break;
//            }
//            
//            ////////////////////////////////////////////////////////////////////////////////////////////////////
//            
//            NSNumber *fileSizeNumber = [fileAttributes objectForKey:NSFileSize];;
//            if(fileSizeNumber==nil)
//            {
//                returnError = PPErrorOperationFailed(nil);
//                break;
//            }
//            
//            self.totalSize = [fileSizeNumber unsignedLongLongValue];
//            
//            ////////////////////////////////////////////////////////////////////////////////////////////////////
//            
//            DBFILESUserAuthRoutes *fileRoutes = [DBClientsManager authorizedClient].filesRoutes;
//            
//            if(fileRoutes==nil)
//            {
//                returnError  = PPErrorParameterInvalidity(nil);
//                break;
//            }
//        
//            //////////////////////////////////////////////////
//            
//            NSString *fromPath = self.fromPath;
//            
//            if([fromPath hasPrefix:@"file://"]==NO)
//            {
//                fromPath = [@"file://" stringByAppendingString:fromPath];
//            }
//            
//            //////////////////////////////////////////////////
//            
//            NSURL *sourceURL = [NSURL URLWithString:[fromPath stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding]];
//            
//            if(sourceURL==nil)
//            {
//                returnError = PPErrorParameterInvalidity(nil);
//                
//                break;
//            }
//            
//            //////////////////////////////////////////////////
//            
//            NSMutableDictionary<NSURL *, DBFILESCommitInfo *> *uploadFilesUrlsToCommitInfo = [NSMutableDictionary dictionary];
//            
//            if(uploadFilesUrlsToCommitInfo==nil)
//            {
//                returnError = PPErrorParameterInvalidity(nil);
//                break;
//            }
//            
//            //////////////////////////////////////////////////
//            
//            DBFILESCommitInfo *commitInfo =
//            [[[DBFILESCommitInfo alloc] initWithPath:[self.toPath stringByAppendingString:[NSString stringWithFormat:@"/%@",self.uploadFile]]] autorelease];
//            
//            if(commitInfo==nil)
//            {
//                returnError = PPErrorParameterInvalidity(nil);
//                break;
//            }
//            
//            [uploadFilesUrlsToCommitInfo setObject:commitInfo forKey:sourceURL];
//            
//            //////////////////////////////////////////////////
//            
//            __block typeof(self) blockself = self;
//            
//            [fileRoutes batchUploadFiles:uploadFilesUrlsToCommitInfo
//                                   queue:nil
//                           progressBlock:^(int64_t uploaded, int64_t total, int64_t expectedTotal)
//             {
//                 if([self.delegate respondsToSelector:@selector(ppDropboxOperation:uploadProgress:forFile:from:)]==YES)
//                 {
//                     CGFloat progress = (CGFloat)uploaded/total;
//                     
//                     [self.delegate ppDropboxOperation:self uploadProgress:progress forFile:blockself.toPath from:blockself.fromPath];
//                 }
//                 
//             }
//                           responseBlock:^(NSDictionary<NSURL *,DBFILESUploadSessionFinishBatchResultEntry *> *fileUrlsToBatchResultEntries,
//                                           DBASYNCPollError *finishBatchRouteError,
//                                           DBRequestError *finishBatchRequestError,
//                                           NSDictionary<NSURL *,DBRequestError *> *fileUrlsToRequestErrors)
//             {
//                
//                 if(fileUrlsToBatchResultEntries!=nil)
//                 {
//                     if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:uploadedFile:from:metadata:)]==YES)
//                     {
//                         DBFILESUploadSessionFinishBatchResultEntry *resultEntry = [[fileUrlsToBatchResultEntries allValues] firstObject];
//                         
//                         if([resultEntry isSuccess]==YES)
//                         {
//                             [blockself.delegate ppDropboxOperation:blockself
//                                                       uploadedFile:blockself.toPath
//                                                               from:blockself.fromPath
//                                                           metadata:resultEntry.success];
//                         }
//                         else
//                         {
//                             // This particular file was not uploaded successfully, although the other
//                             // files may have been uploaded successfully. Perhaps implement some retry
//                             // logic here based on `uploadError`
//                             DBRequestError *uploadNetworkError = [[fileUrlsToRequestErrors allKeysForObject:resultEntry] firstObject];
//                             
//                             DBFILESUploadSessionFinishError *uploadSessionFinishError = resultEntry.failure;
//                             
//                             if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:uploadFileFailedWithError:)]==YES)
//                             {
//                                 NSError *convertedError = [blockself convertErrorFromSystemError:(uploadNetworkError!=nil)?uploadNetworkError:uploadSessionFinishError];
//                                 
//                                 [blockself.delegate ppDropboxOperation:blockself uploadFileFailedWithError:convertedError];
//                             }
//                         }
//                     }
//                 }
//                 else if (finishBatchRouteError)
//                 {
//                     if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:uploadFileFailedWithError:)]==YES)
//                     {
//                         NSError *convertedError = [blockself convertErrorFromSystemError:finishBatchRouteError];
//                         
//                         [blockself.delegate ppDropboxOperation:blockself uploadFileFailedWithError:convertedError];
//                     }
//
//                 }
//                 else if (finishBatchRequestError)
//                 {
//                     if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:uploadFileFailedWithError:)]==YES)
//                     {
//                         NSError *convertedError = [blockself convertErrorFromSystemError:finishBatchRequestError];
//                         
//                         [blockself.delegate ppDropboxOperation:blockself uploadFileFailedWithError:convertedError];
//                     }
//
//                 }
//                 else if (fileUrlsToRequestErrors)
//                 {
//                     if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:uploadFileFailedWithError:)]==YES)
//                     {
//                         NSError *convertedError = [blockself convertErrorFromSystemError:fileUrlsToRequestErrors];
//                         
//                         [blockself.delegate ppDropboxOperation:blockself uploadFileFailedWithError:convertedError];
//                     }
//                 }
//                 else
//                 {
//                     if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:uploadFileFailedWithError:)]==YES)
//                     {
//                         NSError *convertedError = [blockself convertErrorFromSystemError:PPErrorOperationFailed(nil)];
//                         
//                         [blockself.delegate ppDropboxOperation:blockself uploadFileFailedWithError:convertedError];
//                     }
//                 }
//          
//                 //////////////////////////////////////////////////
//                 
//                 [self completion];
//             }];
//                        
//        }while(0);
//        
//        //////////////////////////////////////////////////
//        
//        if(returnError!=nil &&
//           [self.delegate respondsToSelector:@selector(ppDropboxOperation:uploadFileFailedWithError:)]==YES)
//        {
//            [self.delegate ppDropboxOperation:self uploadFileFailedWithError:returnError];
//            
//            [self completion];
//        }
//    }
//}
@end
