//
//  PPDropboxOperation_Sharedlink.m
//  Pods
//
//  Created by Andrew on 2015/1/15.
//  Copyright (c) 2015年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_Sharedlink.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPDropboxOperation_Sharedlink Implementation

@implementation PPDropboxOperation_Sharedlink





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.sharedlinkFile = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *returnError = nil;
        
        do
        {
            if (self.sharedlinkFile==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            
            DBSHARINGUserAuthRoutes *sharingRoutes = [DBClientsManager authorizedClient].sharingRoutes;
            
            if(sharingRoutes==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            // 先取得檔案的 share link

//            [[[sharingRoutes getFileMetadata:self.sharedlinkFile] setResponseBlock:^(DBSHARINGSharedFileMetadata *filesMetadata, DBSHARINGGetFileMetadataError *routeError, DBRequestError *error)
//              {
//                  if(filesMetadata!=nil)
//                  {
//                      if ([self.delegate respondsToSelector:@selector(ppDropboxOperation:sharedlinkString:)]==YES)
//                      {
//                          [self.delegate ppDropboxOperation:self sharedlinkString:filesMetadata.previewUrl];
//                      }
//                      
//                      //////////////////////////////////////////////////
//                      
//                      [blockself completion];
//                  }
//                  else
//                  {
//                      if(routeError.tag==DBSHARINGSharingFileAccessErrorInvalidFile)
//                      {
//                          //取得失敗，直接建立
                          [self createShareFileLink];
//                      }
//                      else
//                      {
//                          if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:sharedlinkFailedWithError:)]==YES)
//                          {
//                              [blockself.delegate ppDropboxOperation:self sharedlinkFailedWithError:returnError];
//                          }
//                          
//                          [blockself completion];
//                      }
//                  }
//              }]
//             setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend)
//             {
//                 
//             }];
  
        }while (0);
        
        //////////////////////////////////////////////////
        // 產生shared link中途失敗
        
        if (returnError!=nil)
        {
            if ([self.delegate respondsToSelector:@selector(ppDropboxOperation:sharedlinkFailedWithError:)]==YES)
            {
                [self.delegate ppDropboxOperation:self sharedlinkFailedWithError:returnError];
            }
            
            [self completion];
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - DBRestClientDelegate Methods

//================================================================================
//
//================================================================================
- (void)createShareFileLink
{
    NSError *returnError = nil;
    
    do
    {
        DBSHARINGUserAuthRoutes *sharingRoutes = [DBClientsManager authorizedClient].sharingRoutes;
        
        if(sharingRoutes==nil)
        {
            returnError  = PPErrorParameterInvalidity(nil);
            break;
        }
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        // 建立網空上對應file的shared link
        [[[sharingRoutes createSharedLinkWithSettings:self.sharedlinkFile]
          setResponseBlock:^(DBSHARINGSharedLinkMetadata *sharedLinkMetadata, DBSHARINGCreateSharedLinkWithSettingsError *routeError,
                     DBRequestError *error)
          {
              if(sharedLinkMetadata!=nil && routeError==nil)
              {
                  if ([self.delegate respondsToSelector:@selector(ppDropboxOperation:sharedlinkString:)]==YES)
                  {
                      NSMutableString *downloadURL = [NSMutableString stringWithString:sharedLinkMetadata.url];
                      [downloadURL replaceCharactersInRange:NSMakeRange(downloadURL.length-1, 1) withString:@"1"];

                      [self.delegate ppDropboxOperation:self sharedlinkString:downloadURL];
                  }
              }
              else
              {
                  if ([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:sharedlinkFailedWithError:)]==YES)
                  {
                      NSError *convertedError = [blockself convertErrorFromSystemError:error];
                      
                      [blockself.delegate ppDropboxOperation:blockself sharedlinkFailedWithError:convertedError];
                  }
              }
              
              //////////////////////////////////////////////////
              
              [blockself completion];
          }]
         setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend) {
             
         }];
    }
    while (0);
    
    //////////////////////////////////////////////////

    if(returnError!=nil)
    {
        if ([self.delegate respondsToSelector:@selector(ppDropboxOperation:sharedlinkFailedWithError:)]==YES)
        {
            [self.delegate ppDropboxOperation:self sharedlinkFailedWithError:returnError];
        }
    }
}
@end
