//
//  PPDropboxOperation_LoadAccountInfo.m
//  
//
//  Created by Mike on 13-3-13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_LoadAccountInfo.h"

@implementation PPDropboxOperation_LoadAccountInfo

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    DBUSERSUserAuthRoutes *users = [DBClientsManager authorizedClient].usersRoutes;
    
    [[[users getCurrentAccount] setResponseBlock:^(DBUSERSFullAccount *account, DBNilObject *routeError, DBRequestError *error)
      {
          if(account!=nil)
          {
              [self getUserSpaceWithAccountInfo:account];
          }
          else
          {
              if([self.delegate respondsToSelector:@selector(ppDropboxOperation:loadAccountInfoFailedWithError:)]==YES)
              {
                  NSError *convertedError = [self convertErrorFromSystemError:error];
                  
                  [self.delegate ppDropboxOperation:self loadAccountInfoFailedWithError:convertedError];
              }
              
              //////////////////////////////////////////////////
              
              [self completion];
          }
      }]
     setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend)
     {
         
     }];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Privat Method

//================================================================================
//
//================================================================================
- (void)getUserSpaceWithAccountInfo:(DBUSERSFullAccount *)account
{
    DBUSERSUserAuthRoutes *users = [DBClientsManager authorizedClient].usersRoutes;

    [[[users getSpaceUsage] setResponseBlock:^(DBUSERSSpaceUsage *userSpaceUsage, DBNilObject *routeError, DBRequestError *error) {
        
        if(userSpaceUsage!=nil)
        {
            if([self.delegate respondsToSelector:@selector(ppDropboxOperation:loadedAccountInfo:useSpaceUsage:)]==YES)
            {
                [self.delegate ppDropboxOperation:self loadedAccountInfo:account useSpaceUsage:userSpaceUsage];
            }
        }
        else
        {
            if([self.delegate respondsToSelector:@selector(ppDropboxOperation:loadAccountInfoFailedWithError:)]==YES)
            {
                NSError *convertedError = [self convertErrorFromSystemError:error];
                
                [self.delegate ppDropboxOperation:self loadAccountInfoFailedWithError:convertedError];
            }
        }
        
        //////////////////////////////////////////////////

        [self completion];
    }]
     setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend)
    {
        
    }];
}

@end
