//
//  PPDropboxOperation_Delete.m
//  
//
//  Created by Mike on 13-3-14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_Delete.h"

@implementation PPDropboxOperation_Delete

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize deletePath = deletePath_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (void)dealloc
{
    [deletePath_ release];
	
	////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

//================================================================================
//
//================================================================================
- (void)main
{
    @autoreleasepool
    {
        NSError *returnError = nil;
        
        do
        {
            if(self.deletePath==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            DBFILESUserAuthRoutes *fileRoutes = [DBClientsManager authorizedClient].filesRoutes;
            
            if(fileRoutes==nil)
            {
                returnError  = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            __block typeof(self) blockself = self;
            
            [[[fileRoutes delete_V2:self.deletePath]
			  setResponseBlock:^(DBFILESDeleteResult * _Nullable result, DBFILESDeleteError * _Nullable routeError, DBRequestError * _Nullable networkError) {

                  if ([result metadata] != nil)
                  {
                      if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:deletedPath:)]==YES)
                      {
                          [blockself.delegate ppDropboxOperation:blockself deletedPath:blockself.deletePath];
                      }
                  }
                  else
                  {
                      if([blockself.delegate respondsToSelector:@selector(ppDropboxOperation:deletePathFailedWithError:)]==YES)
                      {
                          NSError *convertedError = [blockself convertErrorFromSystemError:networkError];
                          
                          [blockself.delegate ppDropboxOperation:blockself deletePathFailedWithError:convertedError];
                      }
                  }
                  
                  //////////////////////////////////////////////////

                  [blockself completion];
              }] setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend) {
                          
			  }];

        }while(0);
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        if(returnError!=nil)
        {
            if(self.delegate!=nil && [self.delegate respondsToSelector:@selector(ppDropboxOperation:deletePathFailedWithError:)]==YES)
            {
                [self.delegate ppDropboxOperation:self deletePathFailedWithError:returnError];
            }
            
            [self completion];
        }
    }
}
@end
