//
//  PPDropboxOperation_CreateFolder.m
//  
//
//  Created by Mike on 13-3-13.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPDropboxOperation_CreateFolder.h"

@implementation PPDropboxOperation_CreateFolder

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize createFolder = createFolder_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [createFolder_ release];
	
    ////////////////////////////////////////////////////////////////////////////////////////////////////
	
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Executing the Operation

- (void)main
{
    @autoreleasepool
    {
        NSError *returnError = nil;
        
        do
        {
            if(self.createFolder==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            DBFILESUserAuthRoutes *files = [DBClientsManager authorizedClient].filesRoutes;
            
            if(files==nil)
            {
                returnError = PPErrorParameterInvalidity(nil);
                break;
            }
            
            //////////////////////////////////////////////////
            
            [[[files createFolderV2:self.createFolder] setResponseBlock:^(DBFILESCreateFolderResult * _Nullable result, DBFILESCreateFolderError * _Nullable routeError, DBRequestError * _Nullable networkError) {
                  if(result!=nil)
                  {
                      if([self.delegate respondsToSelector:@selector(ppDropboxOperation:createdFolder:)]==YES)
                      {
                          [self.delegate ppDropboxOperation:self createdFolder:result.metadata];
                      }
                  }
                  else
                  {
                      if(self.delegate!=nil &&
                         [self.delegate respondsToSelector:@selector(ppDropboxOperation:createFolderFailedWithError:)]==YES)
                      {
                          if([networkError.statusCode integerValue]==409 &&
                             [networkError.errorContent containsString:@"path/conflict/folder/"]==YES)
                          {
                              [self.delegate ppDropboxOperation:self createFolderFailedWithError:PPErrorMake(PPCloudCommonError_PathAlreadyExist, @"PathAlreadyExist", networkError)];
                          }
                          else
                          {
                              [self.delegate ppDropboxOperation:self createFolderFailedWithError:[self convertErrorFromSystemError:networkError]];
                          }
                      }
                  }
                  
                  //////////////////////////////////////////////////
                  
                  [self completion];
              }]
             setProgressBlock:^(int64_t bytesSent, int64_t totalBytesSent, int64_t totalBytesExpectedToSend) {
            
              }];

        }while(0);
        
        //////////////////////////////////////////////////

        if(returnError!=nil &&
           [self.delegate respondsToSelector:@selector(ppDropboxOperation:createFolderFailedWithError:)]==YES)
        {
            [self.delegate ppDropboxOperation:self createFolderFailedWithError:returnError];
            
            [self completion];
        }
    }
}


@end

