//
//  PPCloudOperation.m
//
//

#import "PPCloudOperation.h"

// Category
#import "PPCloud+ParameterDefine.h"
#import "NSError+Custom.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSTimeInterval const PPCloudOperation_WaitInterval = 0.1;

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPCloudOperation

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.delegate = nil;
    self.userInfo = nil;
    
    [super dealloc];
}


//================================================================================
//
//================================================================================
- (void)cancel
{
    self.delegate = nil;
    self.userInfo = nil;
    
    [super cancel];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method


//================================================================================
//
//================================================================================
- (BOOL)combineChunkFileList:(NSArray <NSString *> *)chunkFileList
       toDestinationFilePath:(NSString *)destinationFilePath
                   withError:(NSError **)error
{
    // 把下載的檔案內容讀取，組成NSData, 寫入成完成檔案
    BOOL result = NO;
    NSError *returnError = nil;
    NSFileHandle *fileHandle = nil;
    NSData *readData = nil;
    
    do
    {
        if([destinationFilePath length]<=0)
        {
            returnError = [PPErrorMake(PPCloudCommonError_WriteFileFail, @"Destination file path length is zero", nil) retain];
            break;
        }
       
        //////////////////////////////////////////////////

        // 刪除已存在相同路徑的檔案
        if([[NSFileManager defaultManager] fileExistsAtPath:destinationFilePath]==YES)
        {
            [[NSFileManager defaultManager] removeItemAtPath:destinationFilePath error:nil];
        }
       
        //////////////////////////////////////////////////
        
        for(NSString *chunkFile in chunkFileList)
        {
            @autoreleasepool
            {
                readData = [NSData dataWithContentsOfFile:chunkFile];
                
                if(readData==nil)
                {
                    returnError = [PPErrorMake(PPCloudCommonError_ReadChunkFileFail, @"ReadChunkFileFail", nil) retain];
                    break;
                }
                
                //////////////////////////////////////////////////
                
                fileHandle = [NSFileHandle fileHandleForWritingAtPath:destinationFilePath];
                
                //////////////////////////////////////////////////
                
                //檔案不存在
                if(fileHandle==nil)
                {
                    //寫檔失敗
                    if([readData writeToFile:destinationFilePath atomically:YES]==NO)
                    {
                        returnError = [PPErrorMake(PPCloudCommonError_WriteFileFail, @"ReadChunkFileFail", nil) retain];
                        break;
                    }
                }
                else
                {
                    [fileHandle seekToEndOfFile];
                    
                    [fileHandle writeData:readData];
                }
                
                
                //////////////////////////////////////////////////
                
                //刪除暫存
                [[NSFileManager defaultManager] removeItemAtPath:chunkFile error:nil];
                
                //////////////////////////////////////////////////

                [fileHandle closeFile];
                
                // auto release end
            }
            
            // for loop end
        }
        
        //////////////////////////////////////////////////

        if(returnError==nil)
        {
            result = YES;
        }
        
        // while loop end
    }
    while (0);
    
    if(error!=nil)
    {
        *error = returnError;
    }
    
    [returnError autorelease];
    
    return result;
}


@end
