//
//  PPCloudMetadata.m
//  
//
//  Created by Mike on 13/5/14.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPCloudMetadata.h"

@implementation PPCloudMetadata

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize cloudClassName      = cloudClassName_;
@synthesize path                = path_;
@synthesize lastModifiedDate    = lastModifiedDate_;
@synthesize uniqueID            = uniqueID_;
@synthesize contents            = contents_;
@synthesize fileHash            = fileHash_;
@synthesize fileName            = fileName_;
@synthesize fileSize            = fileSize_;
@synthesize thumbnailExists     = thumbnailExists_;
@synthesize isDirectory         = isDirectory_;
@synthesize rawData             = rawData_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (void)dealloc
{
    [cloudClassName_ release];
    [path_ release];
    [lastModifiedDate_ release];
    [uniqueID_ release];
    [contents_ release];
    [fileHash_ release];
    [fileName_ release];
    [fileSize_ release];
	[rawData_ release];
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Describing Objects

- (NSString *)description
{
	return [NSString stringWithFormat:@"[PPCloudMetadata]\ncloudClassName:%@\npath:%@\nlastModifiedDate:%@\nuniqueID:%@\ncontents:%@\nfileHash:%@\nfileName:%@\nfileSize:%@\nthumbnailExists:%d\nisDirectory:%d\nrawData:%@",
            self.cloudClassName,
            self.path,
            self.lastModifiedDate,
            self.uniqueID,
            self.contents,
            self.fileHash,
            self.fileName,
            self.fileSize,
            self.thumbnailExists,
            self.isDirectory,
            self.rawData];
}

@end
