//
//  PPClipContactPhotoMaskView.m
//  Pods
//
//  Created by AndrewLai on 2015/9/24.
//
//

#import "PPClipContactPhotoMaskView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPClipContactPhotoMaskView Implementation

@implementation PPClipContactPhotoMaskView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//===============================================================================
- (id)initWithFrame:(CGRect)frame
{
    if (self=[super initWithFrame:frame])
    {
        self.backgroundColor = [UIColor clearColor];
        
        //////////////////////////////////////////////////
        
        self.showClearRect = frame;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_maskColor release];
    _maskColor = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Override Method

//================================================================================
//
//===============================================================================
- (void)drawRect:(CGRect)rect
{
    [super drawRect:rect];
    
    //////////////////////////////////////////////////
    
    CGContextRef context = UIGraphicsGetCurrentContext();
    
    CGContextSaveGState(context);
    
    // set clip path
    UIBezierPath *clipPath = [UIBezierPath bezierPathWithRect:CGRectInfinite];
    
    [clipPath appendPath:[UIBezierPath bezierPathWithOvalInRect:self.showClearRect]];
    [clipPath setUsesEvenOddFillRule:YES];
    [clipPath addClip];
    [[UIColor clearColor] setFill];
    
    // set mask color
    [self.maskColor setFill];
    UIRectFill(rect);
    
    CGContextRestoreGState(context);
}


//================================================================================
// 不接收觸碰事件，直接傳遞至下一層
//===============================================================================
- (UIView *)hitTest:(CGPoint)point withEvent:(UIEvent *)event
{
    return nil;
}

@end
