//
//  PPClipBusinessCardSelectRectangleImageScrollView.m
//
//
//  Created by Andrewlia on 14/1/3.
//  Copyright (c) 2014年 Andrewlia. All rights reserved.
//

#import "PPClipBusinessCardSelectRectangleImageScrollView.h"
#import "PPMagnifierView.h"
#import "NSTimer+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPClipBusinessCardSelectRectangleImageScrollView()

@interface PPClipBusinessCardSelectRectangleImageScrollView ()
@property (nonatomic, assign) BOOL                                                     boundaryOut;
@property (nonatomic, assign) CGPoint                                                  distanceToOriginalPoint;
@property (nonatomic, assign) CGPoint                                                  scrollDirection;
@property (nonatomic, retain) NSTimer                                                  *timer;
@property (nonatomic, assign) PPClipBusinessCardSelectRectangleImageScrollViewTouch    ppClipBusinessCardSelectRectangleImageScrollViewTouch;
@property (nonatomic, retain) PPMagnifierView                                          *magnifierView;// 放大鏡元件

- (BOOL)controlPointWithTouch:(CGPoint)touch;
- (PPClipBusinessCardSelectRectangleImageScrollViewTouch)selectRectMode;
- (void)initializeTimer;
- (void)moveSelectRectangleByMovePoint:(CGPoint)movePoint;
- (void)resizeSelectRectangleByMovePoint:(CGPoint)movePoint;
- (void)scrollViewByMovement;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPClipBusinessCardSelectRectangleImageScrollView

@implementation PPClipBusinessCardSelectRectangleImageScrollView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - synthesize

@synthesize
selectRectDelegate                                       = selectRectDelegate_,
boundaryOut                                              = boundaryOut_,
distanceToOriginalPoint                                  = distanceToOriginalPoint_,
scrollDirection                                          = scrollDirection_,
rectSelected                                             = rectSelected_,
minimumImageViewSize                                     = minimumImageViewSize_,
timer                                                    = timer_,
ppClipBusinessCardSelectRectangleImageScrollViewTouch    = ppClipBusinessCardSelectRectangleImageScrollViewTouch_;








////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods

//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    [self.timer invalidate];
    self.timer = nil;
    
    [self.magnifierView removeFromSuperview];
    self.magnifierView = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}


////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to Touch Events

//================================================================================
// 碰觸未移動事件
//================================================================================
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event
{
    NSSet *allTouches = [event allTouches];
    
    if ([allTouches count]==1)
    {
        CGPoint touchPoint          = [[touches anyObject] locationInView:self.imageView];
        CGRect standardRectSelected = CGRectStandardize(self.rectSelected);
        
        self.distanceToOriginalPoint                               = CGPointMake(touchPoint.x-standardRectSelected.origin.x, touchPoint.y-standardRectSelected.origin.y);
        self.ppClipBusinessCardSelectRectangleImageScrollViewTouch = [self selectRectMode];
        
        //////////////////////////////////////////////////
        // 點選狀態變換邊框
        
        switch (self.ppClipBusinessCardSelectRectangleImageScrollViewTouch)
        {
            case PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectMove:
            {
                if (self.selectRectDelegate!=nil && [self.selectRectDelegate respondsToSelector:@selector(ppClipBusinessCardSelectRectangleImageScrollViewDidRectMove:)])
                {
                    [self.selectRectDelegate ppClipBusinessCardSelectRectangleImageScrollViewDidRectMove:self];
                    
                    [self initializeTimer];
                    
                    self.boundaryOut = NO;
                }
                
                break;
            }
            case PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectResize:
            {
                if (self.selectRectDelegate!=nil && [self.selectRectDelegate respondsToSelector:@selector(ppClipBusinessCardSelectRectangleImageScrollViewDidRectResize:)])
                {
                    [self.selectRectDelegate ppClipBusinessCardSelectRectangleImageScrollViewDidRectResize:self];
                    
                    self.boundaryOut = NO;
                }
                
                //////////////////////////////////////////////////
                // 放大鏡效果
                
                __block PPClipBusinessCardSelectRectangleImageScrollView *blockSelf = self;
                dispatch_async(dispatch_get_main_queue(), ^{
                    _magnifierView = [[PPMagnifierView alloc] initWithFrame:blockSelf.superview.frame];
                    if (blockSelf.magnifierView != nil)
                    {
                        blockSelf.magnifierView.targetView = blockSelf.superview;
                        
                        [_magnifierView setFrame:CGRectMake(0, 0, PPMagnifierViewDefaultRadius*2, PPMagnifierViewDefaultRadius*2)];
                        [blockSelf.magnifierView setTargetPoint:[[touches anyObject] locationInView:blockSelf.superview]];
                        
                        [blockSelf.magnifierView setNeedsDisplay];
                    }
                });
                
                break;
            }
            default:
            {
                break;
            }
        }
        
    }
    
    //////////////////////////////////////////////////
    
    [super touchesBegan:touches withEvent:event];
}


//================================================================================
// 碰觸移動事件
//================================================================================
- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event
{
    NSSet *allTouches = [event allTouches];
    
    if ([allTouches count]==1)
    {
        CGPoint pointTouchMove = [[touches anyObject] locationInView:self.imageView];
        
        switch (self.ppClipBusinessCardSelectRectangleImageScrollViewTouch)
        {
            case PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectMove:
            {
                [self moveSelectRectangleByMovePoint:pointTouchMove];
                
                if (self.selectRectDelegate!=nil && [self.selectRectDelegate respondsToSelector:@selector(ppClipBusinessCardSelectRectangleImageScrollViewDidRectMove:)])
                {
                    [self.selectRectDelegate ppClipBusinessCardSelectRectangleImageScrollViewDidRectMove:self];
                }
                
                break;
            }
            case PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectResize:
            {
                [self resizeSelectRectangleByMovePoint:pointTouchMove];
                
                if (self.selectRectDelegate!=nil && [self.selectRectDelegate respondsToSelector:@selector(ppClipBusinessCardSelectRectangleImageScrollViewDidRectResize:)])
                {
                    [self.selectRectDelegate ppClipBusinessCardSelectRectangleImageScrollViewDidRectResize:self];
                }
                
                //////////////////////////////////////////////////
                // 放大鏡
                
                [self.magnifierView setTargetPoint:[[touches anyObject] locationInView:self.superview]];
                [self.magnifierView setNeedsDisplay];
                
                break;
            }
            default:
            {
                break;
            }
        }
        
    }
    
    //////////////////////////////////////////////////
    
    [super touchesMoved:touches withEvent:event];
}


//================================================================================
// 碰觸移動事件
//================================================================================
- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event
{
    self.scrollDirection = CGPointZero;
    
    [self.timer invalidate];
    self.timer = nil;
    
    if (self.selectRectDelegate!=nil && [self.selectRectDelegate respondsToSelector:@selector(ppClipBusinessCardSelectRectangleImageScrollViewDidTouchUp:)])
    {
        [self.selectRectDelegate ppClipBusinessCardSelectRectangleImageScrollViewDidTouchUp:self];
    }
    
    //////////////////////////////////////////////////
    // 放大鏡
    
    self.magnifierView.targetView = nil;
    
    //////////////////////////////////////////////////
    
    [super touchesEnded:touches withEvent:event];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods

//================================================================================
// 設定proxy
//================================================================================
- (void)setSelectRectDelegate:(id<PPClipBusinessCardSelectRectangleImageScrollViewDelegate>)selectRectDelegate
{
    selectRectDelegate_ = selectRectDelegate;
    
    self.proxy          = selectRectDelegate;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
// 判斷是否點擊到控制點
//================================================================================
- (BOOL)controlPointWithTouch:(CGPoint)touch
{
    BOOL touchOnControl = NO;
    
    CGRect standardRectSelected  = CGRectStandardize(self.rectSelected);
    
//    CGPoint pointLeftUp          = standardRectSelected.origin;
    
    CGRect controlPointLeftUp    = CGRectMake(standardRectSelected.origin.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              standardRectSelected.origin.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);;
    
    CGPoint pointLeftDown        = CGPointMake(standardRectSelected.origin.x, standardRectSelected.origin.y+standardRectSelected.size.height);
    CGRect controlPointLeftDown  = CGRectMake(pointLeftDown.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              pointLeftDown.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);;
    
    CGPoint pointRightUp         = CGPointMake(standardRectSelected.origin.x+standardRectSelected.size.width, standardRectSelected.origin.y);
    CGRect controlPointRightUp   = CGRectMake(pointRightUp.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              pointRightUp.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);;
    
    CGPoint pointRightDown       = CGPointMake(standardRectSelected.origin.x+standardRectSelected.size.width,
                                               standardRectSelected.origin.y+standardRectSelected.size.height);
    CGRect controlPointRightDown = CGRectMake(pointRightDown.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              pointRightDown.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
                                              2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);;
    
//    CGPoint pointLeftMindle        = CGPointMake((pointLeftUp.x+pointLeftDown.x)/2, (pointLeftUp.y+pointLeftDown.y)/2);
//    CGRect  controlPointLeftMindle = CGRectMake(pointLeftMindle.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                pointLeftMindle.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
//                                                2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);
//    
//    CGPoint pointRightMindle        = CGPointMake((pointRightUp.x+pointRightDown.x)/2, (pointRightUp.y+pointRightDown.y)/2);
//    CGRect  controlPointRightMindle = CGRectMake(pointRightMindle.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                 pointRightMindle.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                 2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
//                                                 2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);
//    
//    CGPoint pointUpMindle           = CGPointMake((pointLeftUp.x+pointRightUp.x)/2, (pointLeftUp.y+pointRightUp.y)/2);
//    CGRect  controlPointUpMindle    = CGRectMake(pointUpMindle.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                 pointUpMindle.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                 2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
//                                                 2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);
//    
//    CGPoint pointDownMindle         = CGPointMake((pointLeftDown.x+pointRightDown.x)/2, (pointLeftDown.y+pointRightDown.y)/2);
//    CGRect  controlPointDownMindle  = CGRectMake(pointDownMindle.x-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                 pointDownMindle.y-PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
//                                                 2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1,
//                                                 2*PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance+1);

    
    ////////////////////////////////////////////////////////////////////////////////////////////////////

    if (CGRectContainsPoint(controlPointRightDown, touch)==YES)
    {
        touchOnControl      = YES;
        self.rectSelected   = standardRectSelected;
    }
    else if (CGRectContainsPoint(controlPointLeftUp, touch)==YES)
    {
        touchOnControl      = YES;
        self.rectSelected   = CGRectMake(pointRightDown.x, pointRightDown.y, -standardRectSelected.size.width, -standardRectSelected.size.height);
    }
    else if (CGRectContainsPoint(controlPointLeftDown, touch)==YES)
    {
        touchOnControl      = YES;
        self.rectSelected   = CGRectMake(pointRightUp.x, pointRightUp.y, -standardRectSelected.size.width, standardRectSelected.size.height);
    }
    else if (CGRectContainsPoint(controlPointRightUp, touch)==YES)
    {
        touchOnControl      = YES;
        self.rectSelected   = CGRectMake(pointLeftDown.x, pointLeftDown.y, standardRectSelected.size.width, -standardRectSelected.size.height);
    }
//    // TODO: Howard Fix the problem
//    else if (CGRectContainsPoint(controlPointUpMindle, touch)==YES)
//    {
//        touchOnControl      = YES;
//        self.rectSelected   = CGRectMake(pointDownMindle.x+standardRectSelected.size.width/2, pointDownMindle.y, -standardRectSelected.size.width, -standardRectSelected.size.height);
//    }
//    else if (CGRectContainsPoint(controlPointDownMindle, touch)==YES)
//    {
//        touchOnControl      = YES;
//        self.rectSelected   = CGRectMake(pointUpMindle.x-standardRectSelected.size.width/2, pointUpMindle.y, standardRectSelected.size.width, standardRectSelected.size.height);
//    }
//    else if (CGRectContainsPoint(controlPointLeftMindle, touch)==YES)
//    {
//        touchOnControl      = YES;
//        self.rectSelected   = CGRectMake(pointRightMindle.x, pointRightMindle.y, standardRectSelected.size.width, -standardRectSelected.size.height);
//    }
//    else if (CGRectContainsPoint(controlPointRightMindle, touch)==YES)
//    {
//        touchOnControl      = YES;
//        self.rectSelected   = CGRectMake(pointLeftMindle.x, pointLeftMindle.y, standardRectSelected.size.width, -standardRectSelected.size.height);
//    }
   
    
    return touchOnControl;
}


//================================================================================
// 設定 ppClipBusinessCardSelectRectangleImageScrollViewTouchTag
//================================================================================
- (PPClipBusinessCardSelectRectangleImageScrollViewTouch)selectRectMode
{
    PPClipBusinessCardSelectRectangleImageScrollViewTouch selectRectangleMode = PPClipBusinessCardSelectRectangleImageScrollViewTouch_None;
    
    //////////////////////////////////////////////////
    // 先判斷是否點擊到方框
    
    CGRect standardRectSelected       = CGRectStandardize(self.rectSelected);
    CGRect extendStandardRectSelected = CGRectInset(standardRectSelected,
                                                    -PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance,
                                                    -PPClipBusinessCardSelectRectangleImageScrollViewRectControlPointSelectedDistance);
    CGRect insetStandardRectSelected  = CGRectInset(standardRectSelected,
                                                    PPClipBusinessCardSelectRectangleImageScrollViewRectClipSelectedDistance,
                                                    PPClipBusinessCardSelectRectangleImageScrollViewRectClipSelectedDistance);
    
    
    CGPoint touchPoint = CGPointMake(standardRectSelected.origin.x+self.distanceToOriginalPoint.x, standardRectSelected.origin.y+self.distanceToOriginalPoint.y);
    
    if (CGRectContainsPoint(extendStandardRectSelected, touchPoint)==NO)
    {
        self.scrollEnabled  = YES;
        selectRectangleMode = PPClipBusinessCardSelectRectangleImageScrollViewTouch_ImageViewMove;
        NSLog(@"PPClipBusinessCardSelectRectangleImageScrollViewTouch_ImageViewMove");
    }
    else
    {
        //////////////////////////////////////////////////
        // 判斷是否點擊到方框內部
        
        if ((CGRectContainsPoint(insetStandardRectSelected, touchPoint)==YES) ||
            (CGRectContainsPoint(standardRectSelected, touchPoint)==YES))
        {
            self.scrollEnabled  = NO;
            selectRectangleMode = PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectMove;
            NSLog(@"PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectMove");
        }
        
        //////////////////////////////////////////////////
        // 判斷是否點擊到控制點
        
        if([self controlPointWithTouch:touchPoint]==YES)
        {
            self.scrollEnabled  = NO;
            selectRectangleMode = PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectResize;
            NSLog(@"PPClipBusinessCardSelectRectangleImageScrollViewTouch_RectResize");
        }
    }
    
    return selectRectangleMode;
}


//================================================================================
// 用來設定使用Timer & 計時器的相關參數
//================================================================================
- (void)initializeTimer
{
    CGFloat theInterval = 1.0/10.0;
    
    __block typeof(self) blockSelf = self;
    
    self.timer = [NSTimer pp_scheduledTimerWithTimeInterval:theInterval
                                                    repeats:YES
                                                      block:^(NSTimer * _Nonnull timer) {
                                                          [blockSelf scrollViewByMovement];
                                                      }];
}


//================================================================================
// 移動矩形位置並設定rectSelected
//================================================================================
- (void)moveSelectRectangleByMovePoint:(CGPoint)movePoint
{
    //////////////////////////////////////////////////
    // 判斷是否超過imageView的範圍
    
    if (self.boundaryOut==YES)
    {
        if (CGRectContainsPoint(self.rectSelected, movePoint))
        {
            CGPoint distance = self.distanceToOriginalPoint;
            
            if (self.image.size.width/self.frame.size.width>=self.image.size.height/self.frame.size.height)
            {
                if ((self.rectSelected.origin.y+self.distanceToOriginalPoint.y+PPClipBusinessCardSelectRectangleImageScrollViewRectClipSelectedDistance>=movePoint.y) && (self.rectSelected.origin.y+self.distanceToOriginalPoint.y-PPClipBusinessCardSelectRectangleImageScrollViewRectClipSelectedDistance<=movePoint.y))
                {
                    distance.x = movePoint.x-self.rectSelected.origin.x;
                    self.boundaryOut = NO;
                }
            }
            else
            {
                if ((self.rectSelected.origin.x+self.distanceToOriginalPoint.x+PPClipBusinessCardSelectRectangleImageScrollViewRectClipSelectedDistance>=movePoint.x) && (self.rectSelected.origin.x+self.distanceToOriginalPoint.x-PPClipBusinessCardSelectRectangleImageScrollViewRectClipSelectedDistance<=movePoint.x))
                {
                    distance.y = movePoint.y-self.rectSelected.origin.y;
                    self.boundaryOut = NO;
                }
            }
            
            self.distanceToOriginalPoint = distance;
        }
    }
    else if (CGRectContainsPoint(CGRectMake(0, 0, self.minimumImageViewSize.width, self.minimumImageViewSize.height), movePoint)==false)
    {
        self.boundaryOut = YES;
    }
    
    //////////////////////////////////////////////////
    // 方框移動
    
    if (self.boundaryOut==NO)
    {
        CGRect standardRectSelected = CGRectStandardize(self.rectSelected);
        self.scrollDirection        = CGPointMake(movePoint.x-standardRectSelected.origin.x-self.distanceToOriginalPoint.x,
                                                  movePoint.y-standardRectSelected.origin.y-self.distanceToOriginalPoint.y);
        
        standardRectSelected.origin.x = movePoint.x-self.distanceToOriginalPoint.x;
        standardRectSelected.origin.y = movePoint.y-self.distanceToOriginalPoint.y;
        
        //////////////////////////////////////////////////
        // 碰觸邊界偵測
        
        if (standardRectSelected.origin.x<0)
        {
            standardRectSelected.origin.x = 0;
        }
        else if (standardRectSelected.origin.x+standardRectSelected.size.width>self.minimumImageViewSize.width)
        {
            standardRectSelected.origin.x = standardRectSelected.origin.x+self.minimumImageViewSize.width-standardRectSelected.origin.x-standardRectSelected.size.width;
        }
        
        if (standardRectSelected.origin.y<0)
        {
            standardRectSelected.origin.y = 0;
        }
        else if (standardRectSelected.origin.y+standardRectSelected.size.height>self.minimumImageViewSize.height)
        {
            standardRectSelected.origin.y = standardRectSelected.origin.y+self.minimumImageViewSize.height-standardRectSelected.origin.y-standardRectSelected.size.height;
        }
        
        self.rectSelected = standardRectSelected;
    }
}


//================================================================================
// 改變矩形大小並設定rectSelected
//================================================================================
- (void)resizeSelectRectangleByMovePoint:(CGPoint)movePoint
{
    //////////////////////////////////////////////////
    // 判斷是否超過imageView的範圍
    
    if (self.boundaryOut==YES)
    {
        if ([self controlPointWithTouch:movePoint]==YES)
        {
            self.distanceToOriginalPoint = CGPointMake(movePoint.x-self.rectSelected.origin.x, movePoint.y-self.rectSelected.origin.y);
            self.boundaryOut             = NO;
        }
    }
    else if (CGRectContainsPoint(CGRectMake(0, 0, self.minimumImageViewSize.width, self.minimumImageViewSize.height), movePoint)==false)
    {
        self.boundaryOut = YES;
    }
    
    //////////////////////////////////////////////////
    // 方框縮放
    
    if (self.boundaryOut==NO)
    {
        CGRect rectFrame      = self.rectSelected;
        rectFrame.size.width  = movePoint.x-rectFrame.origin.x;
        rectFrame.size.height = movePoint.y-rectFrame.origin.y;
        
        //////////////////////////////////////////////////
        // 定義最小區域的寬 和 最大區域的寬
        
        if (0<=rectFrame.size.width && rectFrame.size.width<PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize)
        {
            rectFrame.size.width = PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
        }
        else if (-PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize<rectFrame.size.width && rectFrame.size.width<0)
        {
            rectFrame.size.width = -PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
        }
        
        if (rectFrame.origin.x+rectFrame.size.width<0)
        {
            rectFrame.size.width = -rectFrame.origin.x;
            
            if (-PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize<rectFrame.size.width)
            {
                rectFrame.size.width = -PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
                rectFrame.origin.x   = -rectFrame.size.width;
            }
        }
        else if (rectFrame.origin.x+rectFrame.size.width>self.minimumImageViewSize.width)
        {
            rectFrame.size.width = self.minimumImageViewSize.width-rectFrame.origin.x;
            
            if (rectFrame.size.width<PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize)
            {
                rectFrame.size.width = PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
                rectFrame.origin.x   = self.minimumImageViewSize.width-rectFrame.size.width;
            }
        }
        
        //////////////////////////////////////////////////
        // 定義最小區域的高 和 最大區域的高
        
        if (0<=rectFrame.size.height && rectFrame.size.height<PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize)
        {
            rectFrame.size.height = PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
        }
        else if (-PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize<rectFrame.size.height && rectFrame.size.height<0)
        {
            rectFrame.size.height = -PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
        }
        
        if (rectFrame.origin.y+rectFrame.size.height<0)
        {
            rectFrame.size.height = -rectFrame.origin.y;
            
            if (-PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize<rectFrame.size.height)
            {
                rectFrame.size.height = -PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
                rectFrame.origin.y    = -rectFrame.size.height;
            }
        }
        else if (rectFrame.origin.y+rectFrame.size.height>self.minimumImageViewSize.height)
        {
            rectFrame.size.height = self.minimumImageViewSize.height-rectFrame.origin.y;
            
            if (rectFrame.size.height<PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize)
            {
                rectFrame.size.height = PPClipBusinessCardSelectRectangleImageScrollViewMinimumRectangleSize;
                rectFrame.origin.y   = self.minimumImageViewSize.height-rectFrame.size.height;
            }
        }
        
        self.rectSelected = rectFrame;
    }
}


//================================================================================
// 利用畫部的移動量來設定畫布顯示區域
//================================================================================
- (void)scrollViewByMovement
{
    if (CGPointEqualToPoint(self.scrollDirection, CGPointZero)==false)
    {
        CGRect clipRect         = self.bounds;
        CGRect convertClipRect  = [self convertRect:clipRect toView:self.imageView];
        
        //////////////////////////////////////////////////
        // 定義顯示畫面在MinimumImageview的大小與位置
        
        if (convertClipRect.origin.x<0)
        {
            convertClipRect.origin.x = 0;
        }
        
        if (convertClipRect.size.width>self.imageView.bounds.size.width)
        {
            convertClipRect.size.width = self.imageView.bounds.size.width;
        }
        
        if (convertClipRect.origin.y<0)
        {
            convertClipRect.origin.y = 0;
        }
        
        if (convertClipRect.size.height>self.imageView.bounds.size.height)
        {
            convertClipRect.size.height = self.imageView.bounds.size.height;
        }
        
        //////////////////////////////////////////////////
        // 當顯示畫面矩形與選擇區域矩形相交,則自動滾動
        
        CGRect standardRectSelected = CGRectStandardize(self.rectSelected);
        
        if ((CGRectContainsRect(convertClipRect, standardRectSelected)==false))
        {
            CGRect imageShowRegion   = [self.imageView convertRect:convertClipRect toView:self];
            CGRect imageSelectRegion = [self.imageView convertRect:standardRectSelected toView:self];
            
            if ((imageSelectRegion.origin.x<imageShowRegion.origin.x) && (self.scrollDirection.x<0))
            {
                clipRect.origin.x = clipRect.origin.x+imageSelectRegion.origin.x-imageShowRegion.origin.x;
            }
            else if ((standardRectSelected.origin.x+standardRectSelected.size.width>convertClipRect.origin.x+convertClipRect.size.width) && (self.scrollDirection.x>0))
            {
                clipRect.origin.x = clipRect.origin.x+standardRectSelected.origin.x+standardRectSelected.size.width-convertClipRect.origin.x-convertClipRect.size.width;
            }
            
            if ((imageSelectRegion.origin.y<imageShowRegion.origin.y) && (self.scrollDirection.y<0))
            {
                clipRect.origin.y = clipRect.origin.y+imageSelectRegion.origin.y-imageShowRegion.origin.y;
            }
            else if ((standardRectSelected.origin.y+standardRectSelected.size.height>convertClipRect.origin.y+convertClipRect.size.height) && (self.scrollDirection.y>0))
            {
                clipRect.origin.y = clipRect.origin.y+standardRectSelected.origin.y+standardRectSelected.size.height-convertClipRect.origin.y-convertClipRect.size.height;
            }
            
            self.bounds = clipRect;
            
            //////////////////////////////////////////////////
            // 變更self.rectSelected位置,使得不需再移動即可連續scroll
            
            standardRectSelected.origin.x = standardRectSelected.origin.x+self.scrollDirection.x;
            standardRectSelected.origin.y = standardRectSelected.origin.y+self.scrollDirection.y;
            
            if (standardRectSelected.origin.x<0)
            {
                standardRectSelected.origin.x = 0;
            }
            else if (standardRectSelected.origin.x+standardRectSelected.size.width>self.minimumImageViewSize.width)
            {
                standardRectSelected.origin.x = standardRectSelected.origin.x+self.minimumImageViewSize.width-standardRectSelected.origin.x-standardRectSelected.size.width;
            }
            
            if (standardRectSelected.origin.y<0)
            {
                standardRectSelected.origin.y = 0;
            }
            else if (standardRectSelected.origin.y+standardRectSelected.size.height>self.minimumImageViewSize.height)
            {
                standardRectSelected.origin.y = standardRectSelected.origin.y+self.minimumImageViewSize.height-standardRectSelected.origin.y-standardRectSelected.size.height;
            }
            
            self.rectSelected = standardRectSelected;
        }
    }
}

@end
