//
//  PPClipBusinessCardViewController.m
//
//
//  Created by Andrewlia on 13/12/25.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import "UIViewController+ShareApplication.h"
#import "PPClipBusinessCardViewController.h"

// Define
#import "PPClipBusinessCardViewControllerPrivateParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPClipBusinessCardViewController()

@interface PPClipBusinessCardViewController ()
@property (nonatomic,retain) NSOperationQueue                                 *operationQueue;
@property (nonatomic,retain) PPBusyView                                       *ppBusyView;
@property (nonatomic,retain) PPButton                                         *ppButtonLeft;
@property (nonatomic,retain) PPButton                                         *ppButtonRight;
@property (nonatomic,retain) PPButton                                         *ppButtonLanguage;
@property (nonatomic,retain) PPButton                                         *ppButtonChange;
@property (nonatomic,retain) PPClipBusinessCardDrawSelectRectangleView        *ppClipBusinessCardDrawSelectRectangleView;
@property (nonatomic,retain) PPClipBusinessCardSelectRectangleImageScrollView *ppClipBusinessCardSelectRectangleImageScrollView;
@property (nonatomic,retain) PPNavigationBarView                              *ppNavigationBarView;
@property (nonatomic,retain) PPBarView                                        *ppBottomBarView;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPClipBusinessCardViewController

@implementation PPClipBusinessCardViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
// 初始化參數
//================================================================================
- (id)init
{
	if((self = [super init]))
	{
        _operationQueue                        = [[NSOperationQueue alloc] init];
        
        _maximumZoomScale                      = PPClipBusinessCardViewControllerDefaultMaximumZoomScale;
        _ppClipBusinessCardViewControllerStyle = PPClipBusinessCardViewControllerStyle_BusinessCard;
        _recognitionButtonTitle                = @"English";
        _bottomBarHeight                       = PPClipBusinessCardViewControllerDefaultBottomBarHeight;

        //////////////////////////////////////////////////
        
        _clipImageSide = PPClipBusinessCardViewControllerClipImageSide_FrontCard;
        
        //////////////////////////////////////////////////

        _defaultNavigationBarStyle = PPBarViewStyle_CenteredRelative;
        
        self.view.backgroundColor = [UIColor blackColor];
	}
	
	return self;
}


//================================================================================
// 釋放物件的處理(釋放.h檔裡所宣告的物件)
//================================================================================
- (void)dealloc
{
    [_frontCardImage release];
    _frontCardImage = nil;
    
    [_rearCardImage release];
    _rearCardImage = nil;
    
    [_clipImage release];
    _clipImage = nil;
    
    [_operationQueue cancelAllOperations]; //已執行的處理不會中斷
    [_operationQueue release];
    _operationQueue = nil;
    
    [_bottomToolBarButtonBackgroundColorNormal release];
    _bottomToolBarButtonBackgroundColorNormal = nil;
    
    [_bottomToolBarButtonBackgroundColorHighlighted release];
    _bottomToolBarButtonBackgroundColorHighlighted = nil;
    
    self.bottomToolBarLanguageTextColorHighlighted = nil;
    self.bottomToolBarLanguageTextColorNormal = nil;
    self.contentBackgroundColor = nil;
    self.navigationBarButtonBackgroundColorHighlighted = nil;
    self.navigationBarTitle = nil;
    self.recognitionButtonTitle = nil;
    
    //////////////////////////////////////////////////
    [self.ppBusyView removeFromSuperview];
    self.ppBusyView = nil;

    [self.ppButtonLanguage removeFromSuperview];
    self.ppButtonLanguage = nil;
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppBottomBarView removeFromSuperview];
    self.ppBottomBarView = nil;
    
    [self.ppButtonRight removeFromSuperview];
    self.ppButtonRight = nil;
    
    [self.ppButtonLeft removeFromSuperview];
    self.ppButtonLeft = nil;
    
    [self.ppButtonChange removeFromSuperview];
    self.ppButtonChange = nil;
    
    [self.ppClipBusinessCardDrawSelectRectangleView removeFromSuperview];
    self.ppClipBusinessCardDrawSelectRectangleView = nil;
    
    [self.ppClipBusinessCardSelectRectangleImageScrollView removeFromSuperview];
    self.ppClipBusinessCardSelectRectangleImageScrollView = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
// View要呈現前即被呼叫
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    // !!判斷是否有使用navigationController呼叫
    
    if (self.navigationController!=nil)
    {
        // 中間的ImageScrollView
        PPClipBusinessCardSelectRectangleImageScrollView *ppClipBusinessCardSelectRectangleImageScrollView = [[PPClipBusinessCardSelectRectangleImageScrollView alloc] init];
        if (ppClipBusinessCardSelectRectangleImageScrollView!=nil)
        {
            ppClipBusinessCardSelectRectangleImageScrollView.alwaysBounceHorizontal = YES;
            ppClipBusinessCardSelectRectangleImageScrollView.alwaysBounceVertical   = YES;
            ppClipBusinessCardSelectRectangleImageScrollView.delaysContentTouches   = NO;
            ppClipBusinessCardSelectRectangleImageScrollView.selectRectDelegate     = self;
            ppClipBusinessCardSelectRectangleImageScrollView.backgroundColor        = self.contentBackgroundColor;
            ppClipBusinessCardSelectRectangleImageScrollView.imageMode              = PPImageScrollViewImageMode_ScaleAspectFit;
            
            [self.view addSubview:ppClipBusinessCardSelectRectangleImageScrollView];
            
            self.ppClipBusinessCardSelectRectangleImageScrollView = ppClipBusinessCardSelectRectangleImageScrollView;
            [ppClipBusinessCardSelectRectangleImageScrollView release];
        }
        
        //////////////////////////////////////////////////
        // 選擇區域的畫布
        
        PPClipBusinessCardDrawSelectRectangleView *ppClipBusinessCardDrawSelectRectangleView = [[PPClipBusinessCardDrawSelectRectangleView alloc] init];
        if (ppClipBusinessCardDrawSelectRectangleView!=nil)
        {
            ppClipBusinessCardDrawSelectRectangleView.backgroundColor = [UIColor clearColor];
            [self.view addSubview:ppClipBusinessCardDrawSelectRectangleView];
            
            self.ppClipBusinessCardDrawSelectRectangleView = ppClipBusinessCardDrawSelectRectangleView;
            [ppClipBusinessCardDrawSelectRectangleView release];
        }
        
        //////////////////////////////////////////////////
        // 上方的Navigation Bar
        
        _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
        if (self.ppNavigationBarView!=nil)
        {
            self.ppNavigationBarView.style                     = self.defaultNavigationBarStyle;
            self.ppNavigationBarView.titleLabel.text           = self.navigationBarTitle;
            
            NSMutableArray *viewItemArray = [NSMutableArray array];
            
            //////////////////////////////////////////////////
            
            _ppButtonLeft = [[PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                                      tag:PPClipBusinessCardViewControllerButtonTag_Back
                                                                 delegate:self
                                                    normalBackgroundColor:nil
                                               highlightedBackgroundColor:self.navigationBarButtonBackgroundColorHighlighted
                                                          imageEdgeInsets:PPClipBusinessCardViewControllerDefaultNavigationBarBottomImageInset] retain];
            if (self.ppButtonLeft!=nil)
            {
                //////////////////////////////////////////////////

                if([[self.ppButtonLeft imageView] image]==nil)
                {
                    [self.ppButtonLeft setTitle:NSLocalizedStringFromTable(@"MLS_Back", NSStringFromClass([self.ppButtonLeft class]), nil) maxWidth:0.0];
                }
                
                //////////////////////////////////////////////////

                PPBarViewItemModel *leftItemModel  = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonLeft];
                
                if (leftItemModel!=nil)
                {
                    if([[self.ppButtonLeft imageView] image]!=nil)
                    {
                        leftItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    }
                    
                    [viewItemArray addObject:leftItemModel];
                }

                //////////////////////////////////////////////////

                [self.ppButtonLeft addControlEvents:UIControlEventTouchUpInside];
                
                //////////////////////////////////////////////////
                
                PPBarViewItemModel *titleItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppNavigationBarView.titleLabel];
                if(titleItemModel!=nil)
                {
                    titleItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                    [viewItemArray addObject:titleItemModel];
                }
                
                [self.ppNavigationBarView setItemModels:viewItemArray forBlockType:PPBarViewBlockType_Left];
            }
            
            //////////////////////////////////////////////////

            if (self.ppClipBusinessCardViewControllerStyle==PPClipBusinessCardViewControllerStyle_BusinessCard)
            {
                _ppButtonRight = [[PPButton ppButtonWithIconImageName:ImageNameForPPClipCardImageViewControllerButtonRecog
                                                                  tag:PPClipBusinessCardViewControllerButtonTag_Done
                                                             delegate:self
                                                normalBackgroundColor:nil
                                           highlightedBackgroundColor:self.navigationBarButtonBackgroundColorHighlighted
                                                      imageEdgeInsets:PPClipBusinessCardViewControllerDefaultNavigationBarBottomImageInset] retain];
                if (self.ppButtonRight!=nil)
                {
                    [self.ppButtonRight addControlEvents:UIControlEventTouchUpInside];
                    
                    PPBarViewItemModel *rightItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonRight];
                    if(rightItemModel!=nil)
                    {
                        rightItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
                        [self.ppNavigationBarView setItemModels:[NSArray arrayWithObject:rightItemModel] forBlockType:PPBarViewBlockType_Right];
                    }
                }
            }
            else
            {
                _ppButtonRight = [[PPButton alloc] init];
                if (self.ppButtonRight!=nil)
                {
                    self.ppButtonRight.delegate  = self;
                    self.ppButtonRight.tag       = PPClipBusinessCardViewControllerButtonTag_Done;
                    
                    [self.ppButtonRight addControlEvents:UIControlEventTouchUpInside];
                    [self.ppButtonRight setTitle:NSLocalizedStringFromTable(@"MLS_AddPhoto", NSStringFromClass([self class]), nil) maxWidth:0];
                    [self.ppNavigationBarView setViews:@[self.ppButtonRight] forBlockType:PPBarViewBlockType_Right];
                }
            }
            
            //////////////////////////////////////////////////
            
            UIBarButtonItem *navigationBarButtons = [[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView];
            if (navigationBarButtons!=nil)
            {
                self.navigationItem.leftBarButtonItem = navigationBarButtons;
                [navigationBarButtons release];
            }
        }
        
        //////////////////////////////////////////////////
        // 下方的Navigation ToolBar
        
        if (self.ppClipBusinessCardViewControllerStyle==PPClipBusinessCardViewControllerStyle_BusinessCard)
        {
            self.ppBottomBarView = [[[PPBarView alloc] init] autorelease];
            
            if(self.ppBottomBarView!=nil)
            {
                if(self.bottomToolBarButtonBackgroundColorNormal!=nil)
                {
                    self.ppBottomBarView.backgroundColor = self.bottomToolBarButtonBackgroundColorNormal;
                }
    
                //////////////////////////////////////////////////

                self.ppBottomBarView.style = PPBarViewStyle_Average;
                
                [self.view addSubview:self.ppBottomBarView];
                
                //////////////////////////////////////////////////

                self.ppButtonLanguage = [[[PPButton alloc] init] autorelease];
                
                if (self.ppButtonLanguage!=nil)
                {
                    self.ppButtonLanguage.delegate = self;
                    self.ppButtonLanguage.tag      = PPClipBusinessCardViewControllerButtonTag_RecognitionLanguage;
                    
                    [self.ppButtonLanguage addControlEvents:UIControlEventTouchUpInside];
                    [self.ppButtonLanguage setTitle:self.recognitionButtonTitle maxWidth:0];
                    [self.ppButtonLanguage setTitleColor:self.bottomToolBarLanguageTextColorNormal forState:UIControlStateNormal];
                    [self.ppButtonLanguage setTitleColor:self.bottomToolBarLanguageTextColorHighlighted forState:UIControlStateHighlighted];

                    if(self.bottomToolBarButtonBackgroundColorHighlighted!=nil)
                    {
                        [self.ppButtonLanguage setBackgroundImage:[UIImage imageWithColor:self.bottomToolBarButtonBackgroundColorHighlighted] forState:UIControlStateHighlighted];
                    }
                }
                
                //////////////////////////////////////////////////
                
                self.ppButtonChange = [PPButton ppButtonWithIconImageName:ImageNameForPPClipCardImageViewControllerButtonChange
                                                                            tag:PPClipBusinessCardViewControllerButtonTag_ChangeSide
                                                                       delegate:self
                                                          normalBackgroundColor:nil
                                                     highlightedBackgroundColor:self.bottomToolBarButtonBackgroundColorHighlighted
                                                               imageEdgeInsets:PPClipBusinessCardViewControllerDefaultToolBarBottomImageInset];
                
                if(self.ppButtonChange!=nil)
                {
                    [self.ppButtonChange addControlEvents:UIControlEventTouchUpInside];
                }

                //////////////////////////////////////////////////
                
                if(self.ppButtonLanguage!=nil &&
                   self.ppButtonChange!=nil)
                {
                    if(self.frontCardImage==nil || self.rearCardImage==nil)
                    {
                        [self.ppBottomBarView setViews:@[self.ppButtonLanguage] forBlockType:PPBarViewBlockType_Center];
                    }
                    else
                    {
                        [self.ppBottomBarView setViews:@[self.ppButtonLanguage] forBlockType:PPBarViewBlockType_Left];
                        [self.ppBottomBarView setViews:@[self.ppButtonChange] forBlockType:PPBarViewBlockType_Right];
                    }
                }
            }
        }
    }
}


//================================================================================
// View要關閉前即被呼叫
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    if (self.ppClipBusinessCardViewControllerStyle==PPClipBusinessCardViewControllerStyle_BusinessCard)
    {
        [self.ppButtonLanguage removeFromSuperview];
        self.ppButtonLanguage = nil;
    }
    
    //////////////////////////////////////////////////
    
    [self.ppNavigationBarView removeFromSuperview];
    self.ppNavigationBarView = nil;
    
    [self.ppButtonRight removeFromSuperview];
    self.ppButtonRight = nil;
    
    [self.ppButtonLeft removeFromSuperview];
    self.ppButtonLeft = nil;
    
    [self.ppButtonChange removeFromSuperview];
    self.ppButtonChange = nil;
    
    [self.ppClipBusinessCardDrawSelectRectangleView removeFromSuperview];
    self.ppClipBusinessCardDrawSelectRectangleView = nil;
    
    [self.ppClipBusinessCardSelectRectangleImageScrollView removeFromSuperview];
    self.ppClipBusinessCardSelectRectangleImageScrollView = nil;

    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Intended For Subclasses Method Override

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    [self renewlayout];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods

//================================================================================
// Language Selector
//================================================================================
- (void)setRecognitionButtonTitle:(NSString *)recognitionButtonTitle
{
    [recognitionButtonTitle retain];
    [_recognitionButtonTitle release];
    _recognitionButtonTitle = recognitionButtonTitle;
    
    if (self.ppButtonLanguage!=nil)
    {
        [self.ppButtonLanguage setTitle:recognitionButtonTitle maxWidth:0];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
// 裁切出要辨識的影像區域
//================================================================================
- (void)clipRectangleSelectedPhoto
{
    self.clipImage = [[self workingImage] imageCroppedByRect:self.sourceImageSelectRect];
}


//================================================================================
// 變更sourceImage的選擇區域
//================================================================================
- (void)editSourceImageSelectRect
{
    CGFloat scale = [self workingImage].size.width/self.ppClipBusinessCardSelectRectangleImageScrollView.frame.size.width;
    
    if (scale<[self workingImage].size.height/self.ppClipBusinessCardSelectRectangleImageScrollView.frame.size.height)
    {
        scale = [self workingImage].size.height/self.ppClipBusinessCardSelectRectangleImageScrollView.frame.size.height;
    }
    
    self.sourceImageSelectRect = CGRectMake(floor(self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected.origin.x*scale),
                                            floor(self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected.origin.y*scale),
                                            ceil(self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected.size.width*scale),
                                            ceil(self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected.size.height*scale));
}


//================================================================================
// Resign RectDrawn
//================================================================================
- (void)resignPPClipBusinessCardDrawSelectRectangleViewRectDrawn
{
    self.ppClipBusinessCardDrawSelectRectangleView.rectDrawn = [self.ppClipBusinessCardSelectRectangleImageScrollView.imageView
                                                                convertRect:self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected
                                                                toView:self.ppClipBusinessCardDrawSelectRectangleView];
}


//================================================================================
//
//================================================================================
- (UIImage *)workingImage
{
    UIImage *workingImage = nil;
    
    if(self.clipImageSide==PPClipBusinessCardViewControllerClipImageSide_FrontCard)
    {
        workingImage = self.frontCardImage;
    }
    else
    {
        workingImage = self.rearCardImage;
    }
    
    return workingImage;
}




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private relayout Method

//================================================================================
//
//================================================================================
- (void)renewlayout
{
    // 7.0版Height包含toolBar,但是其它版不包含
    
    CGRect frame    = [self layoutFrame];
    frame.size.height = frame.size.height-self.bottomBarHeight;
    
    //////////////////////////////////////////////////
    // 中間的ImageScrollView & 並找出主要放大比例的基準邊
    
    self.ppClipBusinessCardSelectRectangleImageScrollView.frame = frame;
    
    if ([self workingImage].size.width/frame.size.width>=[self workingImage].size.height/frame.size.height)
    {
        self.ppClipBusinessCardSelectRectangleImageScrollView.maximumZoomScaleForImageSize = (self.ppClipBusinessCardSelectRectangleImageScrollView.frame.size.width/[self workingImage].size.width)*self.maximumZoomScale;;
    }
    else
    {
        self.ppClipBusinessCardSelectRectangleImageScrollView.maximumZoomScaleForImageSize = (self.ppClipBusinessCardSelectRectangleImageScrollView.frame.size.height/[self workingImage].size.height)*self.maximumZoomScale;
    }
    
    self.ppClipBusinessCardSelectRectangleImageScrollView.doubleTapZoomScale   = self.maximumZoomScale;
    self.ppClipBusinessCardSelectRectangleImageScrollView.image                = [self workingImage];
    self.ppClipBusinessCardSelectRectangleImageScrollView.minimumImageViewSize = self.ppClipBusinessCardSelectRectangleImageScrollView.imageView.frame.size;
    
    //////////////////////////////////////////////////
    
    // 初始化影像選擇區域
    
    if (CGRectEqualToRect(self.sourceImageSelectRect, CGRectZero)==true)
    {
        self.sourceImageSelectRect = CGRectMake([self workingImage].size.width/4, [self workingImage].size.height/4, [self workingImage].size.width/2, [self workingImage].size.height/2);
    }
    
    //////////////////////////////////////////////////
    // 找出imageView選擇區域 與 繪畫的選擇區域
    
    self.ppClipBusinessCardDrawSelectRectangleView.frame = frame;
    
    CGFloat scale            = self.ppClipBusinessCardSelectRectangleImageScrollView.imageView.frame.size.width/[self workingImage].size.width;
    CGRect imageViewClipRect = CGRectMake(floor(self.sourceImageSelectRect.origin.x*scale),
                                          floor(self.sourceImageSelectRect.origin.y*scale),
                                          ceil(self.sourceImageSelectRect.size.width*scale),
                                          ceil(self.sourceImageSelectRect.size.height*scale));
    
    CGRect drawViewClipRect  = [self.ppClipBusinessCardSelectRectangleImageScrollView.imageView convertRect:imageViewClipRect toView:self.ppClipBusinessCardDrawSelectRectangleView];
    
    self.ppClipBusinessCardDrawSelectRectangleView.rectDrawn           = drawViewClipRect;
    self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected = imageViewClipRect;
    
    //////////////////////////////////////////////////
    
    self.ppBottomBarView.frame = CGRectMake(0, frame.origin.y+frame.size.height, frame.size.width, self.bottomBarHeight);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
// 是否顯示等待視窗
//================================================================================
- (void)showBusyView:(BOOL)show superView:(UIView *)superView
{
    if (show==YES)
    {
        if (self.ppBusyView==nil)
        {
            _ppBusyView       = [[PPBusyView alloc] initWithSuperView:superView];
            _ppBusyView.style = PPBusyViewStyle_Border;
        }
    }
    else
    {
        [self.ppBusyView removeFromSuperview];
        self.ppBusyView = nil;
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPClipBusinessCardSelectRectangleImageScrollViewDelegate

//================================================================================
// ppClipBusinessCardSelectRectangleImageScrollView RectMove Events
//================================================================================
- (void)ppClipBusinessCardSelectRectangleImageScrollViewDidRectMove:(PPClipBusinessCardSelectRectangleImageScrollView *)ppClipBusinessCardSelectRectangleImageScrollView
{
    self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_All;
    
    //////////////////////////////////////////////////
    // 重新設定繪畫矩形的區域 和 影像選擇矩形的區域
    
    [self resignPPClipBusinessCardDrawSelectRectangleViewRectDrawn];
    [self editSourceImageSelectRect];
}


//================================================================================
// ppClipBusinessCardSelectRectangleImageScrollView RectResize Events
//================================================================================
- (void)ppClipBusinessCardSelectRectangleImageScrollViewDidRectResize:(PPClipBusinessCardSelectRectangleImageScrollView *)ppClipBusinessCardSelectRectangleImageScrollView
{
    // 利用imageView的寬高來判斷控制的選擇邊

    if (self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected.size.width>=0)
    {
        if (self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected.size.height>=0)
        {
            self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_RightDown;
        }
        else
        {
            self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_RightUp;
        }
    }
    else
    {
        if (self.ppClipBusinessCardSelectRectangleImageScrollView.rectSelected.size.height>=0)
        {
            self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_LeftDown;
        }
        else
        {
            self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_LeftUp;
        }
    }
    
    //////////////////////////////////////////////////
    // 重新設定繪畫矩形的區域 和 影像選擇矩形的區域
    
    [self editSourceImageSelectRect];
    [self resignPPClipBusinessCardDrawSelectRectangleViewRectDrawn];
}


//================================================================================
// ppClipBusinessCardSelectRectangleImageScrollView TouchUp Events
//================================================================================
- (void)ppClipBusinessCardSelectRectangleImageScrollViewDidTouchUp:(PPClipBusinessCardSelectRectangleImageScrollView *)ppClipBusinessCardSelectRectangleImageScrollView
{
    self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_None;
    
    //////////////////////////////////////////////////
    // 設定繪畫矩形的區域
    
    [self resignPPClipBusinessCardDrawSelectRectangleViewRectDrawn];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//================================================================================
// PPButton Events
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    do
    {
        if(self.delegate==nil ||
           [self.delegate respondsToSelector:@selector(ppClipBusinessCardViewController:ppButton:controlEvent:)]==NO)
        {
            break;
        }
    
        //////////////////////////////////////////////////
        
        switch (ppButton.tag)
        {
            case PPClipBusinessCardViewControllerButtonTag_Done:
            {
                [self clipRectangleSelectedPhoto];
                
                
                //////////////////////////////////////////////////
                
                [self.delegate ppClipBusinessCardViewController:self
                                                       ppButton:ppButton
                                                   controlEvent:controlEvent];
                
                break;
            }
            case PPClipBusinessCardViewControllerButtonTag_Back:
            {
                [self.delegate ppClipBusinessCardViewController:self
                                                       ppButton:ppButton
                                                   controlEvent:controlEvent];
                break;
            }
            case PPClipBusinessCardViewControllerButtonTag_ChangeSide:
            {
                if(_clipImageSide==PPClipBusinessCardViewControllerClipImageSide_FrontCard)
                {
                    _clipImageSide = PPClipBusinessCardViewControllerClipImageSide_RearCard;
                    
                    self.ppClipBusinessCardSelectRectangleImageScrollView.image = self.rearCardImage;
                }
                else
                {
                    _clipImageSide = PPClipBusinessCardViewControllerClipImageSide_FrontCard;
                    
                    self.ppClipBusinessCardSelectRectangleImageScrollView.image = self.frontCardImage;
                }
                
                //////////////////////////////////////////////////

                [self.delegate ppClipBusinessCardViewController:self
                                                       ppButton:ppButton
                                                   controlEvent:controlEvent];
                
                //////////////////////////////////////////////////

                self.sourceImageSelectRect = CGRectZero;
                
                [self renewlayout];
                
                break;
            }
            case PPClipBusinessCardViewControllerButtonTag_RecognitionLanguage:
            {
                [self.delegate ppClipBusinessCardViewController:self
                                                       ppButton:ppButton
                                                   controlEvent:controlEvent];
                
                break;
            }
            default:
            {
                break;
            }
        }
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UIScrollViewDelegate

//================================================================================
// 影像滾動事件
//================================================================================
- (void)scrollViewDidScroll:(UIScrollView *)scrollView
{
    self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_None;
    
    //////////////////////////////////////////////////
    // 設定繪畫矩形的區域
    
    [self resignPPClipBusinessCardDrawSelectRectangleViewRectDrawn];
}


//================================================================================
// 影像縮放事件
//================================================================================
- (void)scrollViewDidZoom:(UIScrollView *)scrollView
{
    self.ppClipBusinessCardDrawSelectRectangleView.ppClipBusinessCardDrawSelectRectangleViewColor = PPClipBusinessCardDrawSelectRectangleViewColor_None;
    
    //////////////////////////////////////////////////
    // 設定繪畫矩形的區域
    
    [self resignPPClipBusinessCardDrawSelectRectangleViewRectDrawn];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Rotation Events

//================================================================================
//
//================================================================================
- (void)willAnimateRotationToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
    [super willAnimateRotationToInterfaceOrientation:toInterfaceOrientation duration:duration];
    
    //////////////////////////////////////////////////

    if([self.delegate respondsToSelector:@selector(ppClipBusinessCardViewController:willAnimateRotationToInterfaceOrientation:)]==YES)
    {
        [self.delegate ppClipBusinessCardViewController:self
              willAnimateRotationToInterfaceOrientation:toInterfaceOrientation];
    }
}


//===============================================================================
//
//===============================================================================
- (void)willRotateToInterfaceOrientation:(UIInterfaceOrientation)toInterfaceOrientation duration:(NSTimeInterval)duration
{
    [super willRotateToInterfaceOrientation:toInterfaceOrientation duration:duration];
    
    //////////////////////////////////////////////////
    
    if([self.delegate respondsToSelector:@selector(ppClipBusinessCardViewController:rotateToInterfaceOrientation:)]==YES)
    {
        [self.delegate ppClipBusinessCardViewController:self
                           rotateToInterfaceOrientation:toInterfaceOrientation];
    }
}

@end
