//
//  PPCheckBoxView.h
//  
//
//  Created by Mike on 13/5/21.
//  Modify by Andrew on 15/4/24.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "UIImage+Additions.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

typedef NS_ENUM(NSInteger, PPCheckBoxViewStatus)
{
    PPCheckBoxViewStatus_None = 0,
    PPCheckBoxViewStatus_Select,
    PPCheckBoxViewStatus_Unselect
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Resource

extern NSString *DefaultImageNameForPPCheckBoxViewSelected;
extern NSString *DefaultImageNameForPPCheckBoxViewUnselected;

////////////////////////////////////////////////////////////////////////////////////////////////////

#define PPCheckBoxViewDefaultGap	    5
#define PPCheckBoxViewDefaultImageSize  CGSizeMake(30, 30)

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCheckBoxView Interface

@interface PPCheckBoxView : UIView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic, assign) PPCheckBoxViewStatus status;
@property (nonatomic, assign) UIEdgeInsets imageEdgeInsets;
@property (nonatomic, retain) UIImage *checkBoxImageSelected;
@property (nonatomic, retain) UIImage *checkBoxImageUnSelected;

@end
