//
//  CardImageBottomBarView.m
//  
//
//  Created by Howard.Lin on 13/12/25.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "CardImageBottomBarView.h"

// Define
#import "PPCardImageViewController+ResourceDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation CardImageBottomBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
    self = [super initWithFrame:frame];
    
    if (self)
    {
        // Initialization code
        self.style = PPBarViewStyle_Average;
        
        self.backgroundColor = [UIColor clearColor];

        //////////////////////////////////////////////////
        
        _moreButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_moreButton!=nil)
        {
            _moreButton.delegate = self;
            _moreButton.tag      = CardImageBottomBarViewButtonTag_More;
            
            [_moreButton addControlEvents:UIControlEventTouchUpInside];
            [_moreButton setImageWithName:ImageNameForCardImageBottomBarViewEditImage];
        }
        
        //////////////////////////////////////////////////

        _replaceImageButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_replaceImageButton!=nil)
        {
            _replaceImageButton.delegate = self;
            _replaceImageButton.tag      = CardImageBottomBarViewButtonTag_Replace;
            
            [_replaceImageButton addControlEvents:UIControlEventTouchUpInside];
            [_replaceImageButton setImageWithName:ImageNameForCardBottomBarViewButtonReplace];
        }

        
        //////////////////////////////////////////////////
        
        _rotateLeftButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_rotateLeftButton!=nil)
        {
            _rotateLeftButton.delegate = self;
            _rotateLeftButton.tag      = CardImageBottomBarViewButtonTag_RotateLeft;
            
            [_rotateLeftButton addControlEvents:UIControlEventTouchUpInside];
            [_rotateLeftButton setImageWithName:ImageNameForCardImageBottomBarViewRotateLeftImage];
        }
        
        //////////////////////////////////////////////////
        
        _rotateRightButton = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if(_rotateRightButton!=nil)
        {
            _rotateRightButton.delegate = self;
            _rotateRightButton.tag      = CardImageBottomBarViewButtonTag_RotateRight;
            
            [_rotateRightButton addControlEvents:UIControlEventTouchUpInside];
            [_rotateRightButton setImageWithName:ImageNameForCardImageBottomBarViewRotateRightImage];
        }
        
        //////////////////////////////////////////////////
        
        if(_rotateLeftButton!=nil &&
           _rotateRightButton!=nil &&
           _replaceImageButton!=nil &&
           _moreButton!=nil)
        {
            PPBarViewItemModel *rotateLeftItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_rotateLeftButton];
            
            if(rotateLeftItemModel!=nil)
            {
                rotateLeftItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *rotateRightItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_rotateRightButton];
            
            if(rotateRightItemModel!=nil)
            {
                rotateRightItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *replaceImageButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_replaceImageButton];
            
            if(replaceImageButtonItemModel!=nil)
            {
                replaceImageButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////
            
            PPBarViewItemModel *moreButtonItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:_moreButton];
            
            if(moreButtonItemModel!=nil)
            {
                moreButtonItemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            }
            
            //////////////////////////////////////////////////

            if(rotateLeftItemModel!=nil &&
               rotateRightItemModel!=nil &&
               replaceImageButtonItemModel!=nil &&
               moreButtonItemModel!=nil)
            {
                [self setItemModels:@[rotateLeftItemModel,rotateRightItemModel,replaceImageButtonItemModel,moreButtonItemModel]
                       forBlockType:PPBarViewBlockType_Center];
            }
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_moreButton removeFromSuperview];
    [_moreButton release];
    _moreButton = nil;
    
    [_replaceImageButton removeFromSuperview];
    [_replaceImageButton release];
    _replaceImageButton = nil;
    
    [_rotateRightButton removeFromSuperview];
    [_rotateRightButton release];
    _rotateRightButton = nil;
    
    [_rotateLeftButton removeFromSuperview];
    [_rotateLeftButton release];
    _rotateLeftButton = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    if([self.delegate respondsToSelector:@selector(cardImageBottomBarView:ppButton:controlEvent:)]==YES)
    {
        [self.delegate cardImageBottomBarView:self
                                     ppButton:ppButton
                                 controlEvent:controlEvent];
    }
}

@end
