//
//  UIImage+MTLTexture.m
//  Metal_Sample
//
//  Created by sanhue on 2020/3/26.
//  Copyright © 2020 penpower. All rights reserved.
//

#import "UIImage+MTLTexture.h"

//#import <AppKit/AppKit.h>
#import <UIKit/UIKit.h>

@implementation UIImage (MTLTexture)

+ (UIImage *)imageFromTexture:(id<MTLTexture>)texture isRGBA:(BOOL)isRGBA
{
    if (texture.width==0||
        texture.height==0)
    {
        return nil;
    }
    
    NSInteger bytesPerPixel = 4;
    NSInteger bitsPerComponent = 8;
    NSInteger imageByteCount = texture.width * texture.height * bytesPerPixel;
    NSInteger bytesPerRow = texture.width * bytesPerPixel;

    Byte *pImage = malloc(imageByteCount);
    
    if(pImage == nil)
    {
        return nil;
    }

    MTLRegion region = MTLRegionMake2D(0, 0, texture.width, texture.height);
    [texture getBytes:pImage bytesPerRow:bytesPerRow fromRegion:region mipmapLevel:0];

    //////////////////////////////////////////////////
    // 產生一般RGB，deviceRGB會是sRGB
    // 為了與android結果比對，所以要另外設定
    CGColorSpaceRef colorSpace = CGColorSpaceCreateDeviceRGB();//CGColorSpaceCreateWithName(kCGColorSpaceGenericRGBLinear);//
    
    CGBitmapInfo bitmapInfo = 0;
    
    if(isRGBA)
    {
        // RGBA
        bitmapInfo = kCGBitmapByteOrder32Big | kCGImageAlphaPremultipliedLast;
    }
    else
    {
        // BRGA
        bitmapInfo = kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst;
    }

    CGContextRef context = CGBitmapContextCreate(pImage,
                                                 texture.width,
                                                 texture.height,
                                                 bitsPerComponent,
                                                 bytesPerRow,
                                                 colorSpace,
                                                 bitmapInfo);

    CGImageRef cgimage = CGBitmapContextCreateImage(context);
    UIImage *image = [UIImage imageWithCGImage:cgimage];

    CGContextRelease(context);
    CGColorSpaceRelease(colorSpace);
    CGImageRelease(cgimage);
    free(pImage);

    return image;
}


//==============================================================================
//
//==============================================================================
- (NSData *)bgraData
{
    CGImageRef imageRef = self.CGImage;
    
    NSUInteger iWidth = CGImageGetWidth(imageRef);
    NSUInteger iHeight = CGImageGetHeight(imageRef);
    NSUInteger iBytesPerPixel = 4;
    NSUInteger iBytesPerRow = iBytesPerPixel * iWidth;
    NSUInteger iBitsPerComponent = 8;
    unsigned char *imageBytes = malloc(iWidth * iHeight * iBytesPerPixel);
    
    CGColorSpaceRef colorspace = CGColorSpaceCreateDeviceRGB();
    
    CGContextRef context = CGBitmapContextCreate(imageBytes,
                                                 iWidth,
                                                 iHeight,
                                                 iBitsPerComponent,
                                                 iBytesPerRow,
                                                 colorspace,
                                                 kCGBitmapByteOrder32Little | kCGImageAlphaPremultipliedFirst); // 转 BGRA 格式
    
    CGRect rect = CGRectMake(0, 0, iWidth, iHeight);
    CGContextDrawImage(context, rect, imageRef);
    
    CGImageRef resultImageRef = CGBitmapContextCreateImage(context);
    
    UIImage *result = [UIImage imageWithCGImage:resultImageRef];
    NSData *imageData = UIImagePNGRepresentation(result);
    CGImageRelease(resultImageRef);
    
    CGColorSpaceRelease(colorspace);
    CGContextRelease(context);
    free(imageBytes);
    
    return imageData;
}
@end
