//
//  PPButtonFactory.m
//  <#project name#>
//
//  Created by Egg on <#date#>.
//  Copyright (c) <#year#>年 <#company#>. All rights reserved.

// Controller
#import "PPButton+Factory.h"





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPButton(Factory)

@implementation PPButton(Factory)





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Pubilc Class Method

//================================================================================
//
//================================================================================
+ (PPButton *)ppButtonWithFrame:(CGRect)frame
                  IconImageName:(NSString *)iconImageName
                       delegate:(id<PPButtonDelegate>)delegate
                            tag:(NSInteger)tag
                backgroundColor:(UIColor *)backgroundColor
{
    
    PPButton *button = nil;
    
    do
    {
        button = [[PPButton alloc] init];
        
        if (button == nil)
        {
            break;
        }
        
        button.delegate = delegate;
        button.tag           = tag;
        button.backgroundColor = backgroundColor;
        button.frame = frame;
        
        [button addControlEvents:UIControlEventTouchUpInside];
        
        [button setImageWithName:iconImageName];
        
        [button autorelease];
    }
    while (NO);
    
    return button;

}


//================================================================================
//
//================================================================================
+ (PPButton *)ppButtonWithImageFrame:(CGRect)imageFrame
                       IconImageName:(NSString *)iconImageName
                            delegate:(id<PPButtonDelegate>)delegate
                                 tag:(NSInteger)tag
                     backgroundColor:(UIColor *)backgroundColor
                               title:(NSString *)title
                          titleColor:(UIColor *)titleColor
                           titleFont:(UIFont *)titleFont
                             spacing:(CGFloat)spacing
{
    
    PPButton *button = nil;
    
    do
    {
        button = [[PPButton alloc] init];
        
        [button setImageWithName:iconImageName];
       
        button.delegate = delegate;
        button.tag           = tag;
        button.backgroundColor = backgroundColor;
        
        if(@available(iOS 13, *))
        {
            //////////////////////////////////////////////////
            // lower the text and push it left so it appears centered
            // below the image
            
            [button setTitle:title forState:UIControlStateNormal];
            button.titleLabel.adjustsFontSizeToFitWidth = NO;
            button.titleLabel.numberOfLines = 1;
            button.titleLabel.lineBreakMode = kCTLineBreakByClipping;
            //////////////////////////////////////////////////
            // 先設一次，讓button.titleLabel.frame在ios8上面有值 (已失效)
            //        button.frame = frame;
            // 2015/05/19:在iOS8.3上這點已失效，因為button的setFrame變成不會去動titleLabel
            // 所以需要自己手動sizeToFit
            
            [button.titleLabel sizeToFit];
            
            CGRect frame = imageFrame;

            frame.size.height += button.titleLabel.frame.size.height + spacing ;

            ////////////////////////////////////////////////
            // 再設定button frame.
            button.frame = frame;

            CGSize imageSize = button.imageView.frame.size;
            CGSize titleSize = button.titleLabel.frame.size;
            CGFloat totalHeight = button.frame.size.height;

            button.imageEdgeInsets = UIEdgeInsetsMake(0.0,
                                                    0.0f,
                                                    0.0f,
                                                    - titleSize.width);

            button.titleEdgeInsets = UIEdgeInsetsMake(0.0f,
                                                    - imageSize.width,
                                                    - (totalHeight - titleSize.height - spacing),
                                                    0.0f);

            button.contentEdgeInsets = UIEdgeInsetsMake(0.0f,
                                                      0.0f,
                                                      titleSize.height,
                                                      0.0f);
        }
        else
        {
            //////////////////////////////////////////////////
            // lower the text and push it left so it appears centered
            // below the image
            CGSize imageSize = imageFrame.size;
            
            [button setTitle:title forState:UIControlStateNormal];
            button.titleLabel.adjustsFontSizeToFitWidth = NO;
            button.titleLabel.numberOfLines = 1;
            button.titleLabel.lineBreakMode = kCTLineBreakByClipping;
            button.titleEdgeInsets = UIEdgeInsetsMake(0.0f,
                                                      -button.frame.size.width,
                                                      -(imageSize.height + spacing),
                                                      0.0f);
            
            //////////////////////////////////////////////////
            // 先設一次，讓button.titleLabel.frame在ios8上面有值 (已失效)
            //        button.frame = frame;
            // 2015/05/19:在iOS8.3上這點已失效，因為button的setFrame變成不會去動titleLabel
            // 所以需要自己手動sizeToFit
            
            [button.titleLabel sizeToFit];
            
            CGRect frame = imageFrame;
            
            frame.size.height += button.titleLabel.frame.size.height + spacing ;
            
            //////////////////////////////////////////////////
            // 再設定button frame.
            button.frame = frame;
        }


        [button addControlEvents:UIControlEventTouchUpInside];
        
        if (titleColor != nil)
        {
            [button setTitleColor:titleColor];
        }
        
        
        if (titleFont != nil)
        {
            button.titleLabel.font = titleFont;
        }
        
        [button autorelease];
    }
    while (NO);
    
    return button;
    
}


//================================================================================
//
//================================================================================
+ (PPButton *)ppButtonWithFrame:(CGRect)frame
                  IconImageName:(NSString *)iconImageName
            backgroundImageName:(NSString *)backgroundImageName
                backgroundColor:(UIColor *)backgroundColor
                    borderColor:(UIColor *)borderColor
                       delegate:(id<PPButtonDelegate>)delegate
                            tag:(NSInteger)tag
                          title:(NSString *)title
{
    
    PPButton *button = nil;
    
    do
    {
        button = [self ppButtonWithFrame:frame
                           IconImageName:iconImageName
                                delegate:delegate
                                     tag:tag
                         backgroundColor:backgroundColor];
        
        if (button == nil)
        {
            break;
        }

        button.layer.borderColor = borderColor.CGColor;
        
        [button setBackgroundImageWithName:backgroundImageName];
        
        [button setTitleText:title];
        
    }
    while (NO);
    
    return button;
    
}


//==============================================================================
//
//==============================================================================
+ (PPButton *)ppButtonWithIconImageName:(NSString *)iconImageName
                                    tag:(NSInteger)tag
                               delegate:(id<PPButtonDelegate>)delegate
                  normalBackgroundColor:(UIColor *)normalBackgroundColor
             highlightedBackgroundColor:(UIColor *)highlightedBackgroundColor
                        imageEdgeInsets:(UIEdgeInsets)imageEdgeInsets
{
    PPButton *ppButton = [PPButton ppButtonWithFrame:UIButtonAdditions_DefaultRect
                                       IconImageName:iconImageName
                                            delegate:delegate
                                                 tag:tag
                                     backgroundColor:nil];
    
    //////////////////////////////////////////////////
    
    if(ppButton!=nil)
    {
        if(normalBackgroundColor!=nil)
        {
            [ppButton setBackgroundImage:[UIImage imageWithColor:normalBackgroundColor] forState:UIControlStateNormal];
        }
        
        //////////////////////////////////////////////////
        
        if(highlightedBackgroundColor!=nil)
        {
            [ppButton setBackgroundImage:[UIImage imageWithColor:highlightedBackgroundColor] forState:UIControlStateHighlighted];
        }
        
        //////////////////////////////////////////////////
        
        [ppButton setImageEdgeInsets:imageEdgeInsets];
    }
    
    return ppButton;
}


//================================================================================
//
//================================================================================
+ (PPButton *)ppButtonWithSystemBackImitation
{
    return [PPButton ppButtonWithFrame:UIButtonAdditions_SmallRect
                         IconImageName:ImageNamePPButtonIconForSystemBackImitation
                              delegate:nil
                                   tag:0
                       backgroundColor:[UIColor clearColor]];
}



//==============================================================================
//
//==============================================================================
+ (PPButton *)ppButtonWithLayoutType:(PPButtonLayoutType)layoutType
                       iconImageName:(NSString *)iconImageName
                                 tag:(NSInteger)tag
                            delegate:(id<PPButtonDelegate>)delegate
                               title:(NSString *)title
                          titleColor:(UIColor *)titleColor
                           titleFont:(UIFont *)titleFont
{
    PPButton *button = nil;
    
    do
    {
        button = [[PPButton alloc] initWithFrame:UIButtonAdditions_DefaultRect];
        
        if (button == nil)
        {
            break;
        }
        
        button.delegate     = delegate;
        button.tag          = tag;
        button.layoutType   = layoutType;

        [button addControlEvents:UIControlEventTouchUpInside];
        
        [button setImageWithName:iconImageName];
        [button setTitleText:title];

        if (titleColor != nil)
        {
            [button setTitleColor:titleColor];
        }
        
        
        if (titleFont != nil)
        {
            button.titleLabel.font = titleFont;
        }
        
        [button autorelease];
    }
    while (NO);
    
    return button;
}

@end
