//
//  PPCancelBusyView.m
//  
//
//  Created by Howard.Lin on 2014/6/28.
//  Copyright (c) 2014年 Penpower. All rights reserved.
//

#import "PPCancelBusyView.h"
#import "UIView+Appearance.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static float const PPCancelBusyViewButtonBorder       = 1.0f;
static float const PPCancelBusyViewButtonCornerRadius = 5.0f;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPCancelBusyView()

@interface PPCancelBusyView()




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property

@property (nonatomic,retain,readonly) PPButton  *ppButtonCancel;

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPCancelBusyview

@implementation PPCancelBusyView





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)initWithSuperView:(UIView *)superView
{
    if(self = [super initWithSuperView:superView])
    {
        _showCancelButton = YES;
        
        //////////////////////////////////////////////////
        
        _ppButtonCancel = [[PPButton alloc] initWithFrame:UIButtonAdditions_MediumRect];
        
        if(self.ppButtonCancel!=nil)
        {
            self.ppButtonCancel.delegate    = self;
            self.ppButtonCancel.tag         = PPCancelBusyViewButtonTag_Cancel;
            
            [self.ppButtonCancel addControlEvents:UIControlEventTouchUpInside];
            [self.ppButtonCancel setBackgroundImageWithName:ImageNamePPButtonBackgroundForNavigationBar];
            [self.ppButtonCancel setTitle:NSLocalizedString(@"MLS_Cancel", nil) maxWidth:UIButtonAdditions_DefaultMaxWidth];
            
            [self.ppButtonCancel setBorderColor:self.messageLabel.textColor];
            [self.ppButtonCancel setBorderWidth:PPCancelBusyViewButtonBorder];
            [self.ppButtonCancel setCornerRadius:PPCancelBusyViewButtonCornerRadius];
            [self addSubview:self.ppButtonCancel];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    
    [_ppButtonCancel removeControlEvents:UIControlEventAllEvents];
    [_ppButtonCancel removeFromSuperview];
    [_ppButtonCancel release];
    _ppButtonCancel = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
	
    //////////////////////////////////////////////////
    
    if(self.showCancelButton==YES)
    {
        CGRect borderFrame = CGRectZero;
        
        
        if([self.messageLabel.text length]==0)
        {
            borderFrame.size.height = self.activityIndicatorView.frame.size.height+ self.ppButtonCancel.frame.size.height + PPBuysViewDefaultBorderPadding*2;
            borderFrame.size.width  = borderFrame.size.height;
        }
        else
        {
            borderFrame.size.height = self.activityIndicatorView.frame.size.height+PPBusyViewDefaultGap+self.messageLabel.frame.size.height+self.ppButtonCancel.frame.size.height+PPBusyViewDefaultGap+PPBuysViewDefaultBorderPadding*2;
            borderFrame.size.width  = MAX(self.ppButtonCancel.frame.size.width,MAX(self.messageLabel.frame.size.width,self.activityIndicatorView.frame.size.width))+PPBuysViewDefaultBorderPadding*2;
        }
        
        borderFrame.origin.x = (self.bounds.size.width-self.borderFrame.size.width)/2;
        borderFrame.origin.y = (self.bounds.size.height-self.borderFrame.size.height)/2+(self.centerY-self.center.y);
        
        self.borderFrame = borderFrame;
        
        //////////////////////////////////////////////////
        
        CGRect activityIndicatorViewFrame   = self.activityIndicatorView.frame;
        activityIndicatorViewFrame.origin.x = ((self.frame.size.width-activityIndicatorViewFrame.size.width)/2);
        activityIndicatorViewFrame.origin.y = self.borderFrame.origin.y+PPBuysViewDefaultBorderPadding;
        self.activityIndicatorView.frame    = activityIndicatorViewFrame;
        
        CGRect messageLabelFrame            = self.messageLabel.frame;
        messageLabelFrame.origin.y          = self.activityIndicatorView.frame.origin.y+self.activityIndicatorView.frame.size.height+PPBusyViewDefaultGap;
        self.messageLabel.frame             = messageLabelFrame;
        
        CGRect ppButtonCancelFrame          = self.ppButtonCancel.frame;
        ppButtonCancelFrame.origin.x        = ((self.frame.size.width-ppButtonCancelFrame.size.width)/2);
        ppButtonCancelFrame.origin.y        = self.messageLabel.frame.origin.y + self.messageLabel.frame.size.height+PPBusyViewDefaultGap;
        self.ppButtonCancel.frame           = ppButtonCancelFrame;
        
        //////////////////////////////////////////////////
        
        [self setNeedsDisplay];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setShowCancelButton:(BOOL)showCancelButton
{
    if(_showCancelButton!=showCancelButton)
    {
        _showCancelButton = showCancelButton;
        
        self.ppButtonCancel.hidden = !_showCancelButton;
        
        //////////////////////////////////////////////////
        
        [self setNeedsLayout];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPCancelBusyViewButtonTag_Cancel:
        {
            //防止多重點擊
            ppButton.enabled = NO;
            
            if([self.delegate respondsToSelector:@selector(ppCancelBusyViewDidCancel:)]==YES)
            {
                [self.delegate ppCancelBusyViewDidCancel:self];
            }
            
            break;
        }
        default:
        {
            break;
        }
    }
}

@end
