//
//  PPBusyView.m
//
//  Created by Mike on 13/5/21.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPBusyView.h"

// Category
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

NSString *PPBusyViewNotification_Message = @"PPBusyViewNotification_Message";





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPBusyView()

@interface PPBusyView()

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation PPBusyView

@implementation PPBusyView




////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Init & Delloc

//================================================================================
//
//================================================================================
- (id)initWithFrame:(CGRect)frame
{
	if((self = [super initWithFrame:frame]))
	{
        self.style = PPBusyViewStyle_FillView;
        
        [[PPBusyView appearance] applyInvocationTo:self];

        _centerY = self.center.y;
        
        //////////////////////////////////////////////////
        
		_activityIndicatorView = [[UIActivityIndicatorView alloc] initWithActivityIndicatorStyle:UIActivityIndicatorViewStyleWhiteLarge];
        
        if(self.activityIndicatorView!=nil)
        {
            CGRect activityIndicatorViewFrame = self.activityIndicatorView.frame;
            
            if(activityIndicatorViewFrame.size.width>self.bounds.size.width || activityIndicatorViewFrame.size.height>self.bounds.size.height) 
            {
                activityIndicatorViewFrame.size.width   = MIN(self.bounds.size.width, self.bounds.size.height);
                activityIndicatorViewFrame.size.height  = activityIndicatorViewFrame.size.width;
            }
            
            activityIndicatorViewFrame.origin.x = ((self.frame.size.width-activityIndicatorViewFrame.size.width)/2);
            activityIndicatorViewFrame.origin.y = ((self.frame.size.height-activityIndicatorViewFrame.size.height)/2);
            self.activityIndicatorView.frame	= activityIndicatorViewFrame;
            
            //////////////////////////////////////////////////
            
            //activityIndicatorView在 ios5 多了一層，只設上層的frame還不夠，要連下層一起設定才能改大小
            
            for(UIView *subview in self.activityIndicatorView.subviews) 
            {
                subview.frame = self.activityIndicatorView.bounds;
            }
            
            [self addSubview:self.activityIndicatorView];
            [self.activityIndicatorView startAnimating];
        }
        
        //////////////////////////////////////////////////
        
        CGRect messageLabelFrame = CGRectZero;
        
        messageLabelFrame.origin.x		= PPBusyViewDefaultGap;
        messageLabelFrame.origin.y		= self.activityIndicatorView.frame.origin.y+self.activityIndicatorView.frame.size.height+PPBusyViewDefaultGap;
        messageLabelFrame.size.height	= PPBusyViewDefaultMessageHeight;
        
        _messageLabel = [[PPAutoResizedLabel alloc] initWithFrame:messageLabelFrame];
        
        if(self.messageLabel!=nil)
        {
            self.messageLabel.backgroundColor   = [UIColor clearColor];
            self.messageLabel.shadowColor		= [UIColor blackColor];
            self.messageLabel.textAlignment		= NSTextAlignmentCenter;
            self.messageLabel.textColor			= [UIColor whiteColor];
            self.messageLabel.numberOfLines     = 0;
            
            [self addSubview:self.messageLabel];
        }
        
        //////////////////////////////////////////////////
        
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(messageNotification:)
                                                     name:PPBusyViewNotification_Message
                                                   object:nil];
	}
	
	return self;
}


//================================================================================
//
//================================================================================
- (id)initWithSuperView:(UIView *)superView
{
    CGRect superViewBounds = CGRectZero;
    
    if(superView==nil) 
    {
        UIWindow *keyWindow = [UIApplication sharedApplication].keyWindow;
        
        // !! keyWindow若為nil，改用第一個window。
        if(keyWindow == nil)
        {
            keyWindow = [[UIApplication sharedApplication].windows firstObject];
        }
        
        if(keyWindow!=nil) 
        {
            if(keyWindow.rootViewController!=nil) 
            {
                // !! 有present的話，要秀在present的view controller上，不然會看不到
                UIViewController *viewController = [keyWindow.rootViewController topMostViewController];
                
                if (viewController.navigationController!=nil)
                {
                    superView = viewController.navigationController.view;
                }
                else if(viewController!=nil)
                {
                    superView = viewController.view;
                }
                else
                {
                    superView = keyWindow.rootViewController.view;
                }
            }
            else 
            {
                superView = keyWindow;
            }
            
            superViewBounds = superView.bounds;
        }
    }
    else
	{
		superViewBounds = superView.bounds;
	}
    
    //////////////////////////////////////////////////
    
    if(CGRectIsEmpty(superViewBounds)==YES) 
    {
        superViewBounds = [UIScreen mainScreen].applicationFrame;
    }
    
    //////////////////////////////////////////////////
    
	if((self = [self initWithFrame:superViewBounds]))
	{       
        [superView addSubview:self];
	}
	
	return self;
}


//================================================================================
//
//================================================================================
- (id)initWithSuperView:(UIView *)superView showMessage:(BOOL)showMessage
{
    if(self=[self initWithSuperView:superView])
    {
        if(showMessage==NO)
        {
            [[NSNotificationCenter defaultCenter] removeObserver:self name:PPBusyViewNotification_Message object:nil];
        }
    }
    
    //////////////////////////////////////////////////

    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc 
{
    [[NSNotificationCenter defaultCenter] removeObserver:self name:PPBusyViewNotification_Message object:nil];
	
    //////////////////////////////////////////////////
    
    [self.messageLabel removeFromSuperview];
    [_messageLabel release];
    
    [self.activityIndicatorView stopAnimating];
    [self.activityIndicatorView removeFromSuperview];
    [_activityIndicatorView release];
    
    //////////////////////////////////////////////////
    
	[super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Configuring the Bounds and Frame Rectangles

//================================================================================
//
//================================================================================
- (void)setFrame:(CGRect)frame
{
    [super setFrame:frame];
    
    //////////////////////////////////////////////////
    
    _centerY = self.center.y;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
	[super layoutSubviews];
	
    //////////////////////////////////////////////////
    
    // layoutSubView時使用SuperView的資訊，以確保經過旋轉SubView的位置也正確
    
    CGRect superViewBounds = CGRectZero;
    
    if (self.superview == nil)
    {
        // superview為nil，直接設為keyWindow Size
        superViewBounds = [UIScreen mainScreen].applicationFrame;
    }
    else
    {
        // 設成superview的size
        superViewBounds = self.superview.bounds;
    }
    
    [self setFrame:superViewBounds];
   
    //////////////////////////////////////////////////
    
    CGRect borderFrame = CGRectZero;
    
    if([self.messageLabel.text length]==0) 
    {
        borderFrame.size.height = self.activityIndicatorView.frame.size.height+PPBuysViewDefaultBorderPadding*2;
        borderFrame.size.width  = borderFrame.size.height; 
    }
    else
    {
        borderFrame.size.height = self.activityIndicatorView.frame.size.height+PPBusyViewDefaultGap+
                                  self.messageLabel.frame.size.height+PPBuysViewDefaultBorderPadding*2;
        borderFrame.size.width  = MAX(self.messageLabel.frame.size.width,self.activityIndicatorView.frame.size.width)+PPBuysViewDefaultBorderPadding*2;
    }
    
    borderFrame.origin.x = (self.bounds.size.width-borderFrame.size.width)/2;
    borderFrame.origin.y = (self.bounds.size.height-borderFrame.size.height)/2+(self.centerY-self.center.y);
    
    self.borderFrame = borderFrame;
    
    //////////////////////////////////////////////////
    
    // 設定SubView的位置(原messageLabelFrame的位置有錯，現已修正)
    
    CGRect activityIndicatorViewFrame   = self.activityIndicatorView.frame;
    activityIndicatorViewFrame.origin.x = ((self.frame.size.width-activityIndicatorViewFrame.size.width)/2);
    activityIndicatorViewFrame.origin.y = self.borderFrame.origin.y+PPBuysViewDefaultBorderPadding;
    self.activityIndicatorView.frame    = activityIndicatorViewFrame;
    
    CGRect messageLabelFrame            = self.messageLabel.frame;
    messageLabelFrame.origin.x          = ((self.frame.size.width-messageLabelFrame.size.width)/2);
    messageLabelFrame.origin.y          = self.activityIndicatorView.frame.origin.y+self.activityIndicatorView.frame.size.height+PPBusyViewDefaultGap;
    self.messageLabel.frame             = messageLabelFrame;
    
    //////////////////////////////////////////////////
    
    [self setNeedsDisplay];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

//================================================================================
//
//================================================================================
- (void)drawRect:(CGRect)rect 
{
    [super drawRect:rect];
    
    //////////////////////////////////////////////////
    
    if(self.style==PPBusyViewStyle_Border && CGRectIsEmpty(self.borderFrame)==NO)
    {
        CGContextRef context = UIGraphicsGetCurrentContext();
        if(context!=NULL) 
        {           
            CGContextBeginPath(context);
            CGContextMoveToPoint(context, CGRectGetMinX(self.borderFrame)+PPBusyViewDefaultBorderCornerRadius, CGRectGetMinY(self.borderFrame));
            CGContextAddArc(context, CGRectGetMaxX(self.borderFrame)-PPBusyViewDefaultBorderCornerRadius,
                            CGRectGetMinY(self.borderFrame)+PPBusyViewDefaultBorderCornerRadius, PPBusyViewDefaultBorderCornerRadius, 3*M_PI/2, 0, 0);
            CGContextAddArc(context, CGRectGetMaxX(self.borderFrame)-PPBusyViewDefaultBorderCornerRadius,
                            CGRectGetMaxY(self.borderFrame)-PPBusyViewDefaultBorderCornerRadius, PPBusyViewDefaultBorderCornerRadius, 0, M_PI/2, 0);
            CGContextAddArc(context, CGRectGetMinX(self.borderFrame)+PPBusyViewDefaultBorderCornerRadius,
                            CGRectGetMaxY(self.borderFrame)-PPBusyViewDefaultBorderCornerRadius, PPBusyViewDefaultBorderCornerRadius, M_PI/2, M_PI, 0);
            CGContextAddArc(context, CGRectGetMinX(self.borderFrame)+PPBusyViewDefaultBorderCornerRadius,
                            CGRectGetMinY(self.borderFrame)+PPBusyViewDefaultBorderCornerRadius, PPBusyViewDefaultBorderCornerRadius, M_PI, 3*M_PI/2, 0);
            CGContextClosePath(context);
            
            CGContextSetFillColorWithColor(context, [UIColor colorWithRed:0 green:0 blue:0 alpha:PPBusyViewDefaultAlpha].CGColor);
            CGContextFillPath(context);
        }
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Methods

//================================================================================
//
//================================================================================
- (void)messageNotification:(NSNotification *)notification
{
    [self performSelectorOnMainThread:@selector(setMessage:) withObject:[notification object] waitUntilDone:NO];
}


//================================================================================
//
//================================================================================
- (void)setMessage:(NSString *)message
{
    CGRect maxSizeFrame = CGRectZero;
    
    // !! origin在layoutSubviews會重新計算，這裏不用管，只要設定好最大的顯示範圍。
    maxSizeFrame.size.width = self.bounds.size.width-((PPBusyViewDefaultGap+PPBusyViewDefaultBorderMargin)*2);
    maxSizeFrame.size.height = (self.bounds.size.height-self.activityIndicatorView.frame.size.height)/2-2*PPBusyViewDefaultGap;
    
    self.messageLabel.frame = maxSizeFrame;
    self.messageLabel.text = message;
    
    //////////////////////////////////////////////////
    
    [self layoutSubviews];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Methods

//================================================================================
//
//================================================================================
- (void)setCenterY:(CGFloat)centerY
{
    _centerY = centerY;
    
    //////////////////////////////////////////////////
    
    [self layoutSubviews];
}


//================================================================================
//
//================================================================================
- (void)setStyle:(PPBusyViewStyle)style
{
    _style = style;
    
    //////////////////////////////////////////////////
    
    switch(self.style)
    {
        case PPBusyViewStyle_Border:
        {
            self.backgroundColor = [UIColor clearColor];
            
            break;
        }
        case PPBusyViewStyle_FillView:
        default:
        {
            self.backgroundColor = [UIColor colorWithRed:0 green:0 blue:0 alpha:PPBusyViewDefaultAlpha];
            
            break;
        }
    }
    
    //////////////////////////////////////////////////
    
    [self layoutSubviews];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (void)postMessage:(NSString *)message
{
	[[NSNotificationCenter defaultCenter] postNotificationName:PPBusyViewNotification_Message 
                                                        object:message 
                                                      userInfo:nil];
}






////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - PPAppearance


//==============================================================================
//
//==============================================================================
+ (instancetype)appearance
{
    return [PPAppearance appearanceForClass:[self class]];
}
@end
