//
//  PPTitleBarView.m
//  
//
//  Created by Mike on 13/5/23.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPTitleBarView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPTitleBarView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize	titleLabel = titleLabel_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)initWithFrame:(CGRect)frame
{
	if((self = [super initWithFrame:frame]))
	{
        self.titleLabelAutoresizingGap = 5; // default value
        
        titleLabel_ = [[PPAutoResizedLabel alloc] init];
        self.titleLabel.adjustsFontSizeToFitWidth	= YES;
        self.titleLabel.backgroundColor				= [UIColor clearColor];
        self.titleLabel.font						= [UIFont boldSystemFontOfSize:PPTitleBarViewTitleDefaultFontSizeMax];
        self.titleLabel.minimumScaleFactor          = 0.8;
        self.titleLabel.textAlignment				= NSTextAlignmentCenter;
        
        if([PPTitleBarView titleTextColor]!=nil)
        {
            self.titleLabel.textColor					= [PPTitleBarView titleTextColor];
        }
        else
        {
            self.titleLabel.textColor					= [UIColor whiteColor];
        }
        
        
        [self setViews:[NSArray arrayWithObjects:self.titleLabel, nil] forBlockType:PPBarViewBlockType_Center];
	}
	
	return self;
}

- (void)dealloc 
{
    [titleLabel_ release];
	titleLabel_ = nil;
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

- (void)layoutSubviews
{
    switch(self.style)
    {
        case PPBarViewStyle_CenteredAbsolute:
        case PPBarViewStyle_CenteredRelative:
        {
            if(self.titleLabel.enabled==YES)
            {
                if(self.bounds.size.width>=self.bounds.size.height)
                {
                    self.titleLabel.numberOfLines = 1;
                    self.titleLabel.lineBreakMode = NSLineBreakByTruncatingTail;
                    self.titleLabel.contentInsets = UIEdgeInsetsMake(0, self.titleLabelAutoresizingGap, 0, self.titleLabelAutoresizingGap);
                }
                else
                {
                    self.titleLabel.numberOfLines = 0;
                    self.titleLabel.lineBreakMode = NSLineBreakByCharWrapping;
                    self.titleLabel.contentInsets = UIEdgeInsetsMake(0, self.titleLabelAutoresizingGap, 0, self.titleLabelAutoresizingGap);
                    
                    CGRect frame = self.titleLabel.frame;
                    
                    frame.size = CGSizeMake(frame.size.height, frame.size.width);
                    
                    self.titleLabel.frame = frame;
                }
            }
    
            break;
        }
        case PPBarViewStyle_Default:
        default:
        {
            break;
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super layoutSubviews];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (BOOL)setBlockModel:(PPBarViewBlockModel *)blockModel forType:(PPBarViewBlockType)type
{
    BOOL result = NO;
    
    do
    {
        if(type==PPBarViewBlockType_Center && self.titleLabel.enabled==YES && ([blockModel.itemModels count]!=1 || ((PPBarViewItemModel *)[blockModel.itemModels lastObject]).view!=self.titleLabel))
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = [super setBlockModel:blockModel forType:type];
        
    }while(0);
    
    return result;
}

@end
