//
//  PPBarViewItemModel.m
//  
//
//  Created by Mike on 13/5/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPBarViewItemModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPBarViewItemModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize view                    = view_;
@synthesize edgeInsetsForMiniBar    = edgeInsetsForMiniBar_;
@synthesize edgeInsetsForNormalBar  = edgeInsetsForNormalBar_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{
	if((self = [super init]))
	{
		edgeInsetsForMiniBar_     = PPBarViewItemModelDefaultEdgeInsertsForMiniBar;
        edgeInsetsForNormalBar_   = PPBarViewItemModelDefaultEdgeInsertsForNormalBar;
	}
	
	return self;
}

- (void)dealloc 
{
	[view_ release];
    
	////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (UIColor *)tintColor
{
    UIColor *tintColor = nil;
    
    if([self.view respondsToSelector:@selector(tintColor)]==YES)
    {
        tintColor = [((id)self.view) tintColor];
    }
    
    return tintColor;
}

- (void)setTintColor:(UIColor *)tintColor
{
    if([self.view respondsToSelector:@selector(setTintColor:)]==YES)
    {
        [((id)self.view) setTintColor:tintColor];
    }
}

- (UIEdgeInsets)edgeInsetsForMiniBarState:(BOOL)miniBarState;
{
    return ((miniBarState==YES)?self.edgeInsetsForMiniBar:self.edgeInsetsForNormalBar);
}

- (void)setEdgeInsets:(UIEdgeInsets)edgeInsets forMiniBarState:(BOOL)miniBarState
{
    if(miniBarState==YES)
    {
        self.edgeInsetsForMiniBar=edgeInsets;
    }
    else
    {
        self.edgeInsetsForNormalBar=edgeInsets;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

+ (id)ppBarViewItemModelWithView:(UIView *)view
{
    PPBarViewItemModel *ppBarViewItemModel = nil;
    
    do
    {
        if(view==nil)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        ppBarViewItemModel = [[[PPBarViewItemModel alloc] init] autorelease];
        if(ppBarViewItemModel==nil)
        {
            break;
        }
        
        ppBarViewItemModel.view = view;
        
    }while(0);
    
    return ppBarViewItemModel;
}

@end
