//
//  PPBarViewBlockModel.m
//  
//
//  Created by Mike on 13/5/22.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPBarViewBlockModel.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPBarViewBlockModel

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Synthesize

@synthesize itemModels              = itemModels_;
@synthesize edgeInsetsForMiniBar    = edgeInsetsForMiniBar_;
@synthesize edgeInsetsForNormalBar  = edgeInsetsForNormalBar_;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

- (id)init
{
	if((self = [super init]))
	{
        itemModels_             = [[NSMutableArray alloc] init];
        edgeInsetsForMiniBar_   = PPBarViewBlockModelDefaultEdgeInsertsForMiniBar;
        edgeInsetsForNormalBar_ = PPBarViewBlockModelDefaultEdgeInsertsForNormalBar;
	}
	
	return self;
}

- (void)dealloc 
{
    // ios 8要call這個，不然可能會有leak
    [itemModels_ removeAllObjects];
	[itemModels_ release];
    itemModels_ = nil;
    
	////////////////////////////////////////////////////////////////////////////////////////////////////
    
	[super dealloc];
}

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Methods

- (UIEdgeInsets)edgeInsetsForMiniBarState:(BOOL)miniBarState
{
    return ((miniBarState==YES)?self.edgeInsetsForMiniBar:self.edgeInsetsForNormalBar);
}

- (void)setEdgeInsets:(UIEdgeInsets)edgeInsets forMiniBarState:(BOOL)miniBarState
{
    if(miniBarState==YES)
    {
        self.edgeInsetsForMiniBar=edgeInsets;
    }
    else
    {
        self.edgeInsetsForNormalBar=edgeInsets;
    }
}

@end
