//
//  PPBackgroundTaskController.h
//

#import <UIKit/UIKit.h>

@interface PPBackgroundTaskController : NSObject

/**
 * 加入背景執行task
 *
 * @param key 任意名稱，但不可和其他key重複。
 * @param teminate task中止通知，收到後請快速處理，不要在block中等待。
 * @return 如果key已存在回傳NO
 */
+ (BOOL)addTaskWithKey:(NSString *)key terminate:(void (^)(void))teminate;

/**
 * 移除背景執行task
 *
 * @param key 要移除的task名稱
 */
+ (void)removeTaskWithKey:(NSString *)key;

@end
