//
//  PPAutoResizedLabel.m
//
//  Created by eddie on 2015/6/7.
//  Copyright (c) 2015年 Eddie. All rights reserved.
//

#import "PPAutoResizedLabel.h"

@interface PPAutoResizedLabel ()
@property (nonatomic, assign) CGSize fitsSize;
@property (nonatomic, assign) CGSize boundsSizeDiff;
@end

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPAutoResizedLabel

////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Override methods

//================================================================================
//
//================================================================================
- (void)drawTextInRect:(CGRect)rect
{
    [super drawTextInRect:UIEdgeInsetsInsetRect(rect, self.contentInsets)];
}


//================================================================================
// Called by sizeToFit
//================================================================================
- (CGSize)sizeThatFits:(CGSize)size
{
    if(CGSizeEqualToSize(self.maxSize, CGSizeZero) == NO)
    {
        size = self.maxSize;
    }
    
    //////////////////////////////////////////////////

    CGSize newSize = [super sizeThatFits:size];
    
    newSize.width += (self.contentInsets.left + self.contentInsets.right);
    newSize.height += (self.contentInsets.top + self.contentInsets.bottom);
    
    if(self.widthMustLargerThenHeight == YES)
    {
        newSize.width = fmaxf(newSize.width, newSize.height);
    }
    
//    NSLog(@"%s %@ new %@", __func__, NSStringFromCGSize(size), NSStringFromCGSize(newSize));
    
    self.fitsSize = newSize;
    
    return newSize;
}


//================================================================================
//
//================================================================================
- (void)setText:(NSString *)text
{
//    NSLog(@"%s %@", __func__, text);
    
    [super setText:text];
    [super sizeToFit];
}


//================================================================================
//
//================================================================================
- (void)setBounds:(CGRect)bounds
{
//    NSLog(@"%s %@", __func__, NSStringFromCGRect(bounds));
    
    CGRect newBounds = CGRectMake(0, 0, self.fitsSize.width, self.fitsSize.height);
    
    //////////////////////////////////////////////////

    if ([[UIDevice currentDevice] systemVersion].floatValue < 8.0)
    {
        self.boundsSizeDiff = CGSizeMake(newBounds.size.width - bounds.size.width,
                                         newBounds.size.height - bounds.size.height);
    }
    
    //////////////////////////////////////////////////
    
    if(self.isCircleShape == YES)
    {
        self.layer.cornerRadius = newBounds.size.height/2.0;
    }

    //////////////////////////////////////////////////
    
    [super setBounds:newBounds];
}


//================================================================================
//
//================================================================================
- (void)setCenter:(CGPoint)center
{
//    NSLog(@"%s old:%@ new:%@", __func__, NSStringFromCGPoint(self.center), NSStringFromCGPoint(center));
 
    // !! iOS7調整bounds後如果layout的constraint用center當作條件，center位置會偏移，需要根據變化量做調整。
    if ([[UIDevice currentDevice] systemVersion].floatValue < 8.0)
    {
        center.x -= (self.boundsSizeDiff.width/2);
        center.y -= (self.boundsSizeDiff.height/2);
    }
    
    [super setCenter:center];
}



/*
//================================================================================
//
//================================================================================
- (CGPoint)center
{
    CGPoint temp = [super center];

    NSLog(@"%s %@", __func__, NSStringFromCGPoint(temp));

    return temp;
}

//================================================================================
//
//================================================================================
- (void)sizeToFit
{
    NSLog(@"%s", __func__);
    
    [super sizeToFit];
}


//================================================================================
//
//================================================================================
- (CGRect)frame
{
    NSLog(@"%s %@ - %@", __func__, NSStringFromCGRect([super frame]), NSStringFromCGRect([super bounds]));
    
    return [super frame];
}


//================================================================================
//
//================================================================================
- (void)setFrame:(CGRect)frame
{
    NSLog(@"%s %@", __func__, NSStringFromCGRect(frame));
    
    [super setFrame:frame];
}


//================================================================================
//
//================================================================================
- (CGRect)bounds
{
    NSLog(@"%s %@", __func__, NSStringFromCGRect([super bounds]));
    
    return [super bounds];
}
*/



@end
