//
//  PPAlertView.m
//
//
//  Created by Mike on 13/6/3.
//  Copyright (c) 2013年 Penpower. All rights reserved.
//

#import "PPAlertView.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

static BOOL         allowMultiAlert = YES;
static BOOL         autoHideWhenEnterBackground = NO;
static NSInteger    instanceCount   = 0;

static NSString *const PPAlertViewCloseNotification = @"PPAlertViewCloseNotification";

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPAlertView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    if((self = [super init]))
    {
        instanceCount++;
    }
	
	return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    instanceCount--;
    [[NSNotificationCenter defaultCenter] removeObserver:self];
  
    //////////////////////////////////////////////////
    
	[super dealloc];
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Notification receiver

//==============================================================================
//
//==============================================================================
- (void)recvUIApplicationWillResignActiveNotification
{
    [self dismissWithClickedButtonIndex:self.cancelButtonIndex animated:NO];
}

//==============================================================================
//
//==============================================================================
- (void)recvCloseNotification
{
    [self dismissWithClickedButtonIndex:self.cancelButtonIndex animated:NO];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Overwrite Methods

//================================================================================
//
//================================================================================
- (void)show
{
    if (autoHideWhenEnterBackground == YES)
    {
        [[NSNotificationCenter defaultCenter] addObserver:self
                                                 selector:@selector(recvUIApplicationWillResignActiveNotification)
                                                     name:UIApplicationWillResignActiveNotification
                                                   object:nil];
    }

    [[NSNotificationCenter defaultCenter] addObserver:self
                                             selector:@selector(recvCloseNotification)
                                                 name:PPAlertViewCloseNotification
                                               object:nil];

    //////////////////////////////////////////////////
    
    if([NSThread currentThread].isMainThread==YES)
    {
        [super show];
    }
    else
    {
        [self performSelectorOnMainThread:@selector(show) withObject:nil waitUntilDone:NO];
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Methods

//================================================================================
//
//================================================================================
+ (void)setAllowMultiAlert:(BOOL)allow
{
    allowMultiAlert = allow;
}


//================================================================================
//
//================================================================================
+ (BOOL)isAllowMultiAlert
{
    return allowMultiAlert;
}


//================================================================================
//
//================================================================================
+ (BOOL)canAlert
{
    BOOL result = [PPAlertView isAllowMultiAlert];
    
    if(result==NO)
    {
        result = YES;
        
        NSArray *windows = [UIApplication sharedApplication].windows;
        
        for(UIWindow *window in windows)
        {
            NSArray *subviews = window.subviews;
            
            for(UIView *subview in subviews)
            {
                if([subview isKindOfClass:[UIAlertView class]]==YES)
                {
                    if(((UIAlertView *)subview).isVisible==YES)
                    {
                        result = NO;
                        break;
                    }
                }
            }
            
            if(result==NO)
            {
                break;
            }
        }
        
        //////////////////////////////////////////////////
        
        if(instanceCount>0)
        {
            result = NO;
        }
    }
    
    return result;
}


//==============================================================================
//
//==============================================================================
+ (void)autoHideWhenEnterBackground:(BOOL)hide
{
    autoHideWhenEnterBackground = hide;
}


//==============================================================================
//
//==============================================================================
+ (void)cancelAllAlertView
{
    [[NSNotificationCenter defaultCenter] postNotificationName:PPAlertViewCloseNotification object:nil];
}


//================================================================================
//
//================================================================================
+ (BOOL)showWithStyle:(UIAlertViewStyle)style title:(NSString *)title message:(NSString *)message delegate:(id<UIAlertViewDelegate>)delegate tag:(NSInteger)tag cancelButtonTitle:(NSString *)cancelButtonTitle otherButtonTitles:(NSString *)otherButtonTitles arguments:(va_list)arguments
{
    BOOL result = NO;
    
    do
    {
        if([PPAlertView canAlert]==NO)
        {
            break;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        PPAlertView *ppAlertView = [[PPAlertView alloc] init];
        if(ppAlertView!=nil)
        {
            ppAlertView.alertViewStyle  = style;
            ppAlertView.tag             = tag;
            ppAlertView.title = title;
            ppAlertView.message = message;
            ppAlertView.delegate = delegate;
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            if(cancelButtonTitle!=nil)
            {
                ppAlertView.cancelButtonIndex = [ppAlertView addButtonWithTitle:cancelButtonTitle];
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            for(NSString *title=otherButtonTitles; title!=nil; title=va_arg(arguments, NSString *))
            {
                [ppAlertView addButtonWithTitle:title];
            }
            
            ////////////////////////////////////////////////////////////////////////////////////////////////////
            
            [ppAlertView show];
            [ppAlertView release];
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        
        result = YES;
        
    }while(0);
    
    return result;
}


//================================================================================
//
//================================================================================
+ (BOOL)showWithStyle:(UIAlertViewStyle)style title:(NSString *)title message:(NSString *)message delegate:(id<UIAlertViewDelegate>)delegate tag:(NSInteger)tag cancelButtonTitle:(NSString *)cancelButtonTitle otherButtonTitles:(NSString *)otherButtonTitles, ...
{
    BOOL result = NO;
    
    va_list arguments;
    va_start(arguments, otherButtonTitles);
    
    result = [PPAlertView showWithStyle:style title:title message:message delegate:delegate tag:tag cancelButtonTitle:cancelButtonTitle otherButtonTitles:otherButtonTitles arguments:arguments];
    
    va_end(arguments);
    
    return result;
}


//================================================================================
//
//================================================================================
+ (BOOL)showWithStyle:(UIAlertViewStyle)style title:(NSString *)title message:(NSString *)message delegate:(id<UIAlertViewDelegate>)delegate cancelButtonTitle:(NSString *)cancelButtonTitle otherButtonTitles:(NSString *)otherButtonTitles, ...
{
    BOOL result = NO;
    
    va_list arguments;
    va_start(arguments, otherButtonTitles);
    
    result = [PPAlertView showWithStyle:style title:title message:message delegate:delegate tag:0 cancelButtonTitle:cancelButtonTitle otherButtonTitles:otherButtonTitles arguments:arguments];
    
    va_end(arguments);
    
    return result;
}


//================================================================================
//
//================================================================================
+ (BOOL)showWithStyle:(UIAlertViewStyle)style title:(NSString *)title message:(NSString *)message cancelButtonTitle:(NSString *)cancelButtonTitle otherButtonTitles:(NSString *)otherButtonTitles, ...
{
    BOOL result = NO;
    
    va_list arguments;
    va_start(arguments, otherButtonTitles);
    
    result = [PPAlertView showWithStyle:style title:title message:message delegate:nil tag:0 cancelButtonTitle:cancelButtonTitle otherButtonTitles:otherButtonTitles arguments:arguments];
    
    va_end(arguments);
    
    return result;
}

@end
