//
//  AlbumContentSectionHeaderView.m
//
//  Created by Howard on 2015/2/25.
//
//

#import "AlbumContentSectionHeaderView.h"

@implementation AlbumContentSectionHeaderView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (id)init
{
    if(self=[super init])
    {
    
        //////////////////////////////////////////////////
        
        _locationLabel = [[UILabel alloc] init];
        
        if(_locationLabel!=nil)
        {
            [_locationLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self addSubview:_locationLabel];
        }
        
        //////////////////////////////////////////////////
        
        _timeLabel = [[UILabel alloc] init];
        
        if(_timeLabel!=nil)
        {
            [_timeLabel setTranslatesAutoresizingMaskIntoConstraints:NO];
            [self addSubview:_timeLabel];
        }
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    [_locationLabel removeFromSuperview];
    [_locationLabel release];
    
    [_timeLabel removeFromSuperview];
    [_timeLabel release];
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Core Layout Methods

//================================================================================
//
//================================================================================
- (void)updateConstraints
{
    [super updateConstraints];
    
    //////////////////////////////////////////////////
    
    NSLayoutConstraint *myConstraint;
    
    [self removeConstraints:self.constraints];
    
    //////////////////////////////////////////////////

    if(self.locationLabel.text!=nil && self.locationLabel.text.length>0)
    {
        //寬度限制
        myConstraint = [NSLayoutConstraint constraintWithItem:self.locationLabel
                                                    attribute:NSLayoutAttributeWidth
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeWidth
                                                   multiplier:1
                                                     constant:0];
        
        [self addConstraint:myConstraint];
        
        //////////////////////////////////////////////////
        
        //高度限制
        myConstraint = [NSLayoutConstraint constraintWithItem:self.locationLabel
                                                    attribute:NSLayoutAttributeHeight
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeHeight
                                                   multiplier:0.5
                                                     constant:0];
        
        [self addConstraint:myConstraint];
        
        //////////////////////////////////////////////////

        // x位置
        
        myConstraint = [NSLayoutConstraint constraintWithItem:self.locationLabel
                                                    attribute:NSLayoutAttributeLeft
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeLeft
                                                   multiplier:1
                                                     constant:0];
        
        [self addConstraint:myConstraint];
        
        //////////////////////////////////////////////////

        // y location
        
        myConstraint = [NSLayoutConstraint constraintWithItem:self.locationLabel
                                                    attribute:NSLayoutAttributeTop
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeTop
                                                   multiplier:0
                                                     constant:0];
        
        [self addConstraint:myConstraint];
    
    }

    //////////////////////////////////////////////////

    if(self.timeLabel.text!=nil && self.timeLabel.text.length>0)
    {
        
        myConstraint = [NSLayoutConstraint constraintWithItem:self.timeLabel
                                                    attribute:NSLayoutAttributeWidth
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeWidth
                                                   multiplier:1
                                                     constant:0];
        
        [self addConstraint:myConstraint];
        
        //////////////////////////////////////////////////
        
        
        myConstraint = [NSLayoutConstraint constraintWithItem:self.timeLabel
                                                    attribute:NSLayoutAttributeHeight
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeHeight
                                                   multiplier:0.5
                                                     constant:0];
        
        
        [self addConstraint:myConstraint];
        
        //////////////////////////////////////////////////
        
        
        myConstraint = [NSLayoutConstraint constraintWithItem:self.timeLabel
                                                    attribute:NSLayoutAttributeCenterX
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeCenterX
                                                   multiplier:1
                                                     constant:0];
        
        [self addConstraint:myConstraint];
        
        //////////////////////////////////////////////////
        
        
        myConstraint = [NSLayoutConstraint constraintWithItem:self.timeLabel
                                                    attribute:NSLayoutAttributeCenterY
                                                    relatedBy:NSLayoutRelationEqual
                                                       toItem:self
                                                    attribute:NSLayoutAttributeCenterY
                                                   multiplier:1
                                                     constant:0];
        
        [self addConstraint:myConstraint];
    }
}

@end
