//
//  PPAlbumViewController.m
//
//  Created by howard.lin on 13/3/13.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import <QuartzCore/QuartzCore.h>
#import <Photos/Photos.h>

// Define
#import "PPAlbumViewController+ParameterDefine.h"
#import "PPAlbumViewController+ResourceDefine.h"

// View
#import "PPButton.h"
#import "PPNavigationBarView.h"


// Controller
#import "AlbumImageFileController.h"
#import "PPAlbumSectionController.h"
#import "PPAlbumViewController.h"
#import "PPLogController.h"
#import "PPNavigationController.h"
#import "PPAlertController.h"

// Category
#import "NSString+Additions.h"
#import "PPButton+Factory.h"
#import "UIViewController+ShareApplication.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@interface PPAlbumViewController () <PPAlbumSectionControllerDelegate,PPButtonDelegate,UITableViewDataSource,UITableViewDelegate>

@property (nonatomic,retain) PPAlbumSectionController *albumSectionController;
@property (nonatomic,retain) PPButton                 *exitAlbumButton;
@property (nonatomic,retain) PPNavigationBarView      *navigationBarView;
@property (nonatomic,retain) UITableView              *ppTabelView;
@property (nonatomic,copy)   NSString                 *mountSanboxDirectory;

@end

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlbumViewController

@implementation PPAlbumViewController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Deallocating Objects

//================================================================================
//
//================================================================================
- (id)init
{
    self = [super init];
    
    if(self)
    {
        [[PPAlbumViewController appearance] applyInvocationTo:self];
     
        //////////////////////////////////////////////////
        
        _albumSectionController = [[PPAlbumSectionController alloc] init];
        
        if(_albumSectionController!=nil)
        {
            _albumSectionController.delegate = self;
        }
        
    }
    
    return self;
}


//================================================================================
//
//================================================================================
+ (void)initialize
{
    //如果需要設定appearance的預設值，請覆寫NSObject的+initialize。
    [[PPAlbumViewController appearance] setTableViewCellRowHeight:PPAlbumViewController_cellrowHeight];
}




//================================================================================
//
//================================================================================
- (void)dealloc
{
    _delegate = nil;
    self.albumSectionController = nil;
    
    [_mountSanboxDirectory    release];
    
    [_exitAlbumButton removeFromSuperview];
    [_exitAlbumButton release];
    _exitAlbumButton = nil;
    
    [_navigationBarView removeFromSuperview];
    [_navigationBarView release];
    _navigationBarView = nil;
    
    [_ppTabelView setDataSource:nil];
    [_ppTabelView setDelegate:nil];
    [_ppTabelView removeFromSuperview];
    [_ppTabelView release];
    _ppTabelView = nil;
    
    [_navigationBarViewButtonHighlightedBackgroundColor release];
    _navigationBarViewButtonHighlightedBackgroundColor = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Responding to View Events

//================================================================================
//
//================================================================================
- (void)viewWillAppear:(BOOL)animated
{
    PPLogFunctionIn();
    
    //////////////////////////////////////////////////
    
	[super viewWillAppear:animated];
    
    //////////////////////////////////////////////////

    self.navigationBarView = [[[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds] autorelease];
    
    if(self.navigationBarView!=nil)
    {
        self.navigationBarView.style           = PPBarViewStyle_CenteredAbsolute;
        self.navigationBarView.titleLabel.text = [@"MLS_Album" localizedFromTable:NSStringFromClass(self.class)];
    }
    
    //////////////////////////////////////////////////

    if(self.ppTabelView==nil)
    {
        _ppTabelView = [[UITableView alloc] init];
    }
    
    if(self.ppTabelView!=nil)
    {
        self.ppTabelView.dataSource = self;
        self.ppTabelView.delegate   = self;

        [self.view addSubview:self.ppTabelView];
    }
    
    //////////////////////////////////////////////////
    
    self.exitAlbumButton = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                           tag:PPAlbumViewControllerButtonTag_Cancel
                                                      delegate:self
                                         normalBackgroundColor:nil
                                    highlightedBackgroundColor:self.navigationBarViewButtonHighlightedBackgroundColor
                                               imageEdgeInsets:self.navigationBarViewButtonImageEdgeInset];

    if(self.exitAlbumButton!=nil)
    {
        if(self.exitAlbumButton.imageView.image==nil)
        {
            [self.exitAlbumButton setTitle:[@"MLS_Back" localizedFromTable:NSStringFromClass([self.exitAlbumButton class])] maxWidth:0.0];
        }
        
        [self.exitAlbumButton addControlEvents:UIControlEventTouchUpInside];
        
        //////////////////////////////////////////////////

        PPBarViewItemModel *existItemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.exitAlbumButton];
        
        if(existItemModel!=nil)
        {
            existItemModel.edgeInsetsForNormalBar = UIEdgeInsetsMake(0, 0, 0, 0);
            
            [self.navigationBarView setItemModels:@[existItemModel] forBlockType:PPBarViewBlockType_Left];
        }
    }

    
    //////////////////////////////////////////////////
    
    //覆蓋NavigationBarView上方列
    if(self.navigationController!=nil)
    {
        UIBarButtonItem *leftBarButtonItem = [[UIBarButtonItem alloc] initWithCustomView:self.navigationBarView];
        
        if(leftBarButtonItem!=nil)
        {
            self.navigationItem.leftBarButtonItem = leftBarButtonItem;
            [leftBarButtonItem release];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.mountSanboxDirectory!=nil && self.mountSanboxDirectory.length>0)
    {
        [self.albumSectionController sandBoxAlbumExtracWithDirectory:self.mountSanboxDirectory];
    }
    else
    {
        [self.albumSectionController albumExtract];
    }
    
    //////////////////////////////////////////////////
    
    PPLogFunctionOut();
}


//================================================================================
//
//================================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    PPLogFunctionIn();
    
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
    
    //////////////////////////////////////////////////
    
    if(self.navigationItem!=nil)
    {
        self.navigationItem.leftBarButtonItem = nil;
    }
    
    //////////////////////////////////////////////////
    
    [self.ppTabelView setDataSource:nil];
    [self.ppTabelView setDelegate:nil];
    [self.ppTabelView removeFromSuperview];
    self.ppTabelView = nil;
    
    //////////////////////////////////////////////////

    [self.exitAlbumButton removeFromSuperview];
    self.exitAlbumButton = nil;
    
    //////////////////////////////////////////////////
    
    PPLogFunctionOut();
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Laying out Subviews

//================================================================================
//
//================================================================================
- (void)layoutSubviews
{
    [super layoutSubviews];
    
    //////////////////////////////////////////////////

    CGRect layoutFrame = [self layoutFrame];

    self.ppTabelView.frame = layoutFrame;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDataSouce Method

//================================================================================
//
//================================================================================
- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView
{
    //時刻欄位
    return  [self.albumSectionController numberOfSectionsForSearching:NO];
}


//================================================================================
//
//================================================================================
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section
{
    return [self.albumSectionController numberOfRowsInSection:section forSearching:NO];
}


//================================================================================
//
//================================================================================
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath
{
    NSString *CellIdentifier = NSStringFromClass([UITableViewCell class]);
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    
    if (cell == nil)
    {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
    
    cell.imageView.image = nil;
    cell.imageView.transform = CGAffineTransformIdentity;
    
    //////////////////////////////////////////////////

    do
    {
        NSUInteger section = indexPath.section;
        
        if(section>1)
        {
            section = 0;
        }
        
        //////////////////////////////////////////////////

        NSUInteger row     = indexPath.row;
        
        PPRowModel *rowModel = [self.albumSectionController rowModelAtIndexPath:[NSIndexPath indexPathForRow:row inSection:section] forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        cell.textLabel.text = rowModel.text;
        
        if([rowModel.object isKindOfClass:[PHAssetCollection class]]==YES)
        {
            PHAssetCollection *assetCollection  = rowModel.object;
            [cell retain];
            [AlbumImageFileController fetchPosterImageWithAssetCollection:assetCollection completeHandler:^(UIImage *result) {
               
                NSLog(@"%@: %@", cell.textLabel.text, result);
                cell.imageView.image = result;
                [cell setNeedsLayout];
                [cell release];
            }];            
        }
        else if([rowModel.object isKindOfClass:[NSString class]]==YES)
        {
            NSString *imageFilePath = [self.mountSanboxDirectory stringByAppendingString:[NSString stringWithFormat:@"/%@",rowModel.object]];
            
            NSArray *imageFileNames = [AlbumImageFileController itemArrayWithAppSandboxDirectory:[self.mountSanboxDirectory stringByAppendingFormat:@"/%@",rowModel.object]];
            
            
            if(imageFileNames!=nil && imageFileNames.count>0)
            {
                //拿folder下最後一張照片顯示
                UIImage *image = [AlbumImageFileController imageFilePath:imageFilePath withFileName:[imageFileNames objectAtIndex:imageFileNames.count-1]];
                
                //壓縮圖
                if(PPAlbumViewController_cellImageIconSize.width>PPAlbumViewController_cellImageIconSize.height)
                {
                    image = [image imageRotatedByDegrees:0 scalingMaxLength:PPAlbumViewController_cellImageIconSize.width];
                }
                else
                {
                    image = [image imageRotatedByDegrees:0 scalingMaxLength:PPAlbumViewController_cellImageIconSize.height];
                }
                
                ////////////////////////////////////////////////////////////////////////////////////////////////////
                
                cell.imageView.image = image;
                
                float sw=PPAlbumViewController_cellImageIconSize.width/cell.imageView.image.size.width;
                float sh=PPAlbumViewController_cellImageIconSize.height/cell.imageView.image.size.height;
                cell.imageView.transform=CGAffineTransformMakeScale(sw,sh);
            }

        }
    }
    while (0);
    
    //////////////////////////////////////////////////

    cell.accessoryType = UITableViewCellAccessoryDisclosureIndicator;
    
    return cell;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - UITableViewDelegate Method

//================================================================================
//
//================================================================================
- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath
{
    do
    {
        if([self.delegate respondsToSelector:@selector(ppAlbumViewController:didSelectedAssetsCollection:groupName:)]==NO)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        PPRowModel *rowModel = [self.albumSectionController rowModelAtIndexPath:indexPath forSearching:NO];
        
        if(rowModel==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        if([rowModel.object isKindOfClass:[PHAssetCollection class]]==YES)
        {
            [self.delegate ppAlbumViewController:self didSelectedAssetsCollection:rowModel.object groupName:rowModel.text];
        }
        else if([rowModel.object isKindOfClass:[NSString class]]==YES)
        {
            [self.delegate ppAlbumViewController:self didSelectImageFileDocumentPath:[self.mountSanboxDirectory stringByAppendingString:[NSString stringWithFormat:@"/%@",rowModel.object]]];
        }
    }
    while (0);
}


//================================================================================
//
//================================================================================
- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath
{
    return self.tableViewCellRowHeight;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAlbumSectionController Delegate Method

//================================================================================
//
//================================================================================
- (void)ppAlbumSectionControllerDidFinishAlbumExtract:(PPAlbumSectionController *)ppAlbumSectionController
{
    [self.ppTabelView reloadData];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPAppearance protocol methods

//================================================================================
//
//================================================================================
+ (id)appearance
{
    // MARK: 實作+appearance的方式固定如下
    return [PPAppearance appearanceForClass:[self class]];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Property Method

//================================================================================
//
//================================================================================
- (void)setNavigationBarViewButtonImageEdgeInset:(UIEdgeInsets)navigationBarViewButtonImageEdgeInset
{
    _navigationBarViewButtonImageEdgeInset = navigationBarViewButtonImageEdgeInset;
}


//================================================================================
//
//================================================================================
- (void)setNavigationBarViewButtonHighlightedBackgroundColor:(UIColor *)navigationBarViewButtonHighlightedBackgroundColor
{
    [_navigationBarViewButtonHighlightedBackgroundColor release];
    _navigationBarViewButtonHighlightedBackgroundColor = [navigationBarViewButtonHighlightedBackgroundColor retain];
}


//================================================================================
//
//================================================================================
- (void)setTableViewCellRowHeight:(CGFloat)tableViewCellRowHeight
{
    _tableViewCellRowHeight = tableViewCellRowHeight;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate Method

//================================================================================
//
//================================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    switch (ppButton.tag)
    {
        case PPAlbumViewControllerButtonTag_Cancel:
        {
            if([self.delegate respondsToSelector:@selector(ppAlbumViewControllerDidCancel:)]==YES)
            {
                [self.delegate ppAlbumViewControllerDidCancel:self];
            }
            break;
        }
        default:
        {
            break;
        }
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (void)presentFromSuperViewController:(UIViewController *)superViewController
                              delegate:(id<PPAlbumViewControllerDelegate>)delegate
                  mountSanboxDirectory:(NSString *)mountSanboxDirectory
{
    void(^PhotosAuthenticationHandler)(PHAuthorizationStatus status) = ^(PHAuthorizationStatus status)
    {
        if(status==PHAuthorizationStatusDenied)
        {
            [PPAlertController showWithAlertControllerStyle:UIAlertControllerStyleAlert
                                                      title:@""
                                                    message:PPAV_MLS_AlbumPolicyFailed
                                     showFromViewController:superViewController
                                                   animated:YES
                                                alertAction:[UIAlertAction actionWithTitle:PPAV_MLS_Ok
                                                                                     style:UIAlertActionStyleCancel
                                                                                   handler:nil], nil];
        }
        else
        {
            do
            {
                if(superViewController==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                PPAlbumViewController *albumViewController = [[[PPAlbumViewController alloc] init] autorelease];
                
                if(albumViewController==nil)
                {
                    break;
                }
                
                albumViewController.delegate = delegate;
                
                //////////////////////////////////////////////////
                
                albumViewController.mountSanboxDirectory = mountSanboxDirectory;
                
                //////////////////////////////////////////////////
                
                
                PPNavigationController *navigationController = [[[PPNavigationController alloc] initWithRootViewController:albumViewController] autorelease];
                
                if(navigationController==nil)
                {
                    break;
                }
                
                //////////////////////////////////////////////////
                
                [superViewController presentViewController:navigationController animated:YES completion:nil];
                
            }
            while (0);
        }
    };
    
    //////////////////////////////////////////////////
    [PPAlbumViewController checkAuthenticationWithCompleteHandler:^(PHAuthorizationStatus status) {
       
        PhotosAuthenticationHandler(status);
    }];
}


//==============================================================================
//
//==============================================================================
+ (void)checkAuthenticationWithCompleteHandler:(void(^)(PHAuthorizationStatus status))completeHandler
{
    PHAuthorizationStatus status = PHAuthorizationStatusNotDetermined;

    // !! ios 14以上才有此API
#if __IPHONE_OS_VERSION_MAX_ALLOWED >= 140000

    if (@available(iOS 14, *))
    {
        // !!授权相关：旧 API 废弃，增加 PHAccessLevel 参数。如果再使用以前的API来获取权限状态，
        // PHAuthorizationStatusLimited 状态下也会返回 PHAuthorizationStatusAuthorized
        // https://juejin.im/post/6850418120923250701#heading-5
        
        status = [PHPhotoLibrary authorizationStatusForAccessLevel:PHAccessLevelReadWrite];
        
        if (status==PHAuthorizationStatusNotDetermined)
        {
            [PHPhotoLibrary requestAuthorizationForAccessLevel:PHAccessLevelReadWrite handler:^(PHAuthorizationStatus systemStatus) {
                
                if(completeHandler)
                {
                    dispatch_async(dispatch_get_main_queue(), ^{
                        completeHandler(systemStatus);
                    });
                }
            }];
        }
        else
        {
            if(completeHandler)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    completeHandler(status);
                });
            }
        }
    }
    else
#endif
    {
        status = [PHPhotoLibrary authorizationStatus];
        
        if (status==PHAuthorizationStatusNotDetermined)
        {
            [PHPhotoLibrary requestAuthorization:^(PHAuthorizationStatus systemStatus) {
                
                if(completeHandler)
                {
                    dispatch_async(dispatch_get_main_queue(), ^{
                        completeHandler(systemStatus);
                    });
                }
            }];
        }
        else
        {
            if(completeHandler)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    completeHandler(status);
                });
            }
        }
    }
}

@end
