//
//  PPAlbumSectionController.m
//
//  Created by Howard on 2015/2/17.
//
//

#import "PPAlbumSectionController.h"

// Define
#import "PPAlbumContentViewController+ResourceDefine.h"

// Controller
#import "AlbumImageFileController.h"
#import "PHFetchOptionsHelper.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

@implementation PPAlbumSectionController





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - init/dealloc methods

//==============================================================================
//
//==============================================================================
- (void)dealloc
{
    self.mountSanboxDirectory = nil;
    
    //////////////////////////////////////////////////
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Private


//==============================================================================
// 取得指定Type，subtype的相簿
//==============================================================================
- (NSMutableArray *)fetchAssetCollectionArrayWithType:(PHAssetCollectionType)type sutType:(PHAssetCollectionSubtype)subtype designatedTitle:(NSString *)title
{
    PHFetchResult *fetchResult = nil;
        
    PHFetchOptions *fetchOptions = [PHFetchOptionsHelper photoAlbumsFetchOptions];
    
    NSMutableArray *resultArray =[NSMutableArray array];
    
    fetchResult = [PHAssetCollection fetchAssetCollectionsWithType:type subtype:subtype options:fetchOptions];

    for (PHAssetCollection *assetCollection in fetchResult)
    {
        PPRowModel *rowModel = [[PPRowModel alloc] init];
        
        if(rowModel==nil)
        {
            break;
        }
        
        rowModel.object = assetCollection;
        
        PHFetchResult *assetResult = [PHAsset fetchAssetsInAssetCollection:assetCollection options:[PHFetchOptionsHelper photosFetchOptions]];
        
        NSInteger assetCount = [assetResult count];
        
        NSString *collectionTitle = title;
        
        if ([collectionTitle length]==0)
        {
            collectionTitle = assetCollection.localizedTitle;
        }
        if (assetCount!=NSNotFound)
        {
            rowModel.text = [collectionTitle stringByAppendingFormat:@"(%zd)", assetCount];
        }
        else
        {
            rowModel.text = collectionTitle;
        }
        [resultArray addObject:rowModel];
        
        [rowModel release];
    }
    
    return resultArray;
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)albumExtract
{
    NSMutableArray *albums = [NSMutableArray array];
    
    //////////////////////////////////////////////////
    do
    {
        // MARK: PhotosKit每種相簿要分開抓
        //////////////////////////////////////////////////
        //  moment album
        
        PPSectionModel *momentAlbumSectionModel = [[PPSectionModel alloc] init];
        
        if(momentAlbumSectionModel!=nil)
        {
            [albums addObject:momentAlbumSectionModel];
            
            momentAlbumSectionModel.section = PPAlbumSectionControllerSectionTag_TimeStapAlbum;
            
            [momentAlbumSectionModel release];
        }
        
        //////////////////////////////////////////////////
        // 也是Recent，但title不同，排序不同
        NSMutableArray *momentArray = [self fetchAssetCollectionArrayWithType:PHAssetCollectionTypeSmartAlbum sutType:PHAssetCollectionSubtypeSmartAlbumUserLibrary designatedTitle:PAVC_MLS_Moments];
        
        [momentAlbumSectionModel.rowModels addObjectsFromArray:momentArray];

        
        //////////////////////////////////////////////////
        // system album
        
        PPSectionModel *systemAlbumSectionModel = [[PPSectionModel alloc] init];
        
        if(systemAlbumSectionModel!=nil)
        {
            [albums addObject:systemAlbumSectionModel];
            
            systemAlbumSectionModel.section = PPAlbumSectionControllerSectionTag_SystemAlbum;
            
            [systemAlbumSectionModel release];
        }
            
        //////////////////////////////////////////////////
        NSMutableArray *recentArray = [self fetchAssetCollectionArrayWithType:PHAssetCollectionTypeSmartAlbum sutType:PHAssetCollectionSubtypeSmartAlbumUserLibrary designatedTitle:nil];
        
        // Recent
        [systemAlbumSectionModel.rowModels addObjectsFromArray:recentArray];
        
        //////////////////////////////////////////////////
        // User add
        NSMutableArray *userAlbums = [self fetchAssetCollectionArrayWithType:PHAssetCollectionTypeAlbum sutType:PHAssetCollectionSubtypeAny designatedTitle:nil];
        [systemAlbumSectionModel.rowModels addObjectsFromArray:userAlbums];


    } while (0);

    
    //////////////////////////////////////////////////
    
    [self replaceSectionModels:albums forSearching:NO];
    if([self.delegate respondsToSelector:@selector(ppAlbumSectionControllerDidFinishAlbumExtract:)]==YES)
    {
        [self.delegate ppAlbumSectionControllerDidFinishAlbumExtract:self];
    }
}


//================================================================================
//
//================================================================================
- (void)sandBoxAlbumExtracWithDirectory:(NSString *)directory
{
    do
    {
        if(directory==nil || directory.length<=0)
        {
            break;
        }
        
        //////////////////////////////////////////////////

        self.mountSanboxDirectory = directory;
        
        [[self sectionModelsForSearching:NO] removeAllObjects];
        
        //////////////////////////////////////////////////

        PPSectionModel *sandBoxSectionModel = [[PPSectionModel alloc] init];
        
        if(sandBoxSectionModel==nil)
        {
            break;
        }
        
        sandBoxSectionModel.section = PPAlbumSectionControllerSectionTag_SandBox;
        
        [[self sectionModelsForSearching:NO] addObject:sandBoxSectionModel];
        
        //////////////////////////////////////////////////

        NSArray *itemAppSandBoxAlbumArray = [AlbumImageFileController itemArrayWithAppSandboxDirectory:directory];
        
        for (id object in itemAppSandBoxAlbumArray)
        {
            if([object isKindOfClass:[NSString class]]==NO)
            {
                break;
            }
            
            //////////////////////////////////////////////////

            NSString *filePath = object;
            
            //////////////////////////////////////////////////
            
            PPRowModel *rowModel = [[PPRowModel alloc] init];
            
            if(rowModel!=nil)
            {
                rowModel.object = filePath;
                
                NSArray *imageFileNames = [AlbumImageFileController itemArrayWithAppSandboxDirectory:[self.mountSanboxDirectory stringByAppendingFormat:@"/%@",object]];
        
                rowModel.text  = [filePath stringByAppendingFormat:@"(%zd)",imageFileNames.count];
                
                [sandBoxSectionModel.rowModels addObject:rowModel];
            }
            
            [rowModel release];
        }
        
        //////////////////////////////////////////////////

        [sandBoxSectionModel release];
    }
    while (0);
}


@end
