//
//  AlbumImageFileController.m
//
//  Created by howard.lin on 13/3/14.
//  Copyright (c) 2013年 penpower. All rights reserved.
//

#import "AlbumImageFileController.h"
#import "PPSectionModel.h"
#import "PHFetchOptionsHelper.h"
#import "PHAsset+Image.h"
#import "PHAssetCollection+Image.h"

@implementation AlbumImageFileController

////////////////////////////////////////////////////////////////////////////////////////////////////

//NSConditionLock 使用
typedef NS_ENUM(NSUInteger, task)
{
    taskReading,
    taskFinished
};

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method


//================================================================================
//
//================================================================================
+ (NSMutableArray *)itemArrayWithAppSandboxDirectory:(NSString *)appSandboxDirectory
{
    NSArray *itemArray = nil;
    
    do
    {
        if(appSandboxDirectory==nil || appSandboxDirectory.length==0)
        {
            break;
        }
        
        BOOL isDir = NO;
        
        if([[NSFileManager defaultManager] fileExistsAtPath:appSandboxDirectory]==YES)
        {
            NSFileManager *fileManager = [NSFileManager defaultManager];
            
            if ([fileManager fileExistsAtPath:appSandboxDirectory isDirectory:&isDir] && isDir)
            {
                itemArray = [fileManager contentsOfDirectoryAtPath:appSandboxDirectory error:nil];
            }
        }
        
    } while (0);
    
    if (itemArray)
    {
        return [[[NSMutableArray alloc] initWithArray:itemArray] autorelease];
    }
    else
    {
        return nil;
    }
}


//================================================================================
//
//================================================================================
+ (UIImage *)imageFilePath:(NSString *)filePath withFileName:(NSString *)fileName
{
    NSString *pngFilePath = [NSString stringWithFormat:@"%@/%@",filePath, fileName];
    
    UIImage *image = [UIImage imageWithContentsOfFile:pngFilePath];
    
    return image;
}


//================================================================================
//
//================================================================================
+ (UIImage *)imageWithAbsolutePath:(NSString *)filePath
{
    UIImage *image = [UIImage imageWithContentsOfFile:filePath];
    return image;
}





////////////////////////////////////////////////////////////////////////////////////////////////////
#pragma mark - Photos framework


//================================================================================
//
//================================================================================
+ (PHPhotoLibrary *)defaultPhotoLibrary API_AVAILABLE(ios(8))
{
    
    return [PHPhotoLibrary sharedPhotoLibrary];
}


//================================================================================
//
//================================================================================
+ (NSMutableArray *)itemArrayWithAssetCollection:(PHAssetCollection*)assetCollection
{
    __block NSMutableArray *itemArray = [NSMutableArray array];
    
    do
    {
        if(assetCollection==nil)
        {
            break;
        }
        
        PHFetchOptions *assetFetchOptions = [PHFetchOptionsHelper photosFetchOptions];
        PHFetchResult *assetResult = [PHAsset fetchAssetsInAssetCollection:assetCollection options:assetFetchOptions];

        for (PHAsset *asset in assetResult)
        {
            [itemArray addObject:asset];
        }

    } while (0);
    
    return itemArray;
}


//==============================================================================
//
//==============================================================================
+ (void)fetchPosterImageWithAssetCollection:(PHAssetCollection *)assetCollection  completeHandler:(void(^)(UIImage *result))completeHandler
{
    [assetCollection fetchPosterImageWithcompleteHandler:completeHandler];
//    PHFetchOptions *fetchOption = [PHFetchOptionsHelper photosFetchOptions];
//    // 相簿圖片，只取一張
//    fetchOption.fetchLimit = 1;
//
//    PHFetchResult *fetchResult = [PHAsset fetchKeyAssetsInAssetCollection:assetCollection options:fetchOption];
//
//    if(fetchResult==nil)
//    {
//        if(completeHandler)
//        {
//            //////////////////////////////////////////////////
//            dispatch_async(dispatch_get_main_queue(), ^{
//                completeHandler(nil);
//            });
//        }
//
//        return ;
//    }
//
//    //////////////////////////////////////////////////
//    PHAsset *asset = [fetchResult firstObject];
//
//    [self fetchThumbnailImageWithPHAsset:asset completeHandler:completeHandler];
}


//==============================================================================
//
//==============================================================================
+ (void)fetchImageWithPHAsset:(PHAsset *)asset targetSize:(CGSize)targetSize completeHandler:(void(^)(UIImage *result))completeHandler
{
    if(asset==nil)
    {
        if(completeHandler)
        {
            //////////////////////////////////////////////////
            dispatch_async(dispatch_get_main_queue(), ^{
                completeHandler(nil);
            });
        }
        return;
    }
    
    [asset fetchImageWithTargetSize:targetSize completeHandler:completeHandler];
//    //////////////////////////////////////////////////
//    dispatch_async(dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0), ^{
//
//        PHImageRequestOptions *imageRequestOptions = [[[PHImageRequestOptions alloc] init] autorelease];
//        imageRequestOptions.resizeMode = PHImageRequestOptionsResizeModeExact;
//        imageRequestOptions.deliveryMode = PHImageRequestOptionsDeliveryModeHighQualityFormat;
//        imageRequestOptions.networkAccessAllowed = YES;
//        imageRequestOptions.synchronous = YES;
//
//        [[PHImageManager defaultManager] requestImageForAsset:asset targetSize:targetSize contentMode:PHImageContentModeAspectFill options:imageRequestOptions resultHandler:^(UIImage * _Nullable result, NSDictionary * _Nullable info) {
//
//            if(completeHandler)
//            {
//                //////////////////////////////////////////////////
//                dispatch_async(dispatch_get_main_queue(), ^{
//                    completeHandler(result);
//                });
//            }
//        }];
//
//    });
    
}


//==============================================================================
//
//==============================================================================
+ (void)fetchThumbnailImageWithPHAsset:(PHAsset *)asset completeHandler:(void(^)(UIImage *result))completeHandler
{
    [[self class] fetchImageWithPHAsset:asset targetSize:CGSizeMake(150,150) completeHandler:completeHandler];
}

@end
