//
//  PP3rdPartyLoginViewController.m
//  
//
//  Created by Howard on 2019/6/25.
//

#import "PP3rdPartyLoginViewController.h"

// Category
#import "PPButton+Factory.h"
#import "NSError+Custom.h"
#import "NSString+Additions.h"
#import "UIColor+HexString.h"

// Controller
#import "PPNavigationController.h"
#import "PPAlertController.h"


#define PP3rdLVC_MLS_Retry [@"MLS_Retry" localized]
#define PP3rdLVC_MLS_FailedToConnectServer [@"MLS_FailedToConnectServer" localized]

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface PP3rdPartyLoginViewController ()
<
PPButtonDelegate
>
@property (nonatomic, retain, readwrite) PPButton *ppButtonBack;
@property (nonatomic, retain, readwrite) PPNavigationBarView *ppNavigationBarView;
@property (nonatomic, retain) NSArray *layoutConstraints;
@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implementation

@implementation PP3rdPartyLoginViewController

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.clientID = nil;
    self.secretID = nil;
    self.redirectURL = nil;
    self.loginCompletion = nil;
    
    //////////////////////////////////////////////////

    [_loginView release];
    _loginView = nil;
    
    [_ppButtonBack release];
    _ppButtonBack = nil;
    
    [_ppNavigationBarView release];
    _ppNavigationBarView = nil;
    
    [_layoutConstraints release];
    _layoutConstraints = nil;
    
    [_titleString release];
    _titleString = nil;
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - view controller life cycle

//==============================================================================
//
//==============================================================================
- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
    
    //////////////////////////////////////////////////
    
    [self prepareMainUI];
}


//==============================================================================
//
//==============================================================================
- (void)viewDidDisappear:(BOOL)animated
{
    [self removeMainUI];
    
    //////////////////////////////////////////////////
    
    [super viewDidDisappear:animated];
}


//==============================================================================
//
//==============================================================================
- (void)updateViewConstraints
{
    [super updateViewConstraints];
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)viewSafeAreaInsetsDidChange
{
    [super viewSafeAreaInsetsDidChange];
    //////////////////////////////////////////////////
    [self resetLayoutConstraints];
    [self.ppNavigationBarView layoutSubviews];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - prepare ui

//==============================================================================
//
//==============================================================================
- (void)prepareMainUI
{
    // !! TODO: 目前先直接套用WorldCard的style, 之後要想一個可以給外部客制化的機制
    if (self.isLaunchPage==NO)
    {
        if(self.ppButtonBack==nil)
        {
            self.ppButtonBack = [PPButton ppButtonWithIconImageName:ImageNamePPButtonIconForSystemBackImitation
                                                                tag:0
                                                           delegate:self
                                              normalBackgroundColor:nil
                                         highlightedBackgroundColor:[UIColor colorWithHexString:@"#2c538f"]
                                                    imageEdgeInsets:UIEdgeInsetsMake(10, 10, 10, 10)];
        }
    }

    //////////////////////////////////////////////////
    
    if(_ppNavigationBarView==nil)
    {
        _ppNavigationBarView = [[PPNavigationBarView alloc] initWithFrame:self.navigationController.navigationBar.bounds];
    }
    
    if (self.ppNavigationBarView)
    {
        
        [self.ppNavigationBarView setStyle:PPBarViewStyle_CenteredAbsolute];
        
        [self.ppNavigationBarView.titleLabel setText:self.titleString];

        //////////////////////////////////////////////////
        if (self.ppButtonBack)
        {
            PPBarViewItemModel * itemModel = [PPBarViewItemModel ppBarViewItemModelWithView:self.ppButtonBack];
            itemModel.edgeInsetsForNormalBar = UIEdgeInsetsZero;
            
            [self.ppNavigationBarView  setItemModels:@[itemModel] forBlockType:PPBarViewBlockType_Left];
        }
        
        //////////////////////////////////////////////////
        if (self.navigationController!=nil)
        {
            self.navigationItem.leftBarButtonItem = [[[UIBarButtonItem alloc] initWithCustomView:self.ppNavigationBarView] autorelease];
        }
    }
    
    //////////////////////////////////////////////////

    if(self.loginView!=nil)
    {
        [self.loginView setTranslatesAutoresizingMaskIntoConstraints:NO];
        
        [self.view addSubview:self.loginView];
    }
    
    //////////////////////////////////////////////////
    [self.view setNeedsUpdateConstraints];
}


//==============================================================================
//
//==============================================================================
- (void)removeMainUI
{
    [self removeLayoutConstraints];
    
    //////////////////////////////////////////////////
    
    [self.loginView removeFromSuperview];
    self.loginView = nil;
    
    //////////////////////////////////////////////////
    
    self.navigationItem.leftBarButtonItem = nil;
    
    self.ppNavigationBarView = nil;
    self.ppButtonBack = nil;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - layout constraints

//==============================================================================
//
//==============================================================================
- (void)resetLayoutConstraints
{
    if(self.loginView==nil)
    {
        return ;
    }
    [self removeLayoutConstraints];
    //////////////////////////////////////////////////
    
    NSDictionary *views = @{@"loginView":self.loginView};
    // 這邊不知道是為什麼，先設為0
    NSInteger topMargin = 0;
//
//    if ([[UIApplication sharedApplication] isStatusBarHidden]==NO)
//    {
//        topMargin += 20;
//    }
//
//    if(self.navigationController==nil)
//    {
//        topMargin += PPBarViewDefaultHeightForToolBar;
//    }
    
    NSDictionary *metrics = @{@"topMargin":@(topMargin)};
    
    NSMutableArray *layoutConstraints = [NSMutableArray array];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"H:|[loginView]|"
                                                                                   options:NSLayoutFormatDirectionLeftToRight
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    [layoutConstraints addObjectsFromArray:[NSLayoutConstraint constraintsWithVisualFormat:@"V:|-(topMargin)-[loginView]|"
                                                                                   options:NSLayoutFormatDirectionLeadingToTrailing
                                                                                   metrics:metrics
                                                                                     views:views]];
    
    //////////////////////////////////////////////////
    
    if ([layoutConstraints count])
    {
        self.layoutConstraints = [NSArray arrayWithArray:layoutConstraints];
        [self.view addConstraints:self.layoutConstraints];
//        [self.view layoutIfNeeded];
    }
}


//==============================================================================
//
//==============================================================================
- (void)removeLayoutConstraints
{
    if (self.layoutConstraints)
    {
        [self.view removeConstraints:self.layoutConstraints];
        self.layoutConstraints = nil;
    }
}






////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - PPButtonDelegate

//==============================================================================
//
//==============================================================================
- (void)ppButton:(PPButton *)ppButton controlEvent:(UIControlEvents)controlEvent
{
    [self goBackAnimated:YES];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showAuthWithClientID:(NSString *)clientID
                    secretID:(NSString *)secretID
                 redirectURL:(NSString *)redirectURL
         superViewController:(UIViewController *)superViewController
                  completion:(AuthCompletion)completion
{
    NSAssert([clientID length]>0, @"clientID is nil");
    
    self.clientID = clientID;
    self.secretID = secretID;
    self.redirectURL = redirectURL;
    self.loginCompletion = completion;
    
    //////////////////////////////////////////////////

    if(superViewController.navigationController)
    {
        [superViewController.navigationController pushViewController:self animated:YES];
    }
    else
    {
        PPNavigationController *navigationController = [[PPNavigationController alloc] initWithRootViewController:self];
       
        [superViewController presentViewController:navigationController animated:YES completion:nil];
        
        [navigationController release];
    }
}

//================================================================================
//
//================================================================================
- (void)showRetryAlertWithError:(NSError *)error
{
    do
    {
        if(error==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        // 錯誤處理
        NSError *networkError = [error findNetworkError];
        NSString *errorMessage = nil;
        if (networkError!=nil)
        {
            errorMessage = PP3rdLVC_MLS_FailedToConnectServer;
        }
        else
        {
//            NSString *salesforceMessage = [error salesforceMessage];
//
//            if ([salesforceMessage length]>0)
//            {
//                errorMessage = [NSString stringWithFormat:PPSFLVC_MLS_LoginFailedWithApiAccessProblem, salesforceMessage];
//            }
//            else
            {
                errorMessage = [error alertMessage];
            }
        }
        //////////////////////////////////////////////////
        PPAlertController *alertController = [PPAlertController alertControllerWithTitle:@""
                                                                                 message:errorMessage
                                                                          preferredStyle:UIAlertControllerStyleAlert];
        
        //////////////////////////////////////////////////
        __block typeof(self) blockSelf = self;
        
        [alertController addAction:[UIAlertAction actionWithTitle:PP3rdLVC_MLS_Retry
                                                            style:UIAlertActionStyleDefault
                                                          handler:^(UIAlertAction * _Nonnull action) {
                                                              [blockSelf reloadWebView];
                                                          }]];
        [self presentViewController:alertController animated:YES completion:nil];
    }
    while (0);
}


//==============================================================================
//
//==============================================================================
- (void)reloadWebView
{
    [self.loginView reloadOriginalUrl];
}
@end
