//
//  PP3rdPartyLoginFlowController.h
//
//
//  Created by Howard on 2019/6/4.
//

#import <Foundation/Foundation.h>

// Define
#import "CrossPlatformDefine.h"
#import "PP3rdPartyLoginFlowController+ParameterDefine.h"

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface PP3rdPartyLoginFlowController : NSObject

/// 如果是App的進入點，就不能有返回，default NO
@property (nonatomic, assign) BOOL isLaunchPage;

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (PP3rdPartyLoginFlowController *)sharePartyLoginFlowController;

+ (void)isLoginWithType:(P3PLFC_LoginType)loginWithType
      completionHandler:(P3PLFCBOOLCompleteHandler)completionHandler;

+ (void)logoutWithType:(P3PLFC_LoginType)loginWithType;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Login Method

- (void)loginWithType:(P3PLFC_LoginType)loginWithType
                appID:(NSString *)appID
             secretID:(NSString *)secretID
          redirectURL:(NSString *)redirectURL
  superViewController:(CPViewController *)viewController
    completionHandler:(SignInCompleteHandler)completionHandler;

- (void)loginWithType:(P3PLFC_LoginType)loginWithType
                appID:(NSString *)appID
             secretID:(NSString *)secretID
          redirectURL:(NSString *)redirectURL
  superViewController:(CPViewController *)viewController
    permissionHandler:(CheckPermissionCompleteHandler)permissionHandler
    completionHandler:(SignInCompleteHandler)completionHandler;

- (void)loginByAppleIDFromSuperViewController:(CPViewController *)superViewController
                            completionHandler:(SignInCompleteHandler)completionHandler;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Weixi Method
#if  TARGET_OS_IOS
/*! @brief 处理微信通过Universal Link启动App时传递的数据
*
* 需要在 application:continueUserActivity:restorationHandler:中调用。
* @param userActivity 微信启动第三方应用时系统API传递过来的userActivity
* @return 成功返回YES，失败返回NO。
*/
- (BOOL)weixiHandleOpenUniversalLink:(NSUserActivity *)userActivity;


/*! @brief 处理旧版微信通过URL启动App时传递的数据
*
* 需要在 application:openURL:sourceApplication:annotation:或者application:handleOpenURL中调用。
* @param url 微信启动第三方应用时传递过来的URL
* @return 成功返回YES，失败返回NO。
*/
- (BOOL)weixihandleOpenURL:(NSURL *)url;

#endif
@end
