//
//  PPWeChatController.m
//  AppAuth
//
//  Created by Howard on 2020/4/17.
//

#import "PPWeChatController.h"

static NSString *  const PPWeChatLoginViewAPI_AccessToken = @"https://api.weixin.qq.com/sns/oauth2/access_token";

@implementation PPWeChatController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.clientID = nil;
    self.secretID = nil;
    
    //////////////////////////////////////////////////

    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)loadModelFromWeixiWithCode:(NSString *)code
                        completion:(void(^)(PP3rdPartyLoginModel *model))completion
{
    NSDictionary *object = nil;
    PP3rdPartyLoginModel *model = nil;
    
    NSError *returnError = nil;
    
    do
    {
        // 取得 accessToken
        NSString *requestTokenString = [NSString stringWithFormat:@"%@?appid=%@&secret=%@&code=%@&grant_type=authorization_code",PPWeChatLoginViewAPI_AccessToken,self.clientID,self.secretID,code];
        
        //////////////////////////////////////////////////
        
        //   GET     https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code
        
        NSURLResponse *response = nil;
        
        NSMutableURLRequest *urlRequest = [NSMutableURLRequest requestWithURL:[NSURL URLWithString:requestTokenString]];
        
        [urlRequest setHTTPMethod:@"GET"];
        
        NSData *downloadedData = [NSURLConnection sendSynchronousRequest:urlRequest returningResponse:&response error:&returnError];
        
        if(returnError!=nil)
        {
            break;
        }
        
        object = [NSJSONSerialization JSONObjectWithData:downloadedData options:NSJSONReadingMutableLeaves error:&returnError];
        
        NSString *guid = [object objectForKey:@"openid"];
        NSString *accessToken = [object objectForKey:@"access_token"];
        
        model = [PP3rdPartyLoginModel loginModelWithUserGuid:guid userName:nil email:nil accessToken:accessToken refreshToken:nil idToken:nil sourceObject:object];
    }
    while (0);
    
    if(completion!=nil)
    {
        completion(model);
    }
}

@end
