//
//  PPAppleLoginController.m
//  AppAuth
//
//  Created by Howard on 2019/11/27.
//

#import "PPAppleLoginController.h"

// Define
#import "PPAppleLoginController+SettingKeysDefine.h"

// Controller
#import "PPSettingsController.h"

// Category
#import "NSError+Custom.h"

@interface PPAppleLoginController ()
<
ASAuthorizationControllerDelegate,
ASAuthorizationControllerPresentationContextProviding
>
@property (nonatomic,assign) CPViewController *superViewController;
@property (nonatomic,copy) SignInCompleteHandler appleSignInCompleteHandler;

@end

@implementation PPAppleLoginController

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object

//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.appleSignInCompleteHandler = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ASAuthorizationControllerDelegate Method

//================================================================================
//
//=================================================================================
- (void)authorizationController:(ASAuthorizationController *)controller didCompleteWithError:(NSError *)error
API_AVAILABLE(ios(13.0),macos(10.15)){
    if(self.appleSignInCompleteHandler!=nil)
    {
        self.appleSignInCompleteHandler(nil, error);
    }
}


//================================================================================
//
//================================================================================
- (void)authorizationController:(ASAuthorizationController *)controller didCompleteWithAuthorization:(ASAuthorization *)authorization
API_AVAILABLE(ios(13.0),macos(10.15)){
    if([authorization.credential isKindOfClass:[ASAuthorizationAppleIDCredential class]]==YES)
    {
        ASAuthorizationAppleIDCredential *credential = authorization.credential;
        
        [PPSettingsController setStringValue:credential.user withKey:PPAppleLoginController_SettingKey_UserID];
        [PPSettingsController setStringValue:credential.email withKey:PPAppleLoginController_SettingKey_Email];
        
        if(credential.authorizationCode!=nil)
        {
            NSString *authorizationCode = [[NSString alloc] initWithData:credential.authorizationCode encoding:NSUTF8StringEncoding];
            
            [PPSettingsController setStringValue:authorizationCode withKey:PPAppleLoginController_SettingKey_AccessToken];
            
            [authorizationCode release];
        }
        
        if(credential.identityToken!=nil)
        {
            NSString *identityToken = [[NSString alloc] initWithData:credential.identityToken encoding:NSUTF8StringEncoding];
            
            [PPSettingsController setStringValue:identityToken withKey:PPAppleLoginController_SettingKey_idToken];
            
            [identityToken release];
        }
    }
    
    //////////////////////////////////////////////////
    
    if(self.appleSignInCompleteHandler!=nil)
    {
        self.appleSignInCompleteHandler([self partyLoginModelFromSettings], nil);
    }
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - ASAuthorizationControllerPresentationContextProviding Method

//================================================================================
//
//================================================================================
- (ASPresentationAnchor)presentationAnchorForAuthorizationController:(ASAuthorizationController *)controller
API_AVAILABLE(ios(13.0),macos(10.15))
{
    return self.superViewController.view.window;
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Method

//================================================================================
//
//================================================================================
- (void)sendAuthorizationWithProvider:(ASAuthorizationAppleIDProvider *)provider
API_AVAILABLE(ios(13.0),macos(10.15))
{
    do
    {
        ASAuthorizationAppleIDRequest *request = [provider createRequest];
        
        if(request==nil)
        {
            break;
        }
        
        request.requestedScopes = @[ASAuthorizationScopeFullName, ASAuthorizationScopeEmail];
        
        //////////////////////////////////////////////////
        
        ASAuthorizationController *authorizationController = [[[ASAuthorizationController alloc] initWithAuthorizationRequests:@[request]] autorelease];
        
        if(authorizationController==nil)
        {
            break;
        }
        
        authorizationController.delegate = self;
        authorizationController.presentationContextProvider = self;
        
        [authorizationController performRequests];
    }
    while (0);
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Private Model Method

//================================================================================
//
//================================================================================
- (PP3rdPartyLoginModel *)partyLoginModelFromSettings
{
    PP3rdPartyLoginModel *loginModel = [[PP3rdPartyLoginModel alloc] init];
    
    loginModel.userGuid = [PPSettingsController stringValueWithKey:PPAppleLoginController_SettingKey_UserID];
    loginModel.email = [PPSettingsController stringValueWithKey:PPAppleLoginController_SettingKey_Email];
    loginModel.accessToken = [PPSettingsController stringValueWithKey:PPAppleLoginController_SettingKey_AccessToken];
    loginModel.idToken = [PPSettingsController stringValueWithKey:PPAppleLoginController_SettingKey_idToken];
    
    return [loginModel autorelease];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

//================================================================================
//
//================================================================================
+ (ASAuthorizationAppleIDButton *)appleIDLoginButtonWithType:(ASAuthorizationAppleIDButtonType)type
                                                       style:(ASAuthorizationAppleIDButtonStyle)style
{
    return [ASAuthorizationAppleIDButton buttonWithType:type style:style];
}


//================================================================================
//
//================================================================================
+ (void)isLoginCompletionHandler:(P3PLFCBOOLCompleteHandler)completionHandler
API_AVAILABLE(ios(13.0),macos(10.15))
{
    do
    {
        if(completionHandler==nil)
        {
            break;
        }
        
        //////////////////////////////////////////////////
        
        NSString *userID = [PPSettingsController stringValueWithKey:PPAppleLoginController_SettingKey_UserID];
        
        if([userID length]<=0)
        {
            completionHandler(NO);
            
            break;
        }
        
        //////////////////////////////////////////////////
        
        ASAuthorizationAppleIDProvider *appleIDProvider = [[[ASAuthorizationAppleIDProvider alloc] init] autorelease];
        
        if(appleIDProvider==nil)
        {
            break;
        }
        //////////////////////////////////////////////////
        
        [appleIDProvider getCredentialStateForUserID:userID completion:^(ASAuthorizationAppleIDProviderCredentialState credentialState, NSError * _Nullable error) {
            
            if(credentialState==ASAuthorizationAppleIDProviderCredentialAuthorized)
            {
                dispatch_async(dispatch_get_main_queue(), ^{
                    completionHandler(YES);
                });
            }
            else
            {
                completionHandler(NO);
            }
        }];
    }
    while (0);
}


//================================================================================
//
//================================================================================
+ (void)logout
{
    [PPSettingsController removeValueWithKey:PPAppleLoginController_SettingKey_UserID];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)loginFromSuperViewController:(CPViewController *)superViewController
                   completionHandler:(SignInCompleteHandler)completionHandler
API_AVAILABLE(ios(13.0),macos(10.15))
{
    do
    {
        
        ASAuthorizationAppleIDProvider *appleIDProvider = [[[ASAuthorizationAppleIDProvider alloc] init] autorelease];
        
        if(appleIDProvider==nil)
        {
            break;
        }
        
        self.appleSignInCompleteHandler = completionHandler;
        
        //////////////////////////////////////////////////
        
        __block typeof(self) blockself = self;
        
        [PPAppleLoginController isLoginCompletionHandler:^(BOOL result) {
            
            if(result==NO)
            {
                [blockself sendAuthorizationWithProvider:appleIDProvider];
            }
            else if(blockself.appleSignInCompleteHandler!=nil)
            {
                blockself.appleSignInCompleteHandler([blockself partyLoginModelFromSettings], nil);
            }
        }];
    }while (0);
}

@end
