//
//  PPAppleLoginController.h
//  AppAuth
//
//  Created by Howard on 2019/11/27.
//

#import <Foundation/Foundation.h>

// Framework
#import <AuthenticationServices/AuthenticationServices.h>

// Define
#import "CrossPlatformDefine.h"
#import "PP3rdPartyLoginFlowController+ParameterDefine.h"

@interface PPAppleLoginController : NSObject

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Class Method

+ (ASAuthorizationAppleIDButton *)appleIDLoginButtonWithType:(ASAuthorizationAppleIDButtonType)type
                                                       style:(ASAuthorizationAppleIDButtonStyle)style API_AVAILABLE(ios(13.0),macos(10.15));

+ (void)isLoginCompletionHandler:(P3PLFCBOOLCompleteHandler)completionHandler API_AVAILABLE(ios(13.0),macos(10.15));

+ (void)logout;





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

- (void)loginFromSuperViewController:(CPViewController *)superViewController
                   completionHandler:(SignInCompleteHandler)completionHandler API_AVAILABLE(ios(13.0),macos(10.15));
                
@end
