//
//  PP3rdPartyLoginView.m
//  
//
//  Created by Howard on 2019/6/10.
//

#import "PP3rdPartyLoginView.h"

// Category
#import "NSError+Custom.h"





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Interface

@interface PP3rdPartyLoginView()

@end





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Implemetation

@implementation PP3rdPartyLoginView

////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Creating, Copying, and Dellocating Object Method

//================================================================================
//
//================================================================================
- (id)init
{
    if(self = [super init])
    {
        self.navigationDelegate = self;
    }
    
    return self;
}


//================================================================================
//
//================================================================================
- (void)dealloc
{
    self.clientID = nil;
    self.secretID = nil;
    self.authCompletion = nil;
    
    //////////////////////////////////////////////////
    
    [super dealloc];
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Inherit Method


//==============================================================================
//
//==============================================================================
- (BOOL)shouldReloadPageWithRedirectURL:(NSString *)requestUrlString
{
    return NO;
}

//================================================================================
//
//================================================================================
- (BOOL)isRedirectURL:(NSString *)requestUrlString
{
    return NO;
}


//================================================================================
//
//================================================================================
- (void)handleUserAgentResponse:(NSURL *)url
{
   
}


//==============================================================================
//
//==============================================================================
- (void)reloadOriginalUrl
{
    
}







////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - WKNavigationDelegate (User-Agent Token Flow)

//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView decidePolicyForNavigationAction:(WKNavigationAction *)navigationAction decisionHandler:(void (^)(WKNavigationActionPolicy))decisionHandler
{
#ifdef DEBUG
    //    NSLog(@"%s - %@", __PRETTY_FUNCTION__, navigationAction);
#endif
    
    if (navigationAction.navigationType==WKNavigationTypeLinkActivated)
    {
        decisionHandler(WKNavigationActionPolicyCancel);
        [self loadRequest:navigationAction.request];
        return ;
    }
    
    //////////////////////////////////////////////////
    NSURL *url = navigationAction.request.URL;
    
    NSString *requestUrl = [url absoluteString];

    if ([self isRedirectURL:requestUrl])
    {
        // 先call decisionHandler, 再做後面的動作，不然如果handleUserAgentResponse進到結束流程，這邊會當掉
        
        decisionHandler(WKNavigationActionPolicyCancel);
        
        [self handleUserAgentResponse:url];
    }
    else
    {
        decisionHandler(WKNavigationActionPolicyAllow);
    }
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView decidePolicyForNavigationResponse:(WKNavigationResponse *)navigationResponse decisionHandler:(void (^)(WKNavigationResponsePolicy))decisionHandler
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    decisionHandler(WKNavigationResponsePolicyAllow);
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didStartProvisionalNavigation:(WKNavigation *)navigation
{
    //    [self setBusy:@(YES)];
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didReceiveServerRedirectForProvisionalNavigation:(null_unspecified WKNavigation *)navigation
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailProvisionalNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
#ifdef DEBUG
    NSLog(@"%s = %@", __PRETTY_FUNCTION__, error);
#endif
    
    if ([error.domain isEqualToString:NSURLErrorDomain] && error.code == NSURLErrorCancelled)
    {
        // NSURLErrorCancelled is reported when a page has a redirect OR if you load
        // a new URL in the WebView before the previous one came back. We can just
        // ignore these since they aren't real errors.
        // http://stackoverflow.com/questions/1024748/how-do-i-fix-nsurlerrordomain-error-999-in-iphone-3-0-os
        return;
    }

    if(self.authCompletion)
    {
        self.authCompletion(nil, error);
    }
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didCommitNavigation:(null_unspecified WKNavigation *)navigation
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFinishNavigation:(WKNavigation *)navigation
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    //    [self setBusy:@(NO)];
    
}


//==============================================================================
//
//==============================================================================
- (void)webView:(WKWebView *)webView didFailNavigation:(WKNavigation *)navigation withError:(NSError *)error
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
    
    //    [self setBusy:@(NO)];
    if ([error.domain isEqualToString:NSURLErrorDomain] && error.code == NSURLErrorCancelled)
    {
        // NSURLErrorCancelled is reported when a page has a redirect OR if you load
        // a new URL in the WebView before the previous one came back. We can just
        // ignore these since they aren't real errors.
        // http://stackoverflow.com/questions/1024748/how-do-i-fix-nsurlerrordomain-error-999-in-iphone-3-0-os
        return;
    }
    
    if(self.authCompletion)
    {
        self.authCompletion(nil, error);
    }
}


//==============================================================================
//
//==============================================================================
//- (void)webView:(WKWebView *)webView didReceiveAuthenticationChallenge:(NSURLAuthenticationChallenge *)challenge completionHandler:(void (^)(NSURLSessionAuthChallengeDisposition disposition, NSURLCredential * _Nullable credential))completionHandler
//{
//#ifdef DEBUG
//    NSLog(@"%s", __PRETTY_FUNCTION__);
//#endif
//
//    completionHandler(NSURLSessionAuthChallengePerformDefaultHandling, nil);
//}


//==============================================================================
//
//==============================================================================
- (void)webViewWebContentProcessDidTerminate:(WKWebView *)webView
{
#ifdef DEBUG
    NSLog(@"%s", __PRETTY_FUNCTION__);
#endif
}





////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma mark - Instance Method

//================================================================================
//
//================================================================================
- (void)showAuthFlowFromRequest:(NSURLRequest *)request
                       clientID:(NSString *)clientID
                       secretID:(NSString *)secretID
                     completion:(AuthCompletion)completion
{
    NSAssert([clientID length]>0, @"clientID length is zero");
    
    NSError *returnError = nil;
    
    do
    {
        if(request==nil)
        {
            returnError = PPErrorParameterInvalidity(nil);
            break;
        }
        
        //////////////////////////////////////////////////
        
        self.clientID = clientID;
        self.secretID = secretID;
        self.authCompletion = completion;
        
        //////////////////////////////////////////////////
        
        [self loadRequest:request];
    }
    while (0);
    
    if(returnError!=nil &&
       completion!=nil)
    {
        completion(nil,returnError);
    }
}

@end
