///
/// Copyright (c) 2016 Dropbox, Inc. All rights reserved.
///
/// Auto-generated by Stone, do not modify.
///

#import <Foundation/Foundation.h>

#import "DBTasks.h"

@class DBACCOUNTPhotoSourceArg;
@class DBACCOUNTSetProfilePhotoError;
@class DBASYNCLaunchEmptyResult;
@class DBASYNCPollEmptyResult;
@class DBASYNCPollError;
@class DBFILEPROPERTIESAddTemplateResult;
@class DBFILEPROPERTIESGetTemplateResult;
@class DBFILEPROPERTIESListTemplateResult;
@class DBFILEPROPERTIESModifyTemplateError;
@class DBFILEPROPERTIESPropertyFieldTemplate;
@class DBFILEPROPERTIESPropertyType;
@class DBFILEPROPERTIESTemplateError;
@class DBFILEPROPERTIESUpdateTemplateResult;
@class DBFILESContentSyncSetting;
@class DBFILESContentSyncSettingArg;
@class DBFILESSyncSetting;
@class DBFILESSyncSettingArg;
@class DBFILESSyncSettingsError;
@class DBNilObject;
@class DBTEAMActiveWebSession;
@class DBTEAMAddSecondaryEmailsError;
@class DBTEAMAddSecondaryEmailsResult;
@class DBTEAMAdminTier;
@class DBTEAMApiApp;
@class DBTEAMCOMMONGroupManagementType;
@class DBTEAMCOMMONGroupSummary;
@class DBTEAMCustomQuotaError;
@class DBTEAMCustomQuotaResult;
@class DBTEAMDateRangeError;
@class DBTEAMDeleteSecondaryEmailsResult;
@class DBTEAMDesktopClientSession;
@class DBTEAMDeviceSessionArg;
@class DBTEAMDevicesActive;
@class DBTEAMExcludedUsersListContinueError;
@class DBTEAMExcludedUsersListError;
@class DBTEAMExcludedUsersListResult;
@class DBTEAMExcludedUsersUpdateError;
@class DBTEAMExcludedUsersUpdateResult;
@class DBTEAMExcludedUsersUpdateStatus;
@class DBTEAMFeature;
@class DBTEAMFeatureValue;
@class DBTEAMFeaturesGetValuesBatchError;
@class DBTEAMFeaturesGetValuesBatchResult;
@class DBTEAMGetActivityReport;
@class DBTEAMGetDevicesReport;
@class DBTEAMGetMembershipReport;
@class DBTEAMGetStorageReport;
@class DBTEAMGroupAccessType;
@class DBTEAMGroupCreateError;
@class DBTEAMGroupDeleteError;
@class DBTEAMGroupFullInfo;
@class DBTEAMGroupMemberInfo;
@class DBTEAMGroupMemberSetAccessTypeError;
@class DBTEAMGroupMembersAddError;
@class DBTEAMGroupMembersChangeResult;
@class DBTEAMGroupMembersRemoveError;
@class DBTEAMGroupSelector;
@class DBTEAMGroupSelectorError;
@class DBTEAMGroupUpdateError;
@class DBTEAMGroupsGetInfoError;
@class DBTEAMGroupsGetInfoItem;
@class DBTEAMGroupsListContinueError;
@class DBTEAMGroupsListResult;
@class DBTEAMGroupsMembersListContinueError;
@class DBTEAMGroupsMembersListResult;
@class DBTEAMGroupsPollError;
@class DBTEAMGroupsSelector;
@class DBTEAMLegalHoldHeldRevisionMetadata;
@class DBTEAMLegalHoldPolicy;
@class DBTEAMLegalHoldStatus;
@class DBTEAMLegalHoldsGetPolicyError;
@class DBTEAMLegalHoldsListHeldRevisionResult;
@class DBTEAMLegalHoldsListHeldRevisionsError;
@class DBTEAMLegalHoldsListPoliciesError;
@class DBTEAMLegalHoldsListPoliciesResult;
@class DBTEAMLegalHoldsPolicyCreateError;
@class DBTEAMLegalHoldsPolicyReleaseError;
@class DBTEAMLegalHoldsPolicyUpdateError;
@class DBTEAMListMemberAppsError;
@class DBTEAMListMemberAppsResult;
@class DBTEAMListMemberDevicesError;
@class DBTEAMListMemberDevicesResult;
@class DBTEAMListMembersAppsError;
@class DBTEAMListMembersAppsResult;
@class DBTEAMListMembersDevicesError;
@class DBTEAMListMembersDevicesResult;
@class DBTEAMListTeamAppsError;
@class DBTEAMListTeamAppsResult;
@class DBTEAMListTeamDevicesError;
@class DBTEAMListTeamDevicesResult;
@class DBTEAMMemberAccess;
@class DBTEAMMemberAddArg;
@class DBTEAMMemberAddResult;
@class DBTEAMMemberDevices;
@class DBTEAMMemberLinkedApps;
@class DBTEAMMemberProfile;
@class DBTEAMMembersAddJobStatus;
@class DBTEAMMembersAddLaunch;
@class DBTEAMMembersDeleteProfilePhotoError;
@class DBTEAMMembersGetInfoError;
@class DBTEAMMembersGetInfoItem;
@class DBTEAMMembersInfo;
@class DBTEAMMembersListContinueError;
@class DBTEAMMembersListError;
@class DBTEAMMembersListResult;
@class DBTEAMMembersRecoverError;
@class DBTEAMMembersRemoveError;
@class DBTEAMMembersSendWelcomeError;
@class DBTEAMMembersSetPermissionsError;
@class DBTEAMMembersSetPermissionsResult;
@class DBTEAMMembersSetProfileError;
@class DBTEAMMembersSetProfilePhotoError;
@class DBTEAMMembersSuspendError;
@class DBTEAMMembersTransferFormerMembersFilesError;
@class DBTEAMMembersUnsuspendError;
@class DBTEAMMobileClientSession;
@class DBTEAMNamespaceMetadata;
@class DBTEAMPOLICIESTeamMemberPolicies;
@class DBTEAMRemoveCustomQuotaResult;
@class DBTEAMResendVerificationEmailResult;
@class DBTEAMRevokeDesktopClientArg;
@class DBTEAMRevokeDeviceSessionArg;
@class DBTEAMRevokeDeviceSessionBatchError;
@class DBTEAMRevokeDeviceSessionBatchResult;
@class DBTEAMRevokeDeviceSessionError;
@class DBTEAMRevokeDeviceSessionStatus;
@class DBTEAMRevokeLinkedApiAppArg;
@class DBTEAMRevokeLinkedAppBatchError;
@class DBTEAMRevokeLinkedAppBatchResult;
@class DBTEAMRevokeLinkedAppError;
@class DBTEAMRevokeLinkedAppStatus;
@class DBTEAMSetCustomQuotaError;
@class DBTEAMStorageBucket;
@class DBTEAMTeamFolderAccessError;
@class DBTEAMTeamFolderActivateError;
@class DBTEAMTeamFolderArchiveError;
@class DBTEAMTeamFolderArchiveJobStatus;
@class DBTEAMTeamFolderArchiveLaunch;
@class DBTEAMTeamFolderCreateError;
@class DBTEAMTeamFolderGetInfoItem;
@class DBTEAMTeamFolderInvalidStatusError;
@class DBTEAMTeamFolderListContinueError;
@class DBTEAMTeamFolderListError;
@class DBTEAMTeamFolderListResult;
@class DBTEAMTeamFolderMetadata;
@class DBTEAMTeamFolderPermanentlyDeleteError;
@class DBTEAMTeamFolderRenameError;
@class DBTEAMTeamFolderStatus;
@class DBTEAMTeamFolderTeamSharedDropboxError;
@class DBTEAMTeamFolderUpdateSyncSettingsError;
@class DBTEAMTeamGetInfoResult;
@class DBTEAMTeamMemberInfo;
@class DBTEAMTeamMemberProfile;
@class DBTEAMTeamNamespacesListContinueError;
@class DBTEAMTeamNamespacesListError;
@class DBTEAMTeamNamespacesListResult;
@class DBTEAMTokenGetAuthenticatedAdminError;
@class DBTEAMTokenGetAuthenticatedAdminResult;
@class DBTEAMUserAddResult;
@class DBTEAMUserCustomQuotaArg;
@class DBTEAMUserCustomQuotaResult;
@class DBTEAMUserDeleteResult;
@class DBTEAMUserResendResult;
@class DBTEAMUserSecondaryEmailsArg;
@class DBTEAMUserSelectorArg;

@protocol DBTransportClient;

///
/// Routes for the `Team` namespace
///

NS_ASSUME_NONNULL_BEGIN

@interface DBTEAMTeamAuthRoutes : NSObject

/// An instance of the networking client that each route will use to submit a
/// request.
@property (nonatomic, readonly) id<DBTransportClient> client;

/// Initializes the `DBTEAMTeamAuthRoutes` namespace container object with a
/// networking client.
- (instancetype)init:(id<DBTransportClient>)client;

///
/// List all device sessions of a team's member.
///
/// @param teamMemberId The team's member id.
///
/// @return Through the response callback, the caller will receive a `DBTEAMListMemberDevicesResult` object on success
/// or a `DBTEAMListMemberDevicesError` object on failure.
///
- (DBRpcTask<DBTEAMListMemberDevicesResult *, DBTEAMListMemberDevicesError *> *)devicesListMemberDevices:
    (NSString *)teamMemberId;

///
/// List all device sessions of a team's member.
///
/// @param teamMemberId The team's member id.
/// @param includeWebSessions Whether to list web sessions of the team's member.
/// @param includeDesktopClients Whether to list linked desktop devices of the team's member.
/// @param includeMobileClients Whether to list linked mobile devices of the team's member.
///
/// @return Through the response callback, the caller will receive a `DBTEAMListMemberDevicesResult` object on success
/// or a `DBTEAMListMemberDevicesError` object on failure.
///
- (DBRpcTask<DBTEAMListMemberDevicesResult *, DBTEAMListMemberDevicesError *> *)
devicesListMemberDevices:(NSString *)teamMemberId
      includeWebSessions:(nullable NSNumber *)includeWebSessions
   includeDesktopClients:(nullable NSNumber *)includeDesktopClients
    includeMobileClients:(nullable NSNumber *)includeMobileClients;

///
/// List all device sessions of a team. Permission : Team member file access.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMListMembersDevicesResult` object on success
/// or a `DBTEAMListMembersDevicesError` object on failure.
///
- (DBRpcTask<DBTEAMListMembersDevicesResult *, DBTEAMListMembersDevicesError *> *)devicesListMembersDevices;

///
/// List all device sessions of a team. Permission : Team member file access.
///
/// @param cursor At the first call to the `devicesListMembersDevices` the cursor shouldn't be passed. Then, if the
/// result of the call includes a cursor, the following requests should include the received cursors in order to receive
/// the next sub list of team devices.
/// @param includeWebSessions Whether to list web sessions of the team members.
/// @param includeDesktopClients Whether to list desktop clients of the team members.
/// @param includeMobileClients Whether to list mobile clients of the team members.
///
/// @return Through the response callback, the caller will receive a `DBTEAMListMembersDevicesResult` object on success
/// or a `DBTEAMListMembersDevicesError` object on failure.
///
- (DBRpcTask<DBTEAMListMembersDevicesResult *, DBTEAMListMembersDevicesError *> *)
devicesListMembersDevices:(nullable NSString *)cursor
       includeWebSessions:(nullable NSNumber *)includeWebSessions
    includeDesktopClients:(nullable NSNumber *)includeDesktopClients
     includeMobileClients:(nullable NSNumber *)includeMobileClients;

///
/// DEPRECATED: List all device sessions of a team. Permission : Team member file access.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMListTeamDevicesResult` object on success or
/// a `DBTEAMListTeamDevicesError` object on failure.
///
- (DBRpcTask<DBTEAMListTeamDevicesResult *, DBTEAMListTeamDevicesError *> *)devicesListTeamDevices
    __deprecated_msg("devicesListTeamDevices is deprecated. Use devicesListMembersDevices.");

///
/// DEPRECATED: List all device sessions of a team. Permission : Team member file access.
///
/// @param cursor At the first call to the `devicesListTeamDevices` the cursor shouldn't be passed. Then, if the result
/// of the call includes a cursor, the following requests should include the received cursors in order to receive the
/// next sub list of team devices.
/// @param includeWebSessions Whether to list web sessions of the team members.
/// @param includeDesktopClients Whether to list desktop clients of the team members.
/// @param includeMobileClients Whether to list mobile clients of the team members.
///
/// @return Through the response callback, the caller will receive a `DBTEAMListTeamDevicesResult` object on success or
/// a `DBTEAMListTeamDevicesError` object on failure.
///
- (DBRpcTask<DBTEAMListTeamDevicesResult *, DBTEAMListTeamDevicesError *> *)
devicesListTeamDevices:(nullable NSString *)cursor
    includeWebSessions:(nullable NSNumber *)includeWebSessions
 includeDesktopClients:(nullable NSNumber *)includeDesktopClients
  includeMobileClients:(nullable NSNumber *)includeMobileClients
    __deprecated_msg("devicesListTeamDevices is deprecated. Use devicesListMembersDevices.");

///
/// Revoke a device session of a team's member.
///
/// @param revokeDeviceSessionArg The RevokeDeviceSessionArg union
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMRevokeDeviceSessionError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMRevokeDeviceSessionError *> *)devicesRevokeDeviceSession:
    (DBTEAMRevokeDeviceSessionArg *)revokeDeviceSessionArg;

///
/// Revoke a list of device sessions of team members.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMRevokeDeviceSessionBatchResult` object on
/// success or a `DBTEAMRevokeDeviceSessionBatchError` object on failure.
///
- (DBRpcTask<DBTEAMRevokeDeviceSessionBatchResult *, DBTEAMRevokeDeviceSessionBatchError *> *)
devicesRevokeDeviceSessionBatch:(NSArray<DBTEAMRevokeDeviceSessionArg *> *)revokeDevices;

///
/// Get the values for one or more featues. This route allows you to check your account's capability for what feature
/// you can access or what value you have for certain features. Permission : Team information.
///
/// @param features A list of features in Feature. If the list is empty, this route will return
/// FeaturesGetValuesBatchError.
///
/// @return Through the response callback, the caller will receive a `DBTEAMFeaturesGetValuesBatchResult` object on
/// success or a `DBTEAMFeaturesGetValuesBatchError` object on failure.
///
- (DBRpcTask<DBTEAMFeaturesGetValuesBatchResult *, DBTEAMFeaturesGetValuesBatchError *> *)featuresGetValues:
    (NSArray<DBTEAMFeature *> *)features;

///
/// Retrieves information about a team.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamGetInfoResult` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBTEAMTeamGetInfoResult *, DBNilObject *> *)getInfo;

///
/// Creates a new, empty group, with a requested name. Permission : Team member management.
///
/// @param groupName Group name.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupFullInfo` object on success or a
/// `DBTEAMGroupCreateError` object on failure.
///
- (DBRpcTask<DBTEAMGroupFullInfo *, DBTEAMGroupCreateError *> *)groupsCreate:(NSString *)groupName;

///
/// Creates a new, empty group, with a requested name. Permission : Team member management.
///
/// @param groupName Group name.
/// @param addCreatorAsOwner Automatically add the creator of the group.
/// @param groupExternalId The creator of a team can associate an arbitrary external ID to the group.
/// @param groupManagementType Whether the team can be managed by selected users, or only by team admins.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupFullInfo` object on success or a
/// `DBTEAMGroupCreateError` object on failure.
///
- (DBRpcTask<DBTEAMGroupFullInfo *, DBTEAMGroupCreateError *> *)
       groupsCreate:(NSString *)groupName
  addCreatorAsOwner:(nullable NSNumber *)addCreatorAsOwner
    groupExternalId:(nullable NSString *)groupExternalId
groupManagementType:(nullable DBTEAMCOMMONGroupManagementType *)groupManagementType;

///
/// Deletes a group. The group is deleted immediately. However the revoking of group-owned resources may take additional
/// time. Use the `groupsJobStatusGet` to determine whether this process has completed. Permission : Team member
/// management.
///
/// @param groupSelector Argument for selecting a single group, either by group_id or by external group ID.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBTEAMGroupDeleteError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBTEAMGroupDeleteError *> *)groupsDelete:(DBTEAMGroupSelector *)groupSelector;

///
/// Retrieves information about one or more groups. Note that the optional field  `members` in `DBTEAMGroupFullInfo` is
/// not returned for system-managed groups. Permission : Team Information.
///
/// @param groupsSelector Argument for selecting a list of groups, either by group_ids, or external group IDs.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMGroupsGetInfoItem *>` object on
/// success or a `DBTEAMGroupsGetInfoError` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMGroupsGetInfoItem *> *, DBTEAMGroupsGetInfoError *> *)groupsGetInfo:
    (DBTEAMGroupsSelector *)groupsSelector;

///
/// Once an async_job_id is returned from `groupsDelete`, `groupsMembersAdd` , or `groupsMembersRemove` use this method
/// to poll the status of granting/revoking group members' access to group-owned resources. Permission : Team member
/// management.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBASYNCPollEmptyResult` object on success or a
/// `DBTEAMGroupsPollError` object on failure.
///
- (DBRpcTask<DBASYNCPollEmptyResult *, DBTEAMGroupsPollError *> *)groupsJobStatusGet:(NSString *)asyncJobId;

///
/// Lists groups on a team. Permission : Team Information.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupsListResult` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBTEAMGroupsListResult *, DBNilObject *> *)groupsList;

///
/// Lists groups on a team. Permission : Team Information.
///
/// @param limit Number of results to return per call.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupsListResult` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBTEAMGroupsListResult *, DBNilObject *> *)groupsList:(nullable NSNumber *)limit;

///
/// Once a cursor has been retrieved from `groupsList`, use this to paginate through all groups. Permission : Team
/// Information.
///
/// @param cursor Indicates from what point to get the next set of groups.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupsListResult` object on success or a
/// `DBTEAMGroupsListContinueError` object on failure.
///
- (DBRpcTask<DBTEAMGroupsListResult *, DBTEAMGroupsListContinueError *> *)groupsListContinue:(NSString *)cursor;

///
/// Adds members to a group. The members are added immediately. However the granting of group-owned resources may take
/// additional time. Use the `groupsJobStatusGet` to determine whether this process has completed. Permission : Team
/// member management.
///
/// @param group Group to which users will be added.
/// @param members List of users to be added to the group.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupMembersChangeResult` object on success
/// or a `DBTEAMGroupMembersAddError` object on failure.
///
- (DBRpcTask<DBTEAMGroupMembersChangeResult *, DBTEAMGroupMembersAddError *> *)
groupsMembersAdd:(DBTEAMGroupSelector *)group
         members:(NSArray<DBTEAMMemberAccess *> *)members;

///
/// Adds members to a group. The members are added immediately. However the granting of group-owned resources may take
/// additional time. Use the `groupsJobStatusGet` to determine whether this process has completed. Permission : Team
/// member management.
///
/// @param group Group to which users will be added.
/// @param members List of users to be added to the group.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupMembersChangeResult` object on success
/// or a `DBTEAMGroupMembersAddError` object on failure.
///
- (DBRpcTask<DBTEAMGroupMembersChangeResult *, DBTEAMGroupMembersAddError *> *)
groupsMembersAdd:(DBTEAMGroupSelector *)group
         members:(NSArray<DBTEAMMemberAccess *> *)members
   returnMembers:(nullable NSNumber *)returnMembers;

///
/// Lists members of a group. Permission : Team Information.
///
/// @param group The group whose members are to be listed.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupsMembersListResult` object on success
/// or a `DBTEAMGroupSelectorError` object on failure.
///
- (DBRpcTask<DBTEAMGroupsMembersListResult *, DBTEAMGroupSelectorError *> *)groupsMembersList:
    (DBTEAMGroupSelector *)group;

///
/// Lists members of a group. Permission : Team Information.
///
/// @param group The group whose members are to be listed.
/// @param limit Number of results to return per call.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupsMembersListResult` object on success
/// or a `DBTEAMGroupSelectorError` object on failure.
///
- (DBRpcTask<DBTEAMGroupsMembersListResult *, DBTEAMGroupSelectorError *> *)
groupsMembersList:(DBTEAMGroupSelector *)group
            limit:(nullable NSNumber *)limit;

///
/// Once a cursor has been retrieved from `groupsMembersList`, use this to paginate through all members of the group.
/// Permission : Team information.
///
/// @param cursor Indicates from what point to get the next set of groups.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupsMembersListResult` object on success
/// or a `DBTEAMGroupsMembersListContinueError` object on failure.
///
- (DBRpcTask<DBTEAMGroupsMembersListResult *, DBTEAMGroupsMembersListContinueError *> *)groupsMembersListContinue:
    (NSString *)cursor;

///
/// Removes members from a group. The members are removed immediately. However the revoking of group-owned resources may
/// take additional time. Use the `groupsJobStatusGet` to determine whether this process has completed. This method
/// permits removing the only owner of a group, even in cases where this is not possible via the web client. Permission
/// : Team member management.
///
/// @param group Group from which users will be removed.
/// @param users List of users to be removed from the group.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupMembersChangeResult` object on success
/// or a `DBTEAMGroupMembersRemoveError` object on failure.
///
- (DBRpcTask<DBTEAMGroupMembersChangeResult *, DBTEAMGroupMembersRemoveError *> *)
groupsMembersRemove:(DBTEAMGroupSelector *)group
              users:(NSArray<DBTEAMUserSelectorArg *> *)users;

///
/// Removes members from a group. The members are removed immediately. However the revoking of group-owned resources may
/// take additional time. Use the `groupsJobStatusGet` to determine whether this process has completed. This method
/// permits removing the only owner of a group, even in cases where this is not possible via the web client. Permission
/// : Team member management.
///
/// @param group Group from which users will be removed.
/// @param users List of users to be removed from the group.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupMembersChangeResult` object on success
/// or a `DBTEAMGroupMembersRemoveError` object on failure.
///
- (DBRpcTask<DBTEAMGroupMembersChangeResult *, DBTEAMGroupMembersRemoveError *> *)
groupsMembersRemove:(DBTEAMGroupSelector *)group
              users:(NSArray<DBTEAMUserSelectorArg *> *)users
      returnMembers:(nullable NSNumber *)returnMembers;

///
/// Sets a member's access type in a group. Permission : Team member management.
///
/// @param accessType New group access type the user will have.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMGroupsGetInfoItem *>` object on
/// success or a `DBTEAMGroupMemberSetAccessTypeError` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMGroupsGetInfoItem *> *, DBTEAMGroupMemberSetAccessTypeError *> *)
groupsMembersSetAccessType:(DBTEAMGroupSelector *)group
                      user:(DBTEAMUserSelectorArg *)user
                accessType:(DBTEAMGroupAccessType *)accessType;

///
/// Sets a member's access type in a group. Permission : Team member management.
///
/// @param accessType New group access type the user will have.
/// @param returnMembers Whether to return the list of members in the group.  Note that the default value will cause all
/// the group members  to be returned in the response. This may take a long time for large groups.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMGroupsGetInfoItem *>` object on
/// success or a `DBTEAMGroupMemberSetAccessTypeError` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMGroupsGetInfoItem *> *, DBTEAMGroupMemberSetAccessTypeError *> *)
groupsMembersSetAccessType:(DBTEAMGroupSelector *)group
                      user:(DBTEAMUserSelectorArg *)user
                accessType:(DBTEAMGroupAccessType *)accessType
             returnMembers:(nullable NSNumber *)returnMembers;

///
/// Updates a group's name and/or external ID. Permission : Team member management.
///
/// @param group Specify a group.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupFullInfo` object on success or a
/// `DBTEAMGroupUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMGroupFullInfo *, DBTEAMGroupUpdateError *> *)groupsUpdate:(DBTEAMGroupSelector *)group;

///
/// Updates a group's name and/or external ID. Permission : Team member management.
///
/// @param group Specify a group.
/// @param dNewGroupName Optional argument. Set group name to this if provided.
/// @param dNewGroupExternalId Optional argument. New group external ID. If the argument is None, the group's
/// external_id won't be updated. If the argument is empty string, the group's external id will be cleared.
/// @param dNewGroupManagementType Set new group management type, if provided.
///
/// @return Through the response callback, the caller will receive a `DBTEAMGroupFullInfo` object on success or a
/// `DBTEAMGroupUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMGroupFullInfo *, DBTEAMGroupUpdateError *> *)
           groupsUpdate:(DBTEAMGroupSelector *)group
          returnMembers:(nullable NSNumber *)returnMembers
          dNewGroupName:(nullable NSString *)dNewGroupName
    dNewGroupExternalId:(nullable NSString *)dNewGroupExternalId
dNewGroupManagementType:(nullable DBTEAMCOMMONGroupManagementType *)dNewGroupManagementType;

///
/// Creates new legal hold policy. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team
/// member file access.
///
/// @param name Policy name.
/// @param members List of team member IDs added to the hold.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldPolicy` object on success or a
/// `DBTEAMLegalHoldsPolicyCreateError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldPolicy *, DBTEAMLegalHoldsPolicyCreateError *> *)
legalHoldsCreatePolicy:(NSString *)name
               members:(NSArray<NSString *> *)members;

///
/// Creates new legal hold policy. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team
/// member file access.
///
/// @param name Policy name.
/// @param description_ A description of the legal hold policy.
/// @param members List of team member IDs added to the hold.
/// @param startDate start date of the legal hold policy.
/// @param endDate end date of the legal hold policy.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldPolicy` object on success or a
/// `DBTEAMLegalHoldsPolicyCreateError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldPolicy *, DBTEAMLegalHoldsPolicyCreateError *> *)
legalHoldsCreatePolicy:(NSString *)name
               members:(NSArray<NSString *> *)members
          description_:(nullable NSString *)description_
             startDate:(nullable NSDate *)startDate
               endDate:(nullable NSDate *)endDate;

///
/// Gets a legal hold by Id. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team
/// member file access.
///
/// @param id_ The legal hold Id.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldPolicy` object on success or a
/// `DBTEAMLegalHoldsGetPolicyError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldPolicy *, DBTEAMLegalHoldsGetPolicyError *> *)legalHoldsGetPolicy:(NSString *)id_;

///
/// List the file metadata that's under the hold. Note: Legal Holds is a paid add-on. Not all teams have the feature.
/// Permission : Team member file access.
///
/// @param id_ The legal hold Id.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldsListHeldRevisionResult` object on
/// success or a `DBTEAMLegalHoldsListHeldRevisionsError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldsListHeldRevisionResult *, DBTEAMLegalHoldsListHeldRevisionsError *> *)
legalHoldsListHeldRevisions:(NSString *)id_;

///
/// Continue listing the file metadata that's under the hold. Note: Legal Holds is a paid add-on. Not all teams have the
/// feature. Permission : Team member file access.
///
/// @param id_ The legal hold Id.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldsListHeldRevisionResult` object on
/// success or a `DBTEAMLegalHoldsListHeldRevisionsError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldsListHeldRevisionResult *, DBTEAMLegalHoldsListHeldRevisionsError *> *)
legalHoldsListHeldRevisionsContinue:(NSString *)id_;

///
/// Continue listing the file metadata that's under the hold. Note: Legal Holds is a paid add-on. Not all teams have the
/// feature. Permission : Team member file access.
///
/// @param id_ The legal hold Id.
/// @param cursor The cursor idicates where to continue reading file metadata entries for the next API call. When there
/// are no more entries, the cursor will return none.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldsListHeldRevisionResult` object on
/// success or a `DBTEAMLegalHoldsListHeldRevisionsError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldsListHeldRevisionResult *, DBTEAMLegalHoldsListHeldRevisionsError *> *)
legalHoldsListHeldRevisionsContinue:(NSString *)id_
                             cursor:(nullable NSString *)cursor;

///
/// Lists legal holds on a team. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team
/// member file access.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldsListPoliciesResult` object on
/// success or a `DBTEAMLegalHoldsListPoliciesError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldsListPoliciesResult *, DBTEAMLegalHoldsListPoliciesError *> *)legalHoldsListPolicies;

///
/// Lists legal holds on a team. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team
/// member file access.
///
/// @param includeReleased Whether to return holds that were released.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldsListPoliciesResult` object on
/// success or a `DBTEAMLegalHoldsListPoliciesError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldsListPoliciesResult *, DBTEAMLegalHoldsListPoliciesError *> *)legalHoldsListPolicies:
    (nullable NSNumber *)includeReleased;

///
/// Releases a legal hold by Id. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team
/// member file access.
///
/// @param id_ The legal hold Id.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMLegalHoldsPolicyReleaseError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMLegalHoldsPolicyReleaseError *> *)legalHoldsReleasePolicy:(NSString *)id_;

///
/// Updates a legal hold. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team member
/// file access.
///
/// @param id_ The legal hold Id.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldPolicy` object on success or a
/// `DBTEAMLegalHoldsPolicyUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldPolicy *, DBTEAMLegalHoldsPolicyUpdateError *> *)legalHoldsUpdatePolicy:(NSString *)id_;

///
/// Updates a legal hold. Note: Legal Holds is a paid add-on. Not all teams have the feature. Permission : Team member
/// file access.
///
/// @param id_ The legal hold Id.
/// @param name Policy new name.
/// @param description_ Policy new description.
/// @param members List of team member IDs to apply the policy on.
///
/// @return Through the response callback, the caller will receive a `DBTEAMLegalHoldPolicy` object on success or a
/// `DBTEAMLegalHoldsPolicyUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMLegalHoldPolicy *, DBTEAMLegalHoldsPolicyUpdateError *> *)
legalHoldsUpdatePolicy:(NSString *)id_
                  name:(nullable NSString *)name
          description_:(nullable NSString *)description_
               members:(nullable NSArray<NSString *> *)members;

///
/// List all linked applications of the team member. Note, this endpoint does not list any team-linked applications.
///
/// @param teamMemberId The team member id.
///
/// @return Through the response callback, the caller will receive a `DBTEAMListMemberAppsResult` object on success or a
/// `DBTEAMListMemberAppsError` object on failure.
///
- (DBRpcTask<DBTEAMListMemberAppsResult *, DBTEAMListMemberAppsError *> *)linkedAppsListMemberLinkedApps:
    (NSString *)teamMemberId;

///
/// List all applications linked to the team members' accounts. Note, this endpoint does not list any team-linked
/// applications.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMListMembersAppsResult` object on success or
/// a `DBTEAMListMembersAppsError` object on failure.
///
- (DBRpcTask<DBTEAMListMembersAppsResult *, DBTEAMListMembersAppsError *> *)linkedAppsListMembersLinkedApps;

///
/// List all applications linked to the team members' accounts. Note, this endpoint does not list any team-linked
/// applications.
///
/// @param cursor At the first call to the `linkedAppsListMembersLinkedApps` the cursor shouldn't be passed. Then, if
/// the result of the call includes a cursor, the following requests should include the received cursors in order to
/// receive the next sub list of the team applications.
///
/// @return Through the response callback, the caller will receive a `DBTEAMListMembersAppsResult` object on success or
/// a `DBTEAMListMembersAppsError` object on failure.
///
- (DBRpcTask<DBTEAMListMembersAppsResult *, DBTEAMListMembersAppsError *> *)linkedAppsListMembersLinkedApps:
    (nullable NSString *)cursor;

///
/// DEPRECATED: List all applications linked to the team members' accounts. Note, this endpoint doesn't list any
/// team-linked applications.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMListTeamAppsResult` object on success or a
/// `DBTEAMListTeamAppsError` object on failure.
///
- (DBRpcTask<DBTEAMListTeamAppsResult *, DBTEAMListTeamAppsError *> *)linkedAppsListTeamLinkedApps
    __deprecated_msg("linkedAppsListTeamLinkedApps is deprecated. Use linkedAppsListMembersLinkedApps.");

///
/// DEPRECATED: List all applications linked to the team members' accounts. Note, this endpoint doesn't list any
/// team-linked applications.
///
/// @param cursor At the first call to the `linkedAppsListTeamLinkedApps` the cursor shouldn't be passed. Then, if the
/// result of the call includes a cursor, the following requests should include the received cursors in order to receive
/// the next sub list of the team applications.
///
/// @return Through the response callback, the caller will receive a `DBTEAMListTeamAppsResult` object on success or a
/// `DBTEAMListTeamAppsError` object on failure.
///
- (DBRpcTask<DBTEAMListTeamAppsResult *, DBTEAMListTeamAppsError *> *)linkedAppsListTeamLinkedApps:
    (nullable NSString *)cursor
    __deprecated_msg("linkedAppsListTeamLinkedApps is deprecated. Use linkedAppsListMembersLinkedApps.");

///
/// Revoke a linked application of the team member.
///
/// @param appId The application's unique id.
/// @param teamMemberId The unique id of the member owning the device.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMRevokeLinkedAppError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMRevokeLinkedAppError *> *)linkedAppsRevokeLinkedApp:(NSString *)appId
                                                                         teamMemberId:(NSString *)teamMemberId;

///
/// Revoke a linked application of the team member.
///
/// @param appId The application's unique id.
/// @param teamMemberId The unique id of the member owning the device.
/// @param keepAppFolder This flag is not longer supported, the application dedicated folder (in case the application
/// uses  one) will be kept.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMRevokeLinkedAppError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMRevokeLinkedAppError *> *)linkedAppsRevokeLinkedApp:(NSString *)appId
                                                                         teamMemberId:(NSString *)teamMemberId
                                                                        keepAppFolder:
                                                                            (nullable NSNumber *)keepAppFolder;

///
/// Revoke a list of linked applications of the team members.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMRevokeLinkedAppBatchResult` object on
/// success or a `DBTEAMRevokeLinkedAppBatchError` object on failure.
///
- (DBRpcTask<DBTEAMRevokeLinkedAppBatchResult *, DBTEAMRevokeLinkedAppBatchError *> *)linkedAppsRevokeLinkedAppBatch:
    (NSArray<DBTEAMRevokeLinkedApiAppArg *> *)revokeLinkedApp;

///
/// Add users to member space limits excluded users list.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMExcludedUsersUpdateResult` object on success
/// or a `DBTEAMExcludedUsersUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMExcludedUsersUpdateResult *, DBTEAMExcludedUsersUpdateError *> *)memberSpaceLimitsExcludedUsersAdd;

///
/// Add users to member space limits excluded users list.
///
/// @param users List of users to be added/removed.
///
/// @return Through the response callback, the caller will receive a `DBTEAMExcludedUsersUpdateResult` object on success
/// or a `DBTEAMExcludedUsersUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMExcludedUsersUpdateResult *, DBTEAMExcludedUsersUpdateError *> *)memberSpaceLimitsExcludedUsersAdd:
    (nullable NSArray<DBTEAMUserSelectorArg *> *)users;

///
/// List member space limits excluded users.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMExcludedUsersListResult` object on success
/// or a `DBTEAMExcludedUsersListError` object on failure.
///
- (DBRpcTask<DBTEAMExcludedUsersListResult *, DBTEAMExcludedUsersListError *> *)memberSpaceLimitsExcludedUsersList;

///
/// List member space limits excluded users.
///
/// @param limit Number of results to return per call.
///
/// @return Through the response callback, the caller will receive a `DBTEAMExcludedUsersListResult` object on success
/// or a `DBTEAMExcludedUsersListError` object on failure.
///
- (DBRpcTask<DBTEAMExcludedUsersListResult *, DBTEAMExcludedUsersListError *> *)memberSpaceLimitsExcludedUsersList:
    (nullable NSNumber *)limit;

///
/// Continue listing member space limits excluded users.
///
/// @param cursor Indicates from what point to get the next set of users.
///
/// @return Through the response callback, the caller will receive a `DBTEAMExcludedUsersListResult` object on success
/// or a `DBTEAMExcludedUsersListContinueError` object on failure.
///
- (DBRpcTask<DBTEAMExcludedUsersListResult *, DBTEAMExcludedUsersListContinueError *> *)
memberSpaceLimitsExcludedUsersListContinue:(NSString *)cursor;

///
/// Remove users from member space limits excluded users list.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMExcludedUsersUpdateResult` object on success
/// or a `DBTEAMExcludedUsersUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMExcludedUsersUpdateResult *, DBTEAMExcludedUsersUpdateError *> *)
    memberSpaceLimitsExcludedUsersRemove;

///
/// Remove users from member space limits excluded users list.
///
/// @param users List of users to be added/removed.
///
/// @return Through the response callback, the caller will receive a `DBTEAMExcludedUsersUpdateResult` object on success
/// or a `DBTEAMExcludedUsersUpdateError` object on failure.
///
- (DBRpcTask<DBTEAMExcludedUsersUpdateResult *, DBTEAMExcludedUsersUpdateError *> *)
memberSpaceLimitsExcludedUsersRemove:(nullable NSArray<DBTEAMUserSelectorArg *> *)users;

///
/// Get users custom quota. Returns none as the custom quota if none was set. A maximum of 1000 members can be specified
/// in a single call.
///
/// @param users List of users.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMCustomQuotaResult *>` object on
/// success or a `DBTEAMCustomQuotaError` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMCustomQuotaResult *> *, DBTEAMCustomQuotaError *> *)memberSpaceLimitsGetCustomQuota:
    (NSArray<DBTEAMUserSelectorArg *> *)users;

///
/// Remove users custom quota. A maximum of 1000 members can be specified in a single call.
///
/// @param users List of users.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMRemoveCustomQuotaResult *>` object
/// on success or a `DBTEAMCustomQuotaError` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMRemoveCustomQuotaResult *> *, DBTEAMCustomQuotaError *> *)memberSpaceLimitsRemoveCustomQuota:
    (NSArray<DBTEAMUserSelectorArg *> *)users;

///
/// Set users custom quota. Custom quota has to be at least 15GB. A maximum of 1000 members can be specified in a single
/// call.
///
/// @param usersAndQuotas List of users and their custom quotas.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMCustomQuotaResult *>` object on
/// success or a `DBTEAMSetCustomQuotaError` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMCustomQuotaResult *> *, DBTEAMSetCustomQuotaError *> *)memberSpaceLimitsSetCustomQuota:
    (NSArray<DBTEAMUserCustomQuotaArg *> *)usersAndQuotas;

///
/// Adds members to a team. Permission : Team member management A maximum of 20 members can be specified in a single
/// call. If no Dropbox account exists with the email address specified, a new Dropbox account will be created with the
/// given email address, and that account will be invited to the team. If a personal Dropbox account exists with the
/// email address specified in the call, this call will create a placeholder Dropbox account for the user on the team
/// and send an email inviting the user to migrate their existing personal account onto the team. Team member management
/// apps are required to set an initial given_name and surname for a user to use in the team invitation and for 'Perform
/// as team member' actions taken on the user before they become 'active'.
///
/// @param dNewMembers Details of new members to be added to the team.
///
/// @return Through the response callback, the caller will receive a `DBTEAMMembersAddLaunch` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBTEAMMembersAddLaunch *, DBNilObject *> *)membersAdd:(NSArray<DBTEAMMemberAddArg *> *)dNewMembers;

///
/// Adds members to a team. Permission : Team member management A maximum of 20 members can be specified in a single
/// call. If no Dropbox account exists with the email address specified, a new Dropbox account will be created with the
/// given email address, and that account will be invited to the team. If a personal Dropbox account exists with the
/// email address specified in the call, this call will create a placeholder Dropbox account for the user on the team
/// and send an email inviting the user to migrate their existing personal account onto the team. Team member management
/// apps are required to set an initial given_name and surname for a user to use in the team invitation and for 'Perform
/// as team member' actions taken on the user before they become 'active'.
///
/// @param dNewMembers Details of new members to be added to the team.
/// @param forceAsync Whether to force the add to happen asynchronously.
///
/// @return Through the response callback, the caller will receive a `DBTEAMMembersAddLaunch` object on success or a
/// `void` object on failure.
///
- (DBRpcTask<DBTEAMMembersAddLaunch *, DBNilObject *> *)membersAdd:(NSArray<DBTEAMMemberAddArg *> *)dNewMembers
                                                        forceAsync:(nullable NSNumber *)forceAsync;

///
/// Once an async_job_id is returned from `membersAdd` , use this to poll the status of the asynchronous request.
/// Permission : Team member management.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBTEAMMembersAddJobStatus` object on success or a
/// `DBASYNCPollError` object on failure.
///
- (DBRpcTask<DBTEAMMembersAddJobStatus *, DBASYNCPollError *> *)membersAddJobStatusGet:(NSString *)asyncJobId;

///
/// Deletes a team member's profile photo. Permission : Team member management.
///
/// @param user Identity of the user whose profile photo will be deleted.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamMemberInfo` object on success or a
/// `DBTEAMMembersDeleteProfilePhotoError` object on failure.
///
- (DBRpcTask<DBTEAMTeamMemberInfo *, DBTEAMMembersDeleteProfilePhotoError *> *)membersDeleteProfilePhoto:
    (DBTEAMUserSelectorArg *)user;

///
/// Returns information about multiple team members. Permission : Team information This endpoint will return
/// `idNotFound` in `DBTEAMMembersGetInfoItem`, for IDs (or emails) that cannot be matched to a valid team member.
///
/// @param members List of team members.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMMembersGetInfoItem *>` object on
/// success or a `DBTEAMMembersGetInfoError` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMMembersGetInfoItem *> *, DBTEAMMembersGetInfoError *> *)membersGetInfo:
    (NSArray<DBTEAMUserSelectorArg *> *)members;

///
/// Lists members of a team. Permission : Team information.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMMembersListResult` object on success or a
/// `DBTEAMMembersListError` object on failure.
///
- (DBRpcTask<DBTEAMMembersListResult *, DBTEAMMembersListError *> *)membersList;

///
/// Lists members of a team. Permission : Team information.
///
/// @param limit Number of results to return per call.
/// @param includeRemoved Whether to return removed members.
///
/// @return Through the response callback, the caller will receive a `DBTEAMMembersListResult` object on success or a
/// `DBTEAMMembersListError` object on failure.
///
- (DBRpcTask<DBTEAMMembersListResult *, DBTEAMMembersListError *> *)membersList:(nullable NSNumber *)limit
                                                                 includeRemoved:(nullable NSNumber *)includeRemoved;

///
/// Once a cursor has been retrieved from `membersList`, use this to paginate through all team members. Permission :
/// Team information.
///
/// @param cursor Indicates from what point to get the next set of members.
///
/// @return Through the response callback, the caller will receive a `DBTEAMMembersListResult` object on success or a
/// `DBTEAMMembersListContinueError` object on failure.
///
- (DBRpcTask<DBTEAMMembersListResult *, DBTEAMMembersListContinueError *> *)membersListContinue:(NSString *)cursor;

///
/// Moves removed member's files to a different member. This endpoint initiates an asynchronous job. To obtain the final
/// result of the job, the client should periodically poll `membersMoveFormerMemberFilesJobStatusCheck`. Permission :
/// Team member management.
///
/// @param transferDestId Files from the deleted member account will be transferred to this user.
/// @param transferAdminId Errors during the transfer process will be sent via email to this user.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBTEAMMembersTransferFormerMembersFilesError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBTEAMMembersTransferFormerMembersFilesError *> *)
membersMoveFormerMemberFiles:(DBTEAMUserSelectorArg *)user
              transferDestId:(DBTEAMUserSelectorArg *)transferDestId
             transferAdminId:(DBTEAMUserSelectorArg *)transferAdminId;

///
/// Once an async_job_id is returned from `membersMoveFormerMemberFiles` , use this to poll the status of the
/// asynchronous request. Permission : Team member management.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBASYNCPollEmptyResult` object on success or a
/// `DBASYNCPollError` object on failure.
///
- (DBRpcTask<DBASYNCPollEmptyResult *, DBASYNCPollError *> *)membersMoveFormerMemberFilesJobStatusCheck:
    (NSString *)asyncJobId;

///
/// Recover a deleted member. Permission : Team member management Exactly one of team_member_id, email, or external_id
/// must be provided to identify the user account.
///
/// @param user Identity of user to recover.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMMembersRecoverError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMMembersRecoverError *> *)membersRecover:(DBTEAMUserSelectorArg *)user;

///
/// Removes a member from a team. Permission : Team member management Exactly one of team_member_id, email, or
/// external_id must be provided to identify the user account. Accounts can be recovered via `membersRecover` for a 7
/// day period or until the account has been permanently deleted or transferred to another account (whichever comes
/// first). Calling `membersAdd` while a user is still recoverable on your team will return with `userAlreadyOnTeam` in
/// `DBTEAMMemberAddResult`. Accounts can have their files transferred via the admin console for a limited time, based
/// on the version history length associated with the team (180 days for most teams). This endpoint may initiate an
/// asynchronous job. To obtain the final result of the job, the client should periodically poll
/// `membersRemoveJobStatusGet`.
///
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBTEAMMembersRemoveError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBTEAMMembersRemoveError *> *)membersRemove:(DBTEAMUserSelectorArg *)user;

///
/// Removes a member from a team. Permission : Team member management Exactly one of team_member_id, email, or
/// external_id must be provided to identify the user account. Accounts can be recovered via `membersRecover` for a 7
/// day period or until the account has been permanently deleted or transferred to another account (whichever comes
/// first). Calling `membersAdd` while a user is still recoverable on your team will return with `userAlreadyOnTeam` in
/// `DBTEAMMemberAddResult`. Accounts can have their files transferred via the admin console for a limited time, based
/// on the version history length associated with the team (180 days for most teams). This endpoint may initiate an
/// asynchronous job. To obtain the final result of the job, the client should periodically poll
/// `membersRemoveJobStatusGet`.
///
/// @param transferDestId If provided, files from the deleted member account will be transferred to this user.
/// @param transferAdminId If provided, errors during the transfer process will be sent via email to this user. If the
/// transfer_dest_id argument was provided, then this argument must be provided as well.
/// @param keepAccount Downgrade the member to a Basic account. The user will retain the email address associated with
/// their Dropbox  account and data in their account that is not restricted to team members. In order to keep the
/// account the argument wipeData should be set to false.
/// @param retainTeamShares If provided, allows removed users to keep access to Dropbox folders (not Dropbox Paper
/// folders) already explicitly shared with them (not via a group) when they are downgraded to a Basic account. Users
/// will not retain access to folders that do not allow external sharing. In order to keep the sharing relationships,
/// the arguments wipeData should be set to false and keepAccount should be set to true.
///
/// @return Through the response callback, the caller will receive a `DBASYNCLaunchEmptyResult` object on success or a
/// `DBTEAMMembersRemoveError` object on failure.
///
- (DBRpcTask<DBASYNCLaunchEmptyResult *, DBTEAMMembersRemoveError *> *)
   membersRemove:(DBTEAMUserSelectorArg *)user
        wipeData:(nullable NSNumber *)wipeData
  transferDestId:(nullable DBTEAMUserSelectorArg *)transferDestId
 transferAdminId:(nullable DBTEAMUserSelectorArg *)transferAdminId
     keepAccount:(nullable NSNumber *)keepAccount
retainTeamShares:(nullable NSNumber *)retainTeamShares;

///
/// Once an async_job_id is returned from `membersRemove` , use this to poll the status of the asynchronous request.
/// Permission : Team member management.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBASYNCPollEmptyResult` object on success or a
/// `DBASYNCPollError` object on failure.
///
- (DBRpcTask<DBASYNCPollEmptyResult *, DBASYNCPollError *> *)membersRemoveJobStatusGet:(NSString *)asyncJobId;

///
/// Add secondary emails to users. Permission : Team member management. Emails that are on verified domains will be
/// verified automatically. For each email address not on a verified domain a verification email will be sent.
///
/// @param dNewSecondaryEmails List of users and secondary emails to add.
///
/// @return Through the response callback, the caller will receive a `DBTEAMAddSecondaryEmailsResult` object on success
/// or a `DBTEAMAddSecondaryEmailsError` object on failure.
///
- (DBRpcTask<DBTEAMAddSecondaryEmailsResult *, DBTEAMAddSecondaryEmailsError *> *)membersSecondaryEmailsAdd:
    (NSArray<DBTEAMUserSecondaryEmailsArg *> *)dNewSecondaryEmails;

///
/// Delete secondary emails from users Permission : Team member management. Users will be notified of deletions of
/// verified secondary emails at both the secondary email and their primary email.
///
/// @param emailsToDelete List of users and their secondary emails to delete.
///
/// @return Through the response callback, the caller will receive a `DBTEAMDeleteSecondaryEmailsResult` object on
/// success or a `void` object on failure.
///
- (DBRpcTask<DBTEAMDeleteSecondaryEmailsResult *, DBNilObject *> *)membersSecondaryEmailsDelete:
    (NSArray<DBTEAMUserSecondaryEmailsArg *> *)emailsToDelete;

///
/// Resend secondary email verification emails. Permission : Team member management.
///
/// @param emailsToResend List of users and secondary emails to resend verification emails to.
///
/// @return Through the response callback, the caller will receive a `DBTEAMResendVerificationEmailResult` object on
/// success or a `void` object on failure.
///
- (DBRpcTask<DBTEAMResendVerificationEmailResult *, DBNilObject *> *)membersSecondaryEmailsResendVerificationEmails:
    (NSArray<DBTEAMUserSecondaryEmailsArg *> *)emailsToResend;

///
/// Sends welcome email to pending team member. Permission : Team member management Exactly one of team_member_id,
/// email, or external_id must be provided to identify the user account. No-op if team member is not pending.
///
/// @param userSelectorArg Argument for selecting a single user, either by team_member_id, external_id or email.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMMembersSendWelcomeError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMMembersSendWelcomeError *> *)membersSendWelcomeEmail:
    (DBTEAMUserSelectorArg *)userSelectorArg;

///
/// Updates a team member's permissions. Permission : Team member management.
///
/// @param user Identity of user whose role will be set.
/// @param dNewRole The new role of the member.
///
/// @return Through the response callback, the caller will receive a `DBTEAMMembersSetPermissionsResult` object on
/// success or a `DBTEAMMembersSetPermissionsError` object on failure.
///
- (DBRpcTask<DBTEAMMembersSetPermissionsResult *, DBTEAMMembersSetPermissionsError *> *)
membersSetAdminPermissions:(DBTEAMUserSelectorArg *)user
                  dNewRole:(DBTEAMAdminTier *)dNewRole;

///
/// Updates a team member's profile. Permission : Team member management.
///
/// @param user Identity of user whose profile will be set.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamMemberInfo` object on success or a
/// `DBTEAMMembersSetProfileError` object on failure.
///
- (DBRpcTask<DBTEAMTeamMemberInfo *, DBTEAMMembersSetProfileError *> *)membersSetProfile:(DBTEAMUserSelectorArg *)user;

///
/// Updates a team member's profile. Permission : Team member management.
///
/// @param user Identity of user whose profile will be set.
/// @param dNewEmail New email for member.
/// @param dNewExternalId New external ID for member.
/// @param dNewGivenName New given name for member.
/// @param dNewSurname New surname for member.
/// @param dNewPersistentId New persistent ID. This field only available to teams using persistent ID SAML
/// configuration.
/// @param dNewIsDirectoryRestricted New value for whether the user is a directory restricted user.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamMemberInfo` object on success or a
/// `DBTEAMMembersSetProfileError` object on failure.
///
- (DBRpcTask<DBTEAMTeamMemberInfo *, DBTEAMMembersSetProfileError *> *)
        membersSetProfile:(DBTEAMUserSelectorArg *)user
                dNewEmail:(nullable NSString *)dNewEmail
           dNewExternalId:(nullable NSString *)dNewExternalId
            dNewGivenName:(nullable NSString *)dNewGivenName
              dNewSurname:(nullable NSString *)dNewSurname
         dNewPersistentId:(nullable NSString *)dNewPersistentId
dNewIsDirectoryRestricted:(nullable NSNumber *)dNewIsDirectoryRestricted;

///
/// Updates a team member's profile photo. Permission : Team member management.
///
/// @param user Identity of the user whose profile photo will be set.
/// @param photo Image to set as the member's new profile photo.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamMemberInfo` object on success or a
/// `DBTEAMMembersSetProfilePhotoError` object on failure.
///
- (DBRpcTask<DBTEAMTeamMemberInfo *, DBTEAMMembersSetProfilePhotoError *> *)
membersSetProfilePhoto:(DBTEAMUserSelectorArg *)user
                 photo:(DBACCOUNTPhotoSourceArg *)photo;

///
/// Suspend a member from a team. Permission : Team member management Exactly one of team_member_id, email, or
/// external_id must be provided to identify the user account.
///
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMMembersSuspendError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMMembersSuspendError *> *)membersSuspend:(DBTEAMUserSelectorArg *)user;

///
/// Suspend a member from a team. Permission : Team member management Exactly one of team_member_id, email, or
/// external_id must be provided to identify the user account.
///
/// @param wipeData If provided, controls if the user's data will be deleted on their linked devices.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMMembersSuspendError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMMembersSuspendError *> *)membersSuspend:(DBTEAMUserSelectorArg *)user
                                                                 wipeData:(nullable NSNumber *)wipeData;

///
/// Unsuspend a member from a team. Permission : Team member management Exactly one of team_member_id, email, or
/// external_id must be provided to identify the user account.
///
/// @param user Identity of user to unsuspend.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMMembersUnsuspendError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMMembersUnsuspendError *> *)membersUnsuspend:(DBTEAMUserSelectorArg *)user;

///
/// Returns a list of all team-accessible namespaces. This list includes team folders, shared folders containing team
/// members, team members' home namespaces, and team members' app folders. Home namespaces and app folders are always
/// owned by this team or members of the team, but shared folders may be owned by other users or other teams. Duplicates
/// may occur in the list.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamNamespacesListResult` object on success
/// or a `DBTEAMTeamNamespacesListError` object on failure.
///
- (DBRpcTask<DBTEAMTeamNamespacesListResult *, DBTEAMTeamNamespacesListError *> *)namespacesList;

///
/// Returns a list of all team-accessible namespaces. This list includes team folders, shared folders containing team
/// members, team members' home namespaces, and team members' app folders. Home namespaces and app folders are always
/// owned by this team or members of the team, but shared folders may be owned by other users or other teams. Duplicates
/// may occur in the list.
///
/// @param limit Specifying a value here has no effect.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamNamespacesListResult` object on success
/// or a `DBTEAMTeamNamespacesListError` object on failure.
///
- (DBRpcTask<DBTEAMTeamNamespacesListResult *, DBTEAMTeamNamespacesListError *> *)namespacesList:
    (nullable NSNumber *)limit;

///
/// Once a cursor has been retrieved from `namespacesList`, use this to paginate through all team-accessible namespaces.
/// Duplicates may occur in the list.
///
/// @param cursor Indicates from what point to get the next set of team-accessible namespaces.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamNamespacesListResult` object on success
/// or a `DBTEAMTeamNamespacesListContinueError` object on failure.
///
- (DBRpcTask<DBTEAMTeamNamespacesListResult *, DBTEAMTeamNamespacesListContinueError *> *)namespacesListContinue:
    (NSString *)cursor;

///
/// DEPRECATED: Permission : Team member file access.
///
///
/// @return Through the response callback, the caller will receive a `DBFILEPROPERTIESAddTemplateResult` object on
/// success or a `DBFILEPROPERTIESModifyTemplateError` object on failure.
///
- (DBRpcTask<DBFILEPROPERTIESAddTemplateResult *, DBFILEPROPERTIESModifyTemplateError *> *)
propertiesTemplateAdd:(NSString *)name
         description_:(NSString *)description_
               fields:(NSArray<DBFILEPROPERTIESPropertyFieldTemplate *> *)fields
    __deprecated_msg("propertiesTemplateAdd is deprecated.");

///
/// DEPRECATED: Permission : Team member file access. The scope for the route is files.team_metadata.write.
///
/// @param templateId An identifier for template added by route  See `templatesAddForUser` or `templatesAddForTeam`.
///
/// @return Through the response callback, the caller will receive a `DBFILEPROPERTIESGetTemplateResult` object on
/// success or a `DBFILEPROPERTIESTemplateError` object on failure.
///
- (DBRpcTask<DBFILEPROPERTIESGetTemplateResult *, DBFILEPROPERTIESTemplateError *> *)propertiesTemplateGet:
    (NSString *)templateId __deprecated_msg("propertiesTemplateGet is deprecated.");

///
/// DEPRECATED: Permission : Team member file access. The scope for the route is files.team_metadata.write.
///
///
/// @return Through the response callback, the caller will receive a `DBFILEPROPERTIESListTemplateResult` object on
/// success or a `DBFILEPROPERTIESTemplateError` object on failure.
///
- (DBRpcTask<DBFILEPROPERTIESListTemplateResult *, DBFILEPROPERTIESTemplateError *> *)propertiesTemplateList
    __deprecated_msg("propertiesTemplateList is deprecated.");

///
/// DEPRECATED: Permission : Team member file access.
///
/// @param templateId An identifier for template added by  See `templatesAddForUser` or `templatesAddForTeam`.
///
/// @return Through the response callback, the caller will receive a `DBFILEPROPERTIESUpdateTemplateResult` object on
/// success or a `DBFILEPROPERTIESModifyTemplateError` object on failure.
///
- (DBRpcTask<DBFILEPROPERTIESUpdateTemplateResult *, DBFILEPROPERTIESModifyTemplateError *> *)propertiesTemplateUpdate:
    (NSString *)templateId __deprecated_msg("propertiesTemplateUpdate is deprecated.");

///
/// DEPRECATED: Permission : Team member file access.
///
/// @param templateId An identifier for template added by  See `templatesAddForUser` or `templatesAddForTeam`.
/// @param name A display name for the template. template names can be up to 256 bytes.
/// @param description_ Description for the new template. Template descriptions can be up to 1024 bytes.
/// @param addFields Property field templates to be added to the group template. There can be up to 32 properties in a
/// single template.
///
/// @return Through the response callback, the caller will receive a `DBFILEPROPERTIESUpdateTemplateResult` object on
/// success or a `DBFILEPROPERTIESModifyTemplateError` object on failure.
///
- (DBRpcTask<DBFILEPROPERTIESUpdateTemplateResult *, DBFILEPROPERTIESModifyTemplateError *> *)
propertiesTemplateUpdate:(NSString *)templateId
                    name:(nullable NSString *)name
            description_:(nullable NSString *)description_
               addFields:(nullable NSArray<DBFILEPROPERTIESPropertyFieldTemplate *> *)addFields
    __deprecated_msg("propertiesTemplateUpdate is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's user activity. Deprecated: Will be removed on July 1st 2021.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetActivityReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetActivityReport *, DBTEAMDateRangeError *> *)reportsGetActivity
    __deprecated_msg("reportsGetActivity is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's user activity. Deprecated: Will be removed on July 1st 2021.
///
/// @param startDate Optional starting date (inclusive). If start_date is None or too long ago, this field will  be set
/// to 6 months ago.
/// @param endDate Optional ending date (exclusive).
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetActivityReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetActivityReport *, DBTEAMDateRangeError *> *)reportsGetActivity:(nullable NSDate *)startDate
                                                                             endDate:(nullable NSDate *)endDate
    __deprecated_msg("reportsGetActivity is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's linked devices. Deprecated: Will be removed on July 1st 2021.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetDevicesReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetDevicesReport *, DBTEAMDateRangeError *> *)reportsGetDevices
    __deprecated_msg("reportsGetDevices is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's linked devices. Deprecated: Will be removed on July 1st 2021.
///
/// @param startDate Optional starting date (inclusive). If start_date is None or too long ago, this field will  be set
/// to 6 months ago.
/// @param endDate Optional ending date (exclusive).
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetDevicesReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetDevicesReport *, DBTEAMDateRangeError *> *)reportsGetDevices:(nullable NSDate *)startDate
                                                                           endDate:(nullable NSDate *)endDate
    __deprecated_msg("reportsGetDevices is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's membership. Deprecated: Will be removed on July 1st 2021.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetMembershipReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetMembershipReport *, DBTEAMDateRangeError *> *)reportsGetMembership
    __deprecated_msg("reportsGetMembership is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's membership. Deprecated: Will be removed on July 1st 2021.
///
/// @param startDate Optional starting date (inclusive). If start_date is None or too long ago, this field will  be set
/// to 6 months ago.
/// @param endDate Optional ending date (exclusive).
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetMembershipReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetMembershipReport *, DBTEAMDateRangeError *> *)reportsGetMembership:(nullable NSDate *)startDate
                                                                                 endDate:(nullable NSDate *)endDate
    __deprecated_msg("reportsGetMembership is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's storage usage. Deprecated: Will be removed on July 1st 2021.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetStorageReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetStorageReport *, DBTEAMDateRangeError *> *)reportsGetStorage
    __deprecated_msg("reportsGetStorage is deprecated.");

///
/// DEPRECATED: Retrieves reporting data about a team's storage usage. Deprecated: Will be removed on July 1st 2021.
///
/// @param startDate Optional starting date (inclusive). If start_date is None or too long ago, this field will  be set
/// to 6 months ago.
/// @param endDate Optional ending date (exclusive).
///
/// @return Through the response callback, the caller will receive a `DBTEAMGetStorageReport` object on success or a
/// `DBTEAMDateRangeError` object on failure.
///
- (DBRpcTask<DBTEAMGetStorageReport *, DBTEAMDateRangeError *> *)reportsGetStorage:(nullable NSDate *)startDate
                                                                           endDate:(nullable NSDate *)endDate
    __deprecated_msg("reportsGetStorage is deprecated.");

///
/// Sets an archived team folder's status to active. Permission : Team member file access.
///
/// @param teamFolderId The ID of the team folder.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderMetadata` object on success or a
/// `DBTEAMTeamFolderActivateError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderMetadata *, DBTEAMTeamFolderActivateError *> *)teamFolderActivate:(NSString *)teamFolderId;

///
/// Sets an active team folder's status to archived and removes all folder and file members. Permission : Team member
/// file access.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderArchiveLaunch` object on success
/// or a `DBTEAMTeamFolderArchiveError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderArchiveLaunch *, DBTEAMTeamFolderArchiveError *> *)teamFolderArchive:
    (NSString *)teamFolderId;

///
/// Sets an active team folder's status to archived and removes all folder and file members. Permission : Team member
/// file access.
///
/// @param forceAsyncOff Whether to force the archive to happen synchronously.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderArchiveLaunch` object on success
/// or a `DBTEAMTeamFolderArchiveError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderArchiveLaunch *, DBTEAMTeamFolderArchiveError *> *)
teamFolderArchive:(NSString *)teamFolderId
    forceAsyncOff:(nullable NSNumber *)forceAsyncOff;

///
/// Returns the status of an asynchronous job for archiving a team folder. Permission : Team member file access.
///
/// @param asyncJobId Id of the asynchronous job. This is the value of a response returned from the method that launched
/// the job.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderArchiveJobStatus` object on
/// success or a `DBASYNCPollError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderArchiveJobStatus *, DBASYNCPollError *> *)teamFolderArchiveCheck:(NSString *)asyncJobId;

///
/// Creates a new, active, team folder with no members. Permission : Team member file access.
///
/// @param name Name for the new team folder.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderMetadata` object on success or a
/// `DBTEAMTeamFolderCreateError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderMetadata *, DBTEAMTeamFolderCreateError *> *)teamFolderCreate:(NSString *)name;

///
/// Creates a new, active, team folder with no members. Permission : Team member file access.
///
/// @param name Name for the new team folder.
/// @param syncSetting The sync setting to apply to this team folder. Only permitted if the team has team selective sync
/// enabled.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderMetadata` object on success or a
/// `DBTEAMTeamFolderCreateError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderMetadata *, DBTEAMTeamFolderCreateError *> *)
teamFolderCreate:(NSString *)name
     syncSetting:(nullable DBFILESSyncSettingArg *)syncSetting;

///
/// Retrieves metadata for team folders. Permission : Team member file access.
///
/// @param teamFolderIds The list of team folder IDs.
///
/// @return Through the response callback, the caller will receive a `NSArray<DBTEAMTeamFolderGetInfoItem *>` object on
/// success or a `void` object on failure.
///
- (DBRpcTask<NSArray<DBTEAMTeamFolderGetInfoItem *> *, DBNilObject *> *)teamFolderGetInfo:
    (NSArray<NSString *> *)teamFolderIds;

///
/// Lists all team folders. Permission : Team member file access.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderListResult` object on success or a
/// `DBTEAMTeamFolderListError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderListResult *, DBTEAMTeamFolderListError *> *)teamFolderList;

///
/// Lists all team folders. Permission : Team member file access.
///
/// @param limit The maximum number of results to return per request.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderListResult` object on success or a
/// `DBTEAMTeamFolderListError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderListResult *, DBTEAMTeamFolderListError *> *)teamFolderList:(nullable NSNumber *)limit;

///
/// Once a cursor has been retrieved from `teamFolderList`, use this to paginate through all team folders. Permission :
/// Team member file access.
///
/// @param cursor Indicates from what point to get the next set of team folders.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderListResult` object on success or a
/// `DBTEAMTeamFolderListContinueError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderListResult *, DBTEAMTeamFolderListContinueError *> *)teamFolderListContinue:
    (NSString *)cursor;

///
/// Permanently deletes an archived team folder. Permission : Team member file access.
///
/// @param teamFolderId The ID of the team folder.
///
/// @return Through the response callback, the caller will receive a `void` object on success or a
/// `DBTEAMTeamFolderPermanentlyDeleteError` object on failure.
///
- (DBRpcTask<DBNilObject *, DBTEAMTeamFolderPermanentlyDeleteError *> *)teamFolderPermanentlyDelete:
    (NSString *)teamFolderId;

///
/// Changes an active team folder's name. Permission : Team member file access.
///
/// @param name New team folder name.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderMetadata` object on success or a
/// `DBTEAMTeamFolderRenameError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderMetadata *, DBTEAMTeamFolderRenameError *> *)teamFolderRename:(NSString *)teamFolderId
                                                                                      name:(NSString *)name;

///
/// Updates the sync settings on a team folder or its contents.  Use of this endpoint requires that the team has team
/// selective sync enabled.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderMetadata` object on success or a
/// `DBTEAMTeamFolderUpdateSyncSettingsError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderMetadata *, DBTEAMTeamFolderUpdateSyncSettingsError *> *)teamFolderUpdateSyncSettings:
    (NSString *)teamFolderId;

///
/// Updates the sync settings on a team folder or its contents.  Use of this endpoint requires that the team has team
/// selective sync enabled.
///
/// @param syncSetting Sync setting to apply to the team folder itself. Only meaningful if the team folder is not a
/// shared team root.
/// @param contentSyncSettings Sync settings to apply to contents of this team folder.
///
/// @return Through the response callback, the caller will receive a `DBTEAMTeamFolderMetadata` object on success or a
/// `DBTEAMTeamFolderUpdateSyncSettingsError` object on failure.
///
- (DBRpcTask<DBTEAMTeamFolderMetadata *, DBTEAMTeamFolderUpdateSyncSettingsError *> *)
teamFolderUpdateSyncSettings:(NSString *)teamFolderId
                 syncSetting:(nullable DBFILESSyncSettingArg *)syncSetting
         contentSyncSettings:(nullable NSArray<DBFILESContentSyncSettingArg *> *)contentSyncSettings;

///
/// Returns the member profile of the admin who generated the team access token used to make the call.
///
///
/// @return Through the response callback, the caller will receive a `DBTEAMTokenGetAuthenticatedAdminResult` object on
/// success or a `DBTEAMTokenGetAuthenticatedAdminError` object on failure.
///
- (DBRpcTask<DBTEAMTokenGetAuthenticatedAdminResult *, DBTEAMTokenGetAuthenticatedAdminError *> *)
    tokenGetAuthenticatedAdmin;

@end

NS_ASSUME_NONNULL_END
